package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Lazy(true)
@Component("RestClientUtils_JStore")
public class RestClientUtils_JStore extends RestClientUtils
{

    @Override
    public ServiceResponse sendRequest(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes, JSONArray valDatas,
                                       boolean isArray) throws Exception
    {
        String sign;
        String client = ent.getSrvConfig("appId", true);
        String exeinfo = "";
        String para = "";
        String compression = "0";
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        JSONObject json = new JSONObject();
        json.put("SHOPID", ent.getSrvConfig("shop_id", false));
        json.put("USERID", ent.getSrvConfig("user_id", false));
        exeinfo = json.toJSONString();
        JSONObject jsonpara = new JSONObject();
        jsonpara.put("COLUMNTYPE", valTypes);
        jsonpara.put("PARAMETER", valDatas);
        json.clear();
        json.put(apiKey, jsonpara);
        para = json.toJSONString();
        String md5Str = ent.getSrvConfig("appKey", true).concat("apiid").concat(apiid).concat("client").concat(client).concat("compression").concat(
                compression).concat("exeinfo").concat(exeinfo).concat("para").concat(para).concat("timestamp").concat(timestamp).concat(ent.getSrvConfig("appKey", true));
        sign = MD5Utils.MD5(md5Str);
        long time = System.currentTimeMillis();
        // 发送请求
        StringBuffer sb = new StringBuffer();
        sb.append("apiid=");
        sb.append(apiid);
        sb.append("&");
        sb.append("client=");
        sb.append(client);
        sb.append("&");
        sb.append("compression=");
        sb.append(compression);
        sb.append("&");
        sb.append("exeinfo=");
        sb.append(exeinfo);
        sb.append("&");
        sb.append("para=");
        sb.append(URLEncoder.encode(para, "UTF-8"));
        sb.append("&");
        sb.append("sign=");
        sb.append(sign);
        sb.append("&");
        sb.append("timestamp=");
        sb.append(timestamp);
        String content = sb.toString();
        //		ServiceLogs.debuglog("", "jstore.client.url: " + ent.getBase_url(), 0);
        //		ServiceLogs.debuglog("", "jstore.client.data: " + content, 0);
        String result = (String) RestClientUtils.getRestUtils().sendRequest(session, ent.getBase_url(), content,
                new defaultRequestCallback(), "notrace");
        //		String result = getResult(ent.getBase_url(), content, "UTF-8");
        ServiceLogs.debuglog("", "jstore.client.result:".concat(result), 0);

        //		ServiceLogs.debuglog("", "jstore.client.result: " + result, 0);
        //		ServiceLogs.debuglog("", "jstore.client.elapsed: " + (System.currentTimeMillis() - time) + " ms", 0);
        if (result != null) {
            json = JSON.parseObject((String) result);

            if (!"1".equals(json.getString("status"))) {
                throw new ServiceException(ResponseCode.FAILURE, json.getString("info"));
            }
        }
        else {
            throw new RuntimeException("No result!");
        }

        json = JSON.parseObject(json.getString("value"));
        JSONObject jsonData = parseJStoreData(json, apiKey);

        if (jsonData.containsKey(apiKey)) {
            if (jsonData.getJSONArray(apiKey).size() > 0 && jsonData.getJSONArray(apiKey).getJSONObject(0).containsKey("code")) {
                int code = jsonData.getJSONArray(apiKey).getJSONObject(0).getInteger("code");

                if (code != 0) {
                    String msg;

                    if (jsonData.getJSONArray(apiKey).getJSONObject(0).containsKey("msg")) {
                        msg = jsonData.getJSONArray(apiKey).getJSONObject(0).getString("msg");
                    }
                    else {
                        msg = "unknow error!";
                    }

                    throw new ServiceException(ResponseCode.FAILURE, "调用失败：{0}-{1}", String.valueOf(code), msg);
                }
            }
        }
        else {
            throw new ServiceException(ResponseCode.FAILURE, "返回数据错误！");
        }

        if (isArray) {
            return ServiceResponse.buildSuccess(jsonData);
            //			return jsonData;
        }
        else {
            if (jsonData.getJSONArray(apiKey).size() > 0) {
                return ServiceResponse.buildSuccess(jsonData.getJSONArray(apiKey).getJSONObject(0));
                //				return jsonData.getJSONArray(apiKey).getJSONObject(0);
            }
            else {
                return ServiceResponse.buildSuccess(null);
                //				return new JSONObject();
            }
        }
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes,
                                       JSONArray valDatas) throws Exception
    {
        ServiceResponse response = this.sendRequest(session, ent, apiid, apiKey, valTypes, valDatas, true);
        JSONObject result = (JSONObject) response.getData();
        return ServiceResponse.buildSuccess(result.getJSONArray(apiKey));
    }

    //	public static JSONObject invoke(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes, JSONArray valDatas, boolean isArray) throws Exception
    //	{
    //		String sign = null;
    //		String client = ent.getSrvConfig("appId", true);
    //		String exeinfo = "";
    //		String para = "";
    //		String compression = "0";
    //		String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    //		JSONObject json = new JSONObject();
    //		json.put("SHOPID", ent.getSrvConfig("shop_id", false));
    //		json.put("USERID", ent.getSrvConfig("user_id", false));
    //		exeinfo = json.toJSONString();
    //
    //		JSONObject jsonpara = new JSONObject();
    //		jsonpara.put("COLUMNTYPE", valTypes);
    //		jsonpara.put("PARAMETER", valDatas);
    //		json.clear();
    //		json.put(apiKey, jsonpara);
    //		para = json.toJSONString();
    //
    //		String md5Str = ent.getSrvConfig("appKey", true).concat("apiid").concat(apiid).concat("client").concat(client).concat("compression").concat(compression).concat("exeinfo").concat(exeinfo).concat("para").concat(para).concat("timestamp").concat(timestamp).concat(ent.getSrvConfig("appKey", true));
    //		sign = MD5Utils.MD5(md5Str);
    //		long time = System.currentTimeMillis();
    //
    //		// 发送请求
    //		StringBuffer sb = new StringBuffer();
    //		sb.append("apiid=");
    //		sb.append(apiid);
    //		sb.append("&");
    //		sb.append("client=");
    //		sb.append(client);
    //		sb.append("&");
    //		sb.append("compression=");
    //		sb.append(compression);
    //		sb.append("&");
    //		sb.append("exeinfo=");
    //		sb.append(exeinfo);
    //		sb.append("&");
    //		sb.append("para=");
    //		sb.append(URLEncoder.encode(para, "UTF-8"));
    //		sb.append("&");
    //		sb.append("sign=");
    //		sb.append(sign);
    //		sb.append("&");
    //		sb.append("timestamp=");
    //		sb.append(timestamp);
    //		String content = sb.toString();
    //
    //		ServiceLogs.debuglog("", "jstore.client.url: " + ent.getBase_url());
    //		ServiceLogs.debuglog("", "jstore.client.data: " + content);
    //
    //		String result = getResult(ent.getBase_url(), content, "UTF-8");
    //		ServiceLogs.debuglog("", "jstore.client.result: " + result);
    //		ServiceLogs.debuglog("", "jstore.client.elapsed: " + (System.currentTimeMillis() - time) + " ms");
    //		if (result != null)
    //		{
    //			json = JSON.parseObject((String) result);
    //			if (!"1".equals(json.getString("status")))
    //			{
    //				throw new ServiceException(ResponseCode.FAILURE, json.getString("info"));
    //			}
    //		}
    //		else
    //		{
    //			throw new RuntimeException("No result!");
    //		}
    //		json = JSON.parseObject(json.getString("value"));
    //		JSONObject jsonData = parseJStoreData(json, apiKey);
    //
    //		if (jsonData.containsKey(apiKey))
    //		{
    //			if (jsonData.getJSONArray(apiKey).size() > 0 && jsonData.getJSONArray(apiKey).getJSONObject(0).containsKey("code"))
    //			{
    //				int code = jsonData.getJSONArray(apiKey).getJSONObject(0).getInteger("code");
    //				if ( code != 0)
    //				{
    //					String msg ;
    //					if (jsonData.getJSONArray(apiKey).getJSONObject(0).containsKey("msg"))
    //					{
    //						msg = jsonData.getJSONArray(apiKey).getJSONObject(0).getString("msg");
    //					}
    //					else
    //					{
    //						msg = "unknow error!";
    //					}
    //					throw new ServiceException(ResponseCode.FAILURE, "调用失败：{0}-{1}",String.valueOf(code), msg);
    //				}
    //			}
    //		}
    //		else
    //		{
    //			throw new ServiceException(ResponseCode.FAILURE, "返回数据错误！");
    //		}
    //		if (isArray)
    //		{
    //			return jsonData;
    //		}
    //		else
    //		{
    //			if (jsonData.getJSONArray(apiKey).size() > 0)
    //			{
    //				return jsonData.getJSONArray(apiKey).getJSONObject(0);
    //			}
    //			else
    //			{
    //				return new JSONObject();
    //			}
    //		}
    //	}

    //	public static JSONArray invoke(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes, JSONArray valDatas) throws Exception
    //	{
    //		JSONObject result = invoke(session, ent, apiid, apiKey, valTypes, valDatas, true);
    //		return result.getJSONArray(apiKey);
    //	}

    private static JSONObject parseJStoreData(JSONObject jsonData, String key)
    {
        List<String> fields = (List<String>) jsonData.getJSONObject(key).get("fieldName");
        JSONArray exec0 = jsonData.getJSONObject(key).getJSONArray("exec0");
        JSONArray resultArray = new JSONArray();

        for (int i = 0; i < exec0.size(); i++) {
            List<Object> row = exec0.getJSONArray(i);
            JSONObject data = new JSONObject();

            for (int j = 0; j < row.size(); j++) {
                data.put(fields.get(j).toLowerCase(), row.get(j));
            }

            resultArray.add(data);
        }

        //        if (resultArray == null || resultArray.size() <= 0)
        //        {
        //            return null;
        //        }
        JSONObject result = new JSONObject();
        result.put(key, resultArray);
        return result;
    }

    public class defaultRequestCallback implements requestCallback
    {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception
        {
            WebResource webResource = client.resource(url);
            Object resp = webResource.type("application/x-www-form-urlencoded")
                    .post(String.class, param);
            //			MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
            //			resp = webResource.queryParams(queryParams)
            //					.header("Content-Type", "application/x-www-form-urlencoded")
            //					.post(String.class, jsonparam.toJSONString());
            return resp;
        }
    }

    //	protected static String getResult(String urlStr, String content, String encoding) throws IOException {
    //		URL url = null;
    //		HttpURLConnection connection = null;
    //		try {
    //			url = new URL(urlStr);
    //			connection = (HttpURLConnection) url.openConnection();
    //
    //			connection.setConnectTimeout(10000);//
    //			connection.setReadTimeout(10000);//
    //
    //			/**
    //			 * Output to the connection. Default is false, set to true because
    //			 * post method must write something to the connection
    //			 * 设置是否向connection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true
    //			 */
    //			connection.setDoOutput(true);
    //			// Read from the connection. Default is true.
    //			connection.setDoInput(true);
    //			// Set the post method. Default is GET
    //			connection.setRequestMethod("POST");
    //			// Post cannot use caches
    //			connection.setUseCaches(false);
    //			connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
    //			connection.connect();
    //
    //			DataOutputStream out = new DataOutputStream(connection.getOutputStream());
    //			out.write(content.getBytes(encoding));
    //			out.flush();
    //			out.close();
    //
    //			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
    //			StringBuffer buffer = new StringBuffer();
    //			String line = "";
    //			while ((line = reader.readLine()) != null) {
    //				buffer.append(line);
    //			}
    //			reader.close();
    //			return buffer.toString();
    //		} catch (IOException e) {
    //			throw e;
    //		} finally {
    //			if (connection != null) {
    //				connection.disconnect();
    //			}
    //		}
    //	}
}
