package com.efuture.ocp.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.omd.storage.FStorageOperations;

@Component("restinfogetfrominifile")
public class RestInfoGetFromIniFile implements RestInfoGet {

	public Logger logger = Logger.getLogger(RestInfoGetFromIniFile.class);


	private Properties cfgProperties;



	

	public RestInfoGetFromIniFile() {
		super();
		// this.restClient = rest;
		// this.cfgFile = restClient.getCfgFile();
		// this.init(this.cfgFile);
	}

	@Override
	public void init(String configfile) {
		if (!StringUtils.isEmpty(configfile) && configfile.startsWith("DB:")) {
			// DB:TABLENAME|COND1=XXXX,COND2=XXXX
			FStorageOperations storage = null;
			try {
				// 得到数据源
				storage = SpringBeanFactory.getBean(BasicComponent.StorageOperation, FStorageOperations.class);

				String[] ss = configfile.substring(3).split("\\|");
				String table = ss[0].trim();
				Criteria criteria = new Criteria();
				if (ss.length > 1) {
					ss = ss[1].split(",");
					for (int i = 0; i < ss.length; i++) {
						String[] cond = ss[i].split("=");
						String key = cond[0].trim();
						String val = cond[1].trim();
						criteria = criteria.and(key).is(val);
					}
				}
				Query query = new Query(criteria);
				List<Map<String, Object>> list = storage.select(query, table);
				if (list != null && list.size() > 0) {
					cfgProperties = new Properties();
					for (Map<String, Object> map : list)
						cfgProperties.setProperty((String) map.get("key"), (String) map.get("val"));
				}
			} finally {
				if (storage != null)
					storage.destroy();
			}

			return;
		}

		// 取restservice.ini中的配置
		String ini = null;
		if (StringUtils.isEmpty(configfile))
			ini = WebPathUtils.getWebRootClassPath() + "/restservice.ini";
		else {
			if (configfile.startsWith("\\") || configfile.startsWith("/"))
				ini = WebPathUtils.getWebRootClassPath() + configfile;
			else
				ini = configfile;
		}
		System.out.println("restservice.ini path:" + ini);
		try {
			logger.info("restservice.ini path:" + ini);
			File input = new File(ini);
			if (input.exists()) {
				InputStream is = new FileInputStream(input);
				cfgProperties = new Properties();
				cfgProperties.load(is);
				is.close();
			} else {
				URL fps = new URL(ini);
				File fp=new File(fps.toURI());
				InputStream is = new FileInputStream(fp);
				cfgProperties = new Properties();
				cfgProperties.load(is);
				is.close();				
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public String queryServiceURI(long ent_id, String method) {
		return queryServiceURI(method);
	}

	@Override
	public String queryServiceURI(String method) {
		// 根据方法名找到路径映射
		String servicePath = "";
		if (cfgProperties == null)
			return null;

		String curservice = method;
		while (!StringUtils.isEmpty(curservice)) {
			String url = cfgProperties.getProperty(curservice);
			if (url != null && !url.equals("")) {
				servicePath = url;
				break;
			} else {
				if (curservice.equals("*"))
					break;
				else {
					boolean matches = false;

					if (!curservice.endsWith(".*")) {
						@SuppressWarnings("unchecked")
						Enumeration<String> names = (Enumeration<String>) cfgProperties.propertyNames();
						if (names != null) {
							while (names.hasMoreElements()) {
								String name = names.nextElement();
								if (!name.endsWith(".*") && name.indexOf("*") > 0) {
									String prefix = name.substring(0, name.indexOf("*"));
									String suffix = name.substring(name.indexOf("*") + 1);
									if (!StringUtils.isEmpty(prefix) && curservice.startsWith(prefix)
											&& !StringUtils.isEmpty(suffix) && curservice.endsWith(suffix)) {
										matches = true;
										servicePath = cfgProperties.getProperty(name);
										break;
									}
								}
							}
						}
					}

					if (matches)
						break;
					else {
						if (curservice.endsWith(".*"))
							curservice = curservice.substring(0, curservice.lastIndexOf("."));
						int n = curservice.lastIndexOf(".");
						if (n > 0)
							curservice = curservice.substring(0, n) + ".*";
						else
							curservice = "*";
					}
				}
			}
		}

		// 返回URL
		return servicePath;
	}

	@Override
	public String queryServiceURIbymkt(String method, String mktid) throws Exception {
		// 根据方法名找到路径映射
		String servicePath = "";
		String curservice = method;
		if (!StringUtils.isEmpty(curservice)) {
			Criteria criteria = Criteria.where("mktid").is(mktid).and("id").is(method);
			Query query = new Query(criteria);
			List<Map<String, Object>> list = SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class)
					.select(query, "restconfig");
			if (list != null && !list.isEmpty() && list.size() > 0) {
				servicePath = (String) list.get(0).get("resturl");

			} else {
				Criteria c2 = Criteria.where("mktid").is("%").and("id").is(method);
				Query q2 = new Query(c2);
				List<Map<String, Object>> list2 = SpringBeanFactory
						.getBean("StorageOperation", FStorageOperations.class).select(q2, "restconfig");
				if (list2 != null && !list2.isEmpty() && list2.size() > 0) {
					servicePath = (String) list2.get(0).get("resturl");
				} else {
					throw new Exception("can't find method service url, please check restconfig !");
				}
			}
		}

		// 返回URL
		return servicePath;
	}

}
