package com.efuture.ocp.common.billservice;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;

public class AsynauditSrvImpl extends BasicComponent implements
		AsynauditService {

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.efuture.ocp.common.billservice.AsynauditService#run()
	 */
	@Override
	public void run() {
		AsyncauditlistBean billinfo = gettask();
		if (null != billinfo) {
			try {
				runtask(billinfo);
				endrun(billinfo, true, "");
			} catch (Exception e) {
				endrun(billinfo, false, e.getMessage());
			}
		}

	}

	/**
	 * 更新执行数量
	 * 
	 * @param billinfo
	 * @param count
	 * @throws Exception
	 */
	@Override
	public void uptexeccount(AsyncauditlistBean billinfo, long count)
			throws Exception {
		String sql = "update asyncauditlist set execcount = "
				+ String.valueOf(billinfo.getExeccount())
				+ ",execed = execed + " + String.valueOf(count)
				+ " where ph_key =" + String.valueOf(billinfo.getPh_key());
		getStorageOperations(FMybatisTemplate.class).getSqlSessionTemplate()
				.update("mybatis.sql.update", sql);
	}

	/**
	 * 执行审核
	 * 
	 * @param billinfo
	 * @throws Exception
	 */
	@Transactional(propagation = Propagation.REQUIRED)
	public Map<String, String> runtask(AsyncauditlistBean billinfo)
			throws Exception {
		Map<String, String> rtn = new HashMap<String, String>();
		if ("BillCommonService".equals(billinfo.getBillobjectclass())) {
			BillCommonService billsrv = SpringBeanFactory.getBean(
					billinfo.getBillobjectname(), BillCommonService.class);
			JSONObject jsonparam = new JSONObject();
			jsonparam.put("billno", billinfo.getBillno());
			jsonparam.put("billsgno", "asyncaudit");
			jsonparam.put("auditor", billinfo.getAuditor());
			jsonparam.put("auditor_name", billinfo.getAuditor_name());
			ServiceSession session = new ServiceSession();
			ServiceResponse sr = billsrv.billaudit(session, jsonparam);
			rtn.put("rtn", "0");
			rtn.put("msg", "");
		} else if ("ExecAsynaudit".equals(billinfo.getBillobjectclass())) {
			ExecAsynaudit billsrv = SpringBeanFactory.getBean(
					billinfo.getBillobjectname(), ExecAsynaudit.class);
			billsrv.doasynaudit(billinfo);
		}
		return rtn;
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public void ins(AsyncauditlistBean billinfo) {
		getStorageOperations().insert(billinfo);
	}

	@Override
	public void ins(long ent_id, String billno, String billmoduleid,
			String billobjectname, String billobjectclass, String auditor,
			String auditor_name) {
		AsyncauditlistBean billinfo = new AsyncauditlistBean();
		billinfo.setPh_key(UniqueID.getUniqueID());
		billinfo.setPh_timestamp(new Date());
		billinfo.setBillno(billno);
		billinfo.setBillmoduleid(billmoduleid);
		billinfo.setBillobjectname(billobjectname);
		billinfo.setBillobjectclass(billobjectclass);
		billinfo.setAuditor(auditor);
		billinfo.setAuditor_name(auditor_name);
		billinfo.setExecstatus("N");
		billinfo.setEnt_id(ent_id);
		ins(billinfo);
	}

	/**
	 * 任务执行完成
	 * 
	 * @param billinfo
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public void endrun(AsyncauditlistBean billinfo, boolean succeed,
			String errmsg) {
		String msg;
		Update updaterun = new Update();
		billinfo.setExecedate(new Date());
		billinfo.setExecelapsed((billinfo.getExecedate().getTime() - billinfo.getExecsdate().getTime())/1000);
		updaterun.set("execedate", billinfo.getExecedate());
		updaterun.set("execelapsed",billinfo.getExecelapsed());
		if (succeed) {
			updaterun.set("execstatus", "Y");
		} else {
			updaterun.set("execstatus", "X");
			if (!StringUtils.isEmpty(errmsg)) {
				int end = errmsg.length();
				if (end > 999)
					end = 999;
				msg = errmsg.substring(0, end);
			} else
				msg = "";

			updaterun.set("execerrmsg", msg);
		}
		Criteria criteriarun = Criteria.where("ph_key")
				.is(billinfo.getPh_key());
		Query queryrun = new Query(criteriarun);
		getStorageOperations().update(queryrun, updaterun,
				AsyncauditlistBean.class);

	}

	/**
	 * 得到一个任务
	 * 
	 * @return
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public AsyncauditlistBean gettask() {
		FStorageOperations fs = getStorageOperations();
		Update update = new Update();
		update.set("execstatus", "N");
		Criteria criteria = Criteria.where("execstatus").is("N");
		Query query = new Query(criteria);
		query.limit(1);
		int i = fs.update(query, update, AsyncauditlistBean.class);
		if (i == 0) {
			return null;
		}
		/* 获取 */
		criteria = Criteria.where("execstatus").is("N");
		Query querybillinfo = new Query(criteria);
		querybillinfo.limit(1);
		AsyncauditlistBean billinfo = fs.selectOne(querybillinfo,
				AsyncauditlistBean.class);
		/* 更新状态 */
		billinfo.setExecsdate(new Date());
		billinfo.setStatus("M");
		
		Update updaterun = new Update();
		updaterun.set("execstatus", billinfo.getStatus());
		updaterun.set("execsdate", billinfo.getExecsdate());
		Criteria criteriarun = Criteria.where("ph_key")
				.is(billinfo.getPh_key());
		Query queryrun = new Query(criteriarun);
		fs.update(queryrun, updaterun, AsyncauditlistBean.class);
		
		return billinfo;
	}
}
