package com.efuture.ocp.common.distributedLock;

import java.util.concurrent.ConcurrentHashMap;

import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

import com.efuture.ocp.common.rest.ServiceLogs;

@Component("dLockKeyBySpringEL")
public class DistributedLockKeyBySpringEL implements DistributedLockKeyHandle {

	protected static final String TARGET = "target";

	protected static final String ARGS = "args";

	private final ExpressionParser parser = new SpelExpressionParser();

	private final ConcurrentHashMap<String, Expression> expCache = new ConcurrentHashMap<String, Expression>();

	public String getExpressionKey(ProceedingJoinPoint point, DLock around) {
		String className = point.getTarget().getClass().getSimpleName();
		String methodName = point.getSignature().getName();
		String expressionStr = around.key();
		return className + "_" + methodName + "_" + expressionStr;
	}

	/**
	 * #{args[0].name}
	 */
	@Override
	public String getKey(ProceedingJoinPoint point, DLock around) {
		// 获取key表达式
		String expressionStr = around.key();
		ServiceLogs.truedebuglog("DistributedLockKey", "获取锁表达式[" + expressionStr + "]", 0);
		String keySpEL = getExpressionKey(point, around);
		ServiceLogs.truedebuglog("DistributedLockKey", "获取锁表达式Key[" + keySpEL + "]", 0);
		// 创建上下文
		StandardEvaluationContext context = new StandardEvaluationContext();
		context.setVariable(ARGS, point.getArgs());
		context.setVariable(TARGET, point.getTarget());
		Expression expression = expCache.get(keySpEL);
		if (null == expression) {
			expression = parser.parseExpression(expressionStr);
			expCache.put(keySpEL, expression);
		}
		return expression.getValue(context, String.class);
	}

}
