package com.efuture.ocp.common.distributedLock;

import org.springframework.stereotype.Component;

import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.UniqueID;

/**
 * 
 * @author 肖志文, 利于强制解锁
 * 2020年10月29日 下午4:37:56
 *
 */
@Component("fLockHandleByCacheUtils")
public class LockHandleByCacheUtils extends AbstractDistributedLockHandle {
	@Override
	public boolean tryLock(String key, int lockExpire, int waitMillSeconds) {
		long id = System.currentTimeMillis();
		boolean ok = doNaiveCachePut(key, id, lockExpire, waitMillSeconds);
		if (!ok) {
			return false;
		}
		return ok;
	}
	@Override
	public boolean doNaiveCachePut(String key, long id, int lockExpire, int waitMillSeconds) {
		return CacheUtils.getCacheUtils().AddData(key, id, lockExpire);
	}

	@Override
	public boolean doNaiveCacheDelete(String key) {
		return CacheUtils.getCacheUtils().deleteData(key);
	}

	@Override
	public long doNaiveCacheGet(String key) {
		Object val = CacheUtils.getCacheUtils().getData(key);
		if (val == null) {
			return 0;
		}
		return Long.valueOf(val.toString());
	}

	@Override
	public boolean unlock(String key, int lockExpire) {
		return doNaiveCacheDelete(key);
	}

	@Override
	public boolean unlock(String key) {
		return unlock(key, CacheUtils.CacheTimeOut.Min);
	}
}
