package com.efuture.ocp.common.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 如果请求消息中包含gzip压缩数据，则进行解压
 */
public class GzipFilter implements Filter
{
    @Override
    public void init(FilterConfig filterConfig) throws ServletException
    {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
    {
        boolean isgzip = false;
        HttpServletRequest req = (HttpServletRequest)request;
        String contentEncoding = req.getHeader("Content-Encoding");
        if (null != contentEncoding && contentEncoding.indexOf("gzip") != -1) isgzip = true;
        
        if (isgzip)
        {
            GzipRequestWrapper gzipreq = new GzipRequestWrapper((HttpServletRequest)request);
            GzipResponseWrapper gziprep = new GzipResponseWrapper((HttpServletResponse)response);
            //xzw 2019-11-09
            try {
            	chain.doFilter(gzipreq,gziprep);
            } finally {
            // GZIP需要关闭流
            	gziprep.finishResponse();
            }
        }
        else 
        {
            chain.doFilter(request,response);
        }
    }

    @Override
    public void destroy()
    {

    }
}
