package com.efuture.ocp.common.rest.taobao;

public  class TaobaoResponse {

    private boolean success;
    private String err_code;
    private String err_msg;
    private Long total_count;
    private Object model;

    public TaobaoResponse(boolean success, String err_code, String err_msg) {
        this.success = success;
        this.err_code = err_code;
        this.err_msg = err_msg;
    }

    public TaobaoResponse(boolean success, String err_code, String err_msg, Object model) {
        this.success = success;
        this.err_code = err_code;
        this.err_msg = err_msg;
        this.model = model;
    }

    public TaobaoResponse(boolean success, String err_code, String err_msg, Long total_count, Object model) {
        this.success = success;
        this.err_code = err_code;
        this.err_msg = err_msg;
        this.total_count = total_count;
        this.model = model;
    }

    public static TaobaoResponse buildSuccess()
    {
        return new TaobaoResponse(true, "0", "ok");
    }

    public static TaobaoResponse buildSuccess(Object model)
    {
        return new TaobaoResponse(true, "0", "ok", model);
    }

    public static TaobaoResponse buildFailure(String errorCode, String errorMessage)
    {
        return new TaobaoResponse(false, errorCode, errorMessage);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErr_code() {
        return err_code;
    }

    public void setErr_code(String err_code) {
        this.err_code = err_code;
    }

    public String getErr_msg() {
        return err_msg;
    }

    public void setErr_msg(String err_msg) {
        this.err_msg = err_msg;
    }

    public Long getTotal_count() {
        return total_count;
    }

    public void setTotal_count(Long total_count) {
        this.total_count = total_count;
    }

    public Object getModel() {
        return model;
    }

    public void setModel(Object model) {
        this.model = model;
    }
}