/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	BillBaseBean.java
 * Author:		亮
 * Date:		2015-7-14 下午5:00:30
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.billservice;

import java.util.Date;

import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceSession;
import org.springframework.util.StringUtils;

import javax.validation.constraints.Min;

/**
 * @author		亮
 * @description	
 * 
 */
public abstract class BillAbstractBean extends AbstractEntityBean
{
    private static final long serialVersionUID = -57293662004962006L;
    
    protected Date ph_timestamp;                          //时间戳
    
    @Min(value=1)
    protected  long ph_key;
    
    /**
     * @return ph_timestamp
     */
    public Date getPh_timestamp()
    {
        if(StringUtils.isEmpty(ph_timestamp)){
            return new Date();
        }else{
            return ph_timestamp;
        }
    }
    /**
     * @param ph_timestamp 要设置的 ph_timestamp
     */
    public void setPh_timestamp(Date ph_timestamp)
    {
        this.ph_timestamp = ph_timestamp;
    }

    public long getPh_key() {
        return ph_key;
    }

    public void setPh_key(long ph_key) {
        this.ph_key = ph_key;
    }

    // 新增操作时初始化通用成员方法
    public void initInsertMember(ServiceSession session)
    {
        super.initInsertMember(session);
        
        this.setPh_timestamp(new Date());
    }

    public void initInsertMember(AbstractEntityBean bean)
    {
        super.initInsertMember(bean);
        
        this.setPh_timestamp(new Date());
    }
       
    // 更新操作时初始化通用成员方法
    public void initUpdateMember(ServiceSession session)
    {
        super.initUpdateMember(session);
        
        this.setPh_timestamp(new Date());
    }
    
    public void initUpdateMember(AbstractEntityBean bean)
    {
        super.initUpdateMember(bean);
        
        this.setPh_timestamp(new Date());
    }
}
