package com.efuture.ocp.common.exception;  

import java.io.BufferedInputStream;
import java.io.FileInputStream;   
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.util.WebPathUtils;  
public class IOini extends Properties{  
    public static String filename = WebPathUtils.getWebRootClassPath() + "/conf/conversion.ini";
    private static final long serialVersionUID = -4627607243846121965L;  
    
    
    private final LinkedHashSet<Object> keys = new LinkedHashSet<Object>();  
  
    @Override  
    public Enumeration<Object> keys() {  
        return Collections.enumeration(keys);  
    }  
   
    @Override  
    public Object put(Object key, Object value) {  
        keys.add(key);  
        return super.put(key, value);  
    }  
  
    @Override  
    public Set<String> stringPropertyNames() {  
        Set<String> set = new LinkedHashSet<String>();  
        for (Object key : this.keys) {  
            set.add((String) key);  
        }  
        return set;  
    }  
  
    @Override  
    public Set<Object> keySet() {  
        return keys;  
    }  

    @Override  
    public Enumeration<?> propertyNames() {  
        return Collections.enumeration(keys);  
    }  
    private static Properties readOrderedPropertiesFile() {  
        Properties properties = new IOini();  
        InputStreamReader inputStreamReader = null;  
        try {  
            InputStream inputStream = new BufferedInputStream(new FileInputStream(filename));   
            inputStreamReader = new InputStreamReader(inputStream, "GBK");  
            properties.load(inputStreamReader);  
        } catch (Exception e) {  
        	System.out.println(e.getMessage());
        } finally {  
            if (inputStreamReader != null) {  
                try {  
                    inputStreamReader.close();  
                } catch (IOException e) {  
                    System.out.println(e.getMessage());  
                }  
            }  
        }  
        return properties;  
    }  
    public static String transform(String args){  
        String reStr = args; 
        //获取语言版本
        ThreadLocal<ServiceSession> locale=ServiceRestReflect.getLocale();
        ServiceSession session=locale.get();
        if (session != null) {
        	 String lanType=session.getLocale();
        	 if (lanType != null) {
        		 //繁体字
        		 if(lanType.equals("TR")){
          	        Properties prop = readOrderedPropertiesFile();  
          	        for (String key : prop.stringPropertyNames()) {  
          	              reStr=reStr.replace(key, prop.getProperty(key));
          	        }
          	      //英文
                  }else if(lanType.equals("EN")){
                  
                  }
        	 }
             
        }
       
        return reStr;
    }

 
}