package com.efuture.ocp.common.util;

import java.security.SecureRandom;
import java.util.Random;

import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

import org.apache.commons.lang3.StringUtils;

import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKey;
import javax.crypto.Cipher;

public class Encrypt {

	private String hexString = "0123456789ABCDEF";
		
	public static String getSumWords(String inStr, int num) {
		String result = new String();
		//int sub = inStr.length() / num;
		int sub = (int)Math.ceil((double)inStr.length() / num);
		for (int i = 0; i < num; i++)
		{
			String temp = new String();
			for (int j = 1; j <= sub; j++)
			{
				if ((j - 1) * num + i < inStr.length())
					temp = temp + inStr.charAt((j - 1) * num + i);
			}
			result = result + String.valueOf(getSum(temp));
		}
		return result;
	}

	private static int getSum(int num) 
	{
		if (num < 10) {
			return num;
		} else {
			int temp = 0;
			String	val = String.valueOf(num);
			for (int i = 0; i < val.length(); i++) {
				temp += Integer.parseInt(String.valueOf(val.charAt(i)), 10);
			}
			return getSum(temp);
		}
	}
	
	private static String getSum(String str)
	{
		String	result = new String();
		int	sum = 0;
		
		for (int i = 0; i < str.length(); i++)
		{
			sum = sum + Integer.valueOf(str.charAt(i));
		}
		result = String.valueOf(getSum(sum));
		return result;
	}

	public static String getSpecialCode(String inStr, int len) {
		String inStrMd5 = MD5Utils.MD5(inStr);
		return getSumWords(inStrMd5, len);
	}

	public static String getSpecialDesCode(String inStr, String key, int len) {
		String inStrMd5 = fdes(inStr, key);
		return getSumWords(inStrMd5, len);
	}
	
	public static String fdes(String ds, String key) {
		if (ds == null || ds.isEmpty()) return "";
		//String i_seed = "Futurevip";
		String i_seed = key;
		int len = 56 - i_seed.length();
		for (int i = 0; i < len; i++) {
			i_seed += 'x';
		}
		byte[] enc = encrypt(ds.getBytes(), i_seed);
		String es = "";
		for (int i = 0; i < enc.length; i++) {
			String t = Integer.toHexString(enc[i] & 0xFF);
			if (t.length() == 1) {
				es += "0" + t;
			} else {
				es += t;
			}
		}
		return es.toUpperCase();
	}
	
	public static byte[] encrypt(byte[] ds, String pwd) {
		try {
			IvParameterSpec ips = new IvParameterSpec(new byte[] {0,0,0,0,0,0,0,0});
			DESKeySpec desKey = new DESKeySpec(pwd.getBytes());
			SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
			SecretKey securekey = keyFactory.generateSecret(desKey);
			Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
			cipher.init(Cipher.ENCRYPT_MODE, securekey, ips);
			return cipher.doFinal(ds);
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return null;
	}

	public static byte[] decrypt(byte[] src, String pwd) throws Exception {
		IvParameterSpec ips = new IvParameterSpec(new byte[] {0,0,0,0,0,0,0,0});
		DESKeySpec desKey = new DESKeySpec(pwd.getBytes());
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
		SecretKey securekey = keyFactory.generateSecret(desKey);
		Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
		cipher.init(Cipher.DECRYPT_MODE, securekey, ips);
		return cipher.doFinal(src);
	}
	
	public String getRandomNum(int len)
	{
		Random rad=new Random();  
        String result  = rad.nextInt((int)Math.pow(10, len)) + "";
        if(result.length()!=len){  
            return getRandomNum(len);  
        }  
        return result;  
	}
	
}
