package com.efuture.ocp.common.filter;


import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.SpringBeanFactory;


/**
 * 对MyBatis进行拦截，添加log监控
 */

@Intercepts({
    @Signature(method = "query", type = Executor.class, args = {
        MappedStatement.class, Object.class, RowBounds.class,
        ResultHandler.class
    }),
    @Signature(method = "update", type = Executor.class, args = { MappedStatement.class, Object.class })
})
public class LogMybatisPlugin implements Interceptor
{

    private static Logger logger = LoggerFactory.getLogger(LogMybatisPlugin.class);
    private Executor target;

    @Override
    public Object intercept(Invocation invocation) throws Throwable
    {
        Environment env = SpringBeanFactory.getContext().getBean(Environment.class);

        if ("n".equalsIgnoreCase(env.getProperty("efuture.log.logsql"))) {
            return invocation.proceed();
        }

        long starttime = System.currentTimeMillis();
        MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[0];
        //得到类名，方法
        String[] strArr = mappedStatement.getId().split("\\.");
        String methodName = strArr[strArr.length - 2] + "." + strArr[strArr.length - 1];


        //Transaction t = Cat.newTransaction("SQL", methodName);

        //得到sql语句
        Object parameter = null;

        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }

        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        Configuration configuration = mappedStatement.getConfiguration();
        String sql = showSql(configuration, boundSql);

        //获取SQL类型
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        //Cat.logEvent("SQL.Method", sqlCommandType.name().toLowerCase(), Message.SUCCESS, sql);
        JSONObject logmsg = new JSONObject();
        logmsg.put("SqlMethodName", methodName);
        logmsg.put("Sqlstr", sql);
        //  ServiceLogs.debuglog(ServiceLogs.LOGTYPE.DBSTART, logmsg.toJSONString(), 0);
        //String s = this.getSQLDatabase();

        Object returnObj = null;

        try {
            returnObj = invocation.proceed();

            if (!ignoreLogSql(sql)) {
                ServiceLogs.debuglog( ServiceLogs.LOGTYPE.DBSUCC, logmsg.toJSONString(), starttime );
            }
        }
        catch (Exception e) {
            ServiceLogs.debuglog(ServiceLogs.LOGTYPE.DBERROR, logmsg.toJSONString(), starttime);
            throw e;
        }
        finally {

        }

        return returnObj;
    }

    private boolean ignoreLogSql(String sql)
    {
        Environment env = SpringBeanFactory.getContext().getBean(Environment.class);
        String ignoreList = env.getProperty("efuture.log.ignore");

        if (ignoreList != null) {
            for (String key : ignoreList.split( "," )) {
                if (sql.indexOf( key ) > 0) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * 解析sql语句
     * @param configuration
     * @param boundSql
     * @return
     */
    public String showSql(Configuration configuration, BoundSql boundSql)
    {
        Object parameterObject = boundSql.getParameterObject();
        List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");

        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();

            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(getParameterValue(parameterObject)));

            }
            else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);

                for (ParameterMapping parameterMapping : parameterMappings) {
                    String propertyName = parameterMapping.getProperty();

                    if (metaObject.hasGetter(propertyName)) {
                        Object obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(getParameterValue(obj)));
                    }
                    else if (boundSql.hasAdditionalParameter(propertyName)) {
                        Object obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(getParameterValue(obj)));
                    }
                }
            }
        }

        return sql;
    }

    /**
     * 参数解析
     * @param obj
     * @return
     */
    private String getParameterValue(Object obj)
    {
        String value = null;

        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        }
        else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(DateFormat.DEFAULT, DateFormat.DEFAULT, Locale.CHINA);
            value = "'" + formatter.format((Date)obj) + "'";
        }
        else {
            if (obj != null) {
                value = obj.toString();
            }
            else {
                value = "";
            }

        }

        return value;
    }

    @Override
    public Object plugin(Object target)
    {
        if (target instanceof Executor) {
            this.target = (Executor) target;
            return Plugin.wrap(target, this);
        }

        return target;
    }

    @Override
    public void setProperties(Properties properties)
    {
    }

}
