package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

@Lazy(true)
@Component("RestClientUtils_DataHub")
public class RestClientUtils_DataHub extends RestClientUtils {

    private final String TOKEN_EXPIRED = "TOKEN_EXPIRED";
    public RestClientUtils_DataHub() {
        super();
    }

    public RestClientUtils_DataHub(int poolSize, long maxWait, String config) {
        super(poolSize, maxWait, config);
    }

    public RestClientUtils_DataHub(String config) {
        super(config);
    }

    private String getData(JSONObject json, String key, String defval)
    {
        if (json.containsKey(key)) return json.getString(key);
        else return defval;
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param,
                new RestClientUtils.defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = JSON.parseObject((String) result);
            response = JSON.toJavaObject(json, ServiceResponse.class);
        }
        if (response == null)
        {
            throw new ServiceException(ResponseCode.EXCEPTION, (String) result);
        }

        if (response.getReturncode().equals("0"))
        {
            Object hubdata = response.getData();
            if (hubdata instanceof JSONArray)
            {
                JSONArray arr = (JSONArray) hubdata;
                if (arr.size() > 0)
                {
                    JSONObject row = (JSONObject)arr.get(0);
                    if (!getData(row, "retcode", "0").equals("0"))
                        throw new ServiceException(ResponseCode.FAILURE, getData(row, "retcode", "0").concat(":").concat(getData(row, "retmsg", "未知错误")));
                    if (!getData(row, "o_retcode", "0").equals("0"))
                        throw new ServiceException(ResponseCode.FAILURE, getData(row, "o_retcode", "0").concat(":").concat(getData(row, "o_retmsg", "未知错误")));
                }
            }
            else if (hubdata instanceof JSONObject)
            {
                JSONObject row = (JSONObject) hubdata;
                if (!getData(row, "retcode", "0").equals("0"))
                    throw new ServiceException(ResponseCode.FAILURE, getData(row, "retcode", "0").concat(":").concat(getData(row, "retmsg", "未知错误")));
                if (!getData(row, "o_retcode", "0").equals("0"))
                    throw new ServiceException(ResponseCode.FAILURE, getData(row, "o_retcode", "0").concat(":").concat(getData(row, "o_retmsg", "未知错误")));
            }
            return response;
        }
        else if (!"0".equals(response.getReturncode()))
        {
            //throw new ServiceException(response.getReturncode(), response.getData().toString());
            return response;
        }
        else {
            return response;
        }
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, EnterpriseConfigBean ent, JSONObject param, String dataNode) throws Exception
    {
        String authKey = ent.getSrvConfig("appId", false) + "," + ent.getSrvConfig("appKey", false);
        String fullUrl = getUrl(session, baseUrl, ent.getSrvConfig("authUrl", false), authKey, param, false);
        ServiceResponse resp = sendRequest(session, fullUrl, param.toJSONString(), dataNode);
        if (TOKEN_EXPIRED.equalsIgnoreCase(resp.getReturncode()))
        {
            fullUrl = getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), authKey, param, true);
            resp = sendRequest(session, fullUrl, param.toJSONString(), dataNode);
        }
        return resp;
    }

    public String getTokenStr(long ent_id, String baseUrl, String authUrl, String authKey, boolean force) throws Exception {
        String memKey = "DataHub-" + String.valueOf(ent_id);
        String accessToken = (String) CacheUtils.getCacheUtils().getData(memKey);
        JSONObject remote_token = new JSONObject();
        if (StringUtils.isEmpty(accessToken) || force) {
            remote_token = getRemoteToken(authUrl, authKey);
            if (remote_token.containsKey("access_token")) {
                accessToken = remote_token.getString("access_token");
                int expires_in = remote_token.getIntValue("expires_in");
                CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
            } else {
                throw new ServiceException(ResponseCode.FAILURE, "获取代理TOKEN错误,请联系系统管理员！");
            }
        }
        return "&access_token=".concat(accessToken);
    }

    protected JSONObject getRemoteToken(String authUrl, String authKey) throws IOException
    {
        try
        {
            JSONObject result = JSONObject.parseObject(HttpUtils.getRequest(authUrl));
            if ("0".equals(getData(result, "code", "-1")))
            {
                return result;
            }
            else
            {
                throw new ServiceException(ResponseCode.FAILURE, getData(result, "msg", "未知错误"));
            }

        } catch (Exception e)
        {
            e.printStackTrace();
            return null;
        }
    }

    private static String getHex(byte mByte) {
        char[] Digit = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
        char[] tempArr = new char[2];
        tempArr[0] = Digit[(mByte >>> 4) & 0X0F];
        tempArr[1] = Digit[mByte & 0X0F];
        String s = new String(tempArr);
        return s;
    }
    private static String toHexString(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; i++) {
            strDigest += getHex(byteArray[i]);
        }
        return strDigest;
    }
    public String checkSignature(String appKey, String timestamp, String data, boolean debugStatus) throws UnsupportedEncodingException {
        String[] arr = new String[] { appKey, timestamp, data};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; i++) {
            content.append(arr[i]);
        }
        MessageDigest md = null;
        String tmpStr = null;

        try {
            md = MessageDigest.getInstance("SHA-1");
            // 将三个参数字符串拼接成一个字符串进行sha1加密
            byte[] digest = md.digest(content.toString().getBytes("UTF-8"));
            tmpStr = toHexString(digest);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }

        if (debugStatus)
        {
            logger.info("SignSrc:" + content);
            logger.info("SignStr:" + tmpStr);
        }

        return tmpStr;
    }

    private String getSignStr(String authKey, JSONObject param, boolean debugStatus) throws UnsupportedEncodingException
    {
        String keys[] = authKey.split(",");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String appid = keys[0];
        String appKey = keys[1];

        StringBuilder sb = new StringBuilder();
        sb.append("&appid=");
        sb.append(appid);
        sb.append("&timestamp=");
        sb.append(timestamp);
        sb.append("&sign=");
        // JSON排序
        //sb.append(checkSignature(appKey, timestamp, param.toJSONString()));
        sb.append(checkSignature(appKey, timestamp, JSONObject.toJSONString(param, SerializerFeature.SortField.MapSortField), debugStatus));
        return sb.toString();
    }

    public String getUrl(ServiceSession session, String baseUrl, String authUrl, String authKey, JSONObject param, boolean force) throws Exception {
        if (!StringUtils.isEmpty(authUrl)) {
            String tokenStr = getTokenStr(session.getEnt_id(), baseUrl, authUrl, authKey, force);
            String signStr = getSignStr(authKey, param, "Y".equalsIgnoreCase(session.getDebug_status()));
            return baseUrl.concat(tokenStr).concat(signStr);
        } else {
            return baseUrl;
        }
    }
}
