package com.efuture.ocp.common.sysevent;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

import com.efuture.ocp.common.util.SpringBeanFactory;

/**
 * @author		lenovo
 * @description
 *
 */
abstract public class SystemEvent extends ApplicationEvent
{
    static public void publishEvent(SystemEvent event)
    {
        ApplicationContext context = SpringBeanFactory.getContext();

        if (context != null) {
            context.publishEvent(event);
        }
    }

    private static final long serialVersionUID = 4934658686249143309L;

    public SystemEvent(SystemEventData source)
    {
        super(source);
    }

    public SystemEvent()
    {
        super("");
    }

    public void setEventData(SystemEventData source)
    {
        this.source = source;
    }

    @SuppressWarnings("unchecked")
    public <T> T getEventData(Class<T> clazz)
    {
        return (T) this.source;
    }

    public String getEventMsgTopic()
    {
        return getEventData(SystemEventData.class).getMsgTopic();
    }

    @SuppressWarnings("unchecked")
    public <T> T getEventMsgData(Class<T> clazz)
    {
        return (T) getEventData(SystemEventData.class).getData();
    }
}