package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataUtils
{

    public static String nvl(String BeanVal, String... DefaultVal)
    {
        if (StringUtils.isEmpty(BeanVal)) {
            for (String val : DefaultVal) {
                if (!StringUtils.isEmpty(val)) {
                    return val;
                }
            }

            return null;
        }
        else {
            return BeanVal;
        }
    }

    public static double nvl(double BeanVal, double... DefaultVal)
    {
        if (StringUtils.isEmpty(BeanVal) || BeanVal == -1.0) {
            //return DefaultVal;
            for (double val : DefaultVal) {
                if (!(StringUtils.isEmpty(val) || val == -1.0)) {
                    return val;
                }
            }

            return 0D;
        }
        else {
            return BeanVal;
        }
    }

    public static int nvl(int BeanVal, int... DefaultVal)
    {
        if (StringUtils.isEmpty(BeanVal) || BeanVal == 0) {
            //return DefaultVal;
            for (int val : DefaultVal) {
                if (!(StringUtils.isEmpty(val) || val == 0)) {
                    return val;
                }
            }

            return 0;
        }
        else {
            return BeanVal;
        }
    }

    public static long nvl(long BeanVal, long... DefaultVal)
    {
        if (StringUtils.isEmpty(BeanVal) || BeanVal == 0L) {
            //return DefaultVal;
            for (long val : DefaultVal) {
                if (!(StringUtils.isEmpty(val) || val == 0L)) {
                    return val;
                }
            }

            return 0L;
        }
        else {
            return BeanVal;
        }
    }

    public static Object checkNull(Object obj, String colName) throws Exception
    {
        if (StringUtils.isEmpty(obj)) {
            throw new Exception(colName.concat(" must provide!"));
        }

        if (obj instanceof JSONArray) {
            if (((JSONArray) obj).size() <= 0) {
                throw new Exception(colName.concat(" must contain content!"));
            }
        }

        return obj;
    }

    public static Object checkValid(Object obj, String colName, String validVals) throws Exception
    {
        if (StringUtils.isEmpty(obj)) {
            throw new Exception(colName.concat(" must provide!"));
        }

        if (StringUtils.isEmpty(validVals)) {
            return obj;
        }

        if (">0".equals(validVals)) {
            if (PrecisionUtils.doubleCompare(Double.parseDouble(obj.toString()), 0, 4) <= 0) {
                throw new Exception(colName.concat(" is invalid, must be >0 !"));
            }
        }
        else if (">=0".equals(validVals)) {
            if (PrecisionUtils.doubleCompare(Double.parseDouble(obj.toString()), 0, 4) < 0) {
                throw new Exception(colName.concat(" is invalid, must be >=0 !"));
            }
        }
        else {
            List<String> vals = Arrays.asList(validVals.split(","));

            if (!vals.contains(obj)) {
                throw new Exception(colName.concat(" is invalid, must in [" + validVals + "], but input [" + obj.toString() + "]!"));
            }
        }

        return obj;
    }

    public static void setDefaultValue(Object obj, String defaultValue) throws Exception
    {
    }

    public static String rpad(String src, int len, char ch)
    {
        int diff = len - src.length();

        if (diff <= 0) {
            return src;
        }

        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, 0, src.length());

        for (int i = src.length(); i < len; i++) {
            charr[i] = ch;
        }

        return new String(charr);
    }

    public static String lpad(String src, int len, char ch)
    {
        int diff = len - src.length();

        if (diff <= 0) {
            return src;
        }

        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, diff, src.length());

        for (int i = 0; i < diff; i++) {
            charr[i] = ch;
        }

        return new String(charr);
    }

    public static String fill(char ch, int len)
    {
        char[] charr = new char[len];

        for (int i = 0; i < len; i++) {
            charr[i] = ch;
        }

        return new String(charr);
    }

    public static JSONArray AddToArray(String key, JSONArray arr)
    {
        JSONArray result = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(key, arr);
        result.add(jsonObj);
        return result;
    }

    public static JSONArray AddToArray(JSONObject obj)
    {
        JSONArray result = new JSONArray();
        result.add(obj);
        return result;
    }

    public static String Add_Days(JSONObject json, String key, int days)
    {
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        if (StringUtils.isEmpty(json) || !json.containsKey(key)) {
            return null;
        }

        try {
            return sdf.format(DateUtils.addDays(sdf.parse(json.getString(key)), days));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Map<String, Object> cloneMap(Map<String, Object> map)
    {
        Map<String, Object> result = new ConcurrentHashMap<String, Object>();

        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }

        return result;
    }

    public static String getJsonData(JSONObject param, String key, boolean checknull, String defaultVal) throws Exception
    {
        if (StringUtils.isEmpty(param) || !param.containsKey(key) || StringUtils.isEmpty(param.get(key))) {
            if (checknull) {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else {
                return defaultVal;
            }
        }

        return param.getString(key);
    }

    public static int getJsonData(JSONObject param, String key, boolean checknull, int defaultVal) throws Exception
    {
        if (StringUtils.isEmpty(param) || !param.containsKey(key) || StringUtils.isEmpty(param.get(key))) {
            if (checknull) {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else {
                return defaultVal;
            }
        }

        return param.getInteger(key);
    }

    public static long getJsonData(JSONObject param, String key, boolean checknull, long defaultVal) throws Exception
    {
        if (StringUtils.isEmpty(param) || !param.containsKey(key) || StringUtils.isEmpty(param.get(key))) {
            if (checknull) {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else {
                return defaultVal;
            }
        }

        return param.getLongValue(key);
    }

    public static double getJsonData(JSONObject param, String key, boolean checknull, double defaultVal) throws Exception
    {
        if (StringUtils.isEmpty(param) || !param.containsKey(key) || StringUtils.isEmpty(param.get(key))) {
            if (checknull) {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else {
                return defaultVal;
            }
        }

        return param.getDoubleValue(key);
    }

    public static JSONArray copyArray(JSONArray srcArray, Map<String, String> colMap) throws Exception
    {
        if (srcArray == null || srcArray.size() <= 0) {
            return new JSONArray();
        }

        JSONArray result = new JSONArray();

        for (int i = 0; i < srcArray.size(); i++) {
            JSONObject row = new JSONObject();

            for (Map.Entry<String, String> col : colMap.entrySet()) {
                row.put(col.getKey(), getJsonData(srcArray.getJSONObject(i), col.getValue(), false, ""));
            }

            result.add(row);
        }

        return result;
    }

    public static <T> T parseObject(JSONObject jsonparam, Class<T> clazz) throws Exception
    {
        if (jsonparam == null) {
            return null;
        }

        return StorageUtils.parseBeanObject(jsonparam, clazz);
    }

    public static <T> T parseObject(JSONObject jsonparam, String key, Class<T> clazz) throws Exception
    {
        if (jsonparam == null || !jsonparam.containsKey(key)) {
            return null;
        }

        return StorageUtils.parseBeanObject((JSONObject) jsonparam.get(key), clazz);
    }

    public static JSONObject parseJSONObject(Object bean) throws Exception
    {
        if (bean == null) {
            return new JSONObject();
        }

        return (JSONObject) JSONObject.toJSON(bean);
    }
    public static  List<Map<String, Object>> getMapListByArray( String jArrayStr)
    {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        JSONArray jsonArray = JSONArray.parseArray(jArrayStr);

        if (jsonArray == null || jsonArray.isEmpty()) {
            return list;//nerver return null
        }

        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject) object;
            list.add(jsonObject);
        }

        return list;
    }
    public static <T> List<T> getListByArray(Class<T> class1, String jArrayStr)
    {
        List<T> list = new ArrayList<>();
        JSONArray jsonArray = JSONArray.parseArray(jArrayStr);

        if (jsonArray == null || jsonArray.isEmpty()) {
            return list;//nerver return null
        }

        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject) object;
            T t = JSONObject.toJavaObject(jsonObject, class1);
            list.add(t);
        }

        return list;
    }

    public static JSONArray getJSONArrayByList(List<?> list)
    {
        JSONArray jsonArray = new JSONArray();

        if (list == null || list.isEmpty()) {
            return jsonArray;//nerver return null
        }

        for (Object object : list) {
            jsonArray.add(object);
        }

        return jsonArray;
    }

    public static JSONObject newJSONObject(String key, Object value)
    {
        JSONObject result = new JSONObject();

        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return result;
        }

        result.put(key, value);
        return result;
    }

    public static <T, S> List<S> copyList(List<T> fromList, Class<S> toObj)
    {
        if (StringUtils.isEmpty(fromList)) {
            return null;
        }

        if (null == toObj) {
            return null;
        }

        List<S> toList = new ArrayList<>();
        fromList.forEach(f -> {
            S t = null;

            try
            {
                t = toObj.newInstance();
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
            BeanUtils.copyProperties(f, t);
            toList.add(t);
        });
        return toList;
    }

    public static Object[] array2Object(JSONArray array, String key)
    {
        if (!StringUtils.isEmpty(array) && array.size() > 0) {
            Object[] str = new Object[array.size()];

            for (int i = 0; i < array.size(); i++) {
                str[i] = ((JSONObject) array.get(i)).get(key);
            }

            return str;
        }

        return null;
    }
    public static String[] array2String(JSONArray array, String key) throws Exception
    {
        if (!StringUtils.isEmpty(array) && array.size() > 0) {
            String[] str = new String[array.size()];

            for (int i = 0; i < array.size(); i++) {
                str[i] = ((JSONObject) array.get(i)).get(key).toString();
            }

            return str;
        }

        return null;
    }

    public static Object[] list2Object(List<Map<String, Object>> list, String key) throws Exception
    {
        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            Object[] str = new Object[list.size()];

            for (int i = 0; i < list.size(); i++) {
                str[i] = list.get(i).get(key);
            }

            return str;
        }

        return null;
    }
    public static String[] list2String(List<Map<String, Object>> list, String key) throws Exception
    {
        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            String[] str = new String[list.size()];

            for (int i = 0; i < list.size(); i++) {
                str[i] = list.get(i).get(key).toString();
            }

            return str;
        }

        return null;
    }
    //去重
    public static List<String> maplist2String(List<Map<String, Object>> list, String joinFlag, String... keys) throws Exception
    {
        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            List<String> strs = new ArrayList<String>();

            for (int i = 0; i < list.size(); i++) {
                String value = joinMapFields(list.get(i), joinFlag, keys);

                if (!strs.contains(value)) {
                    strs.add(value);
                }
            }

            return strs;
        }

        return null;
    }

    public static String joinMapFields(Map<String, Object> map, String joinFlag, String... keys)
    {
        StringBuffer sb = new StringBuffer();

        for (int i = 0; i < keys.length; i++) {
            if (i == 0) {
                sb.append(map.get(keys[i]).toString());
            }
            else {
                if (!StringUtils.isEmpty(joinFlag)) {
                    sb.append(joinFlag).append(map.get(keys[i]).toString());
                }
                else {
                    sb.append(map.get(keys[i]).toString());
                }
            }
        }

        return sb.toString();
    }

    public static String joinBeanFields(AbstractEntityBean t, String joinFlag, String... keys) throws Exception
    {
        StringBuffer sb = new StringBuffer();

        for (int i = 0; i < keys.length; i++) {
            if (i == 0) {
                sb.append(getFieldValue(t.getClass(), t, keys[i]));
            }
            else {
                if (!StringUtils.isEmpty(joinFlag)) {
                    sb.append(joinFlag).append(getFieldValue(t.getClass(), t, keys[i]));
                }
                else {
                    sb.append(getFieldValue(t.getClass(), t, keys[i]));
                }
            }
        }

        return sb.toString();
    }

    public static <T> List<String> beanlist2String(List<T> list, String key) throws Exception
    {
        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            List<String> strlist = new ArrayList<String>();

            for (int i = 0; i < list.size(); i++) {
                T t = list.get(i);
                String value = getFieldValue(t.getClass(), t, key).toString();

                if (!strlist.contains(value)) {
                    strlist.add(value);
                }
            }

            return strlist;
        }

        return null;
    }

    // ParseObject
    public static boolean parseBoolean(Object value)
    {
        if (value == null) {
            return false;
        }

        if (value instanceof Boolean) {
            return (Boolean) value;
        }

        if (value instanceof Number) {
            return ((Number) value).intValue() == 1;
        }

        if (value instanceof String) {
            String str = (String) value;

            if ("1".equals(str) || "true".equalsIgnoreCase(str) || "Y".equalsIgnoreCase(str)) {
                return true;
            }
        }

        return false;
    }
    /**
     * inputStream转成字节流
     *
     * @param in
     *            InputStream
     * @return byte[]
     * @throws IOException
     */
    public static byte[] inputStreamToByte(InputStream in) throws IOException
    {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            int count = -1;

            while ((count = in.read(data)) != -1) {
                outStream.write(data, 0, count);
            }

            data = outStream.toByteArray();
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /**
     * 获取bean单个字段的值
     *
     * @param clazz
     * @param bean
     * @param col
     * @return
     * @throws Exception
     */
    public static Object getFieldValue(Class clazz, Object bean, String col) throws Exception
    {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getReadMethod();
        Object o1 = getMethod.invoke(bean);
        return o1;
    }

    // Object Match & Add & sub
    public static boolean ObjectMatch(JSONObject src, JSONObject dst, String key) throws Exception
    {
        if (!src.containsKey( key ) && !dst.containsKey( key )) {
            return true;
        }

        if (!src.containsKey( key ) || !dst.containsKey( key )) {
            return false;
        }

        if (src.get( key ).equals( dst.get( key ) )) {
            return true;
        }

        return false;
    }


    public static void copyData(JSONObject src, JSONObject dst, String key) throws Exception
    {
        copyData( src, dst, key, key );
    }

    public static void copyData(JSONObject src, JSONObject dst, String key, String dstKey) throws Exception
    {
        copyData( src, dst, key, dstKey, null, null);
    }

    public static void copyData(JSONObject src, JSONObject dst, String key, String dstKey, String match, String replace) throws Exception
    {
        if (src.containsKey( key ) && !StringUtils.isEmpty( src.get( key ) )) {
            if (!StringUtils.isEmpty( match ) && !StringUtils.isEmpty( replace )) {
                dst.put( dstKey, src.get( key ).toString().replaceAll( match, replace ) );
            }
            else {
                dst.put( dstKey, src.get( key ) );
            }
        }
    }

    public static void copyData(JSONObject src, JSONObject dst, String key, String dstKey, Map<String, String> mapping) throws Exception
    {
        if (src.containsKey( key ) && !StringUtils.isEmpty( src.get( key ) )) {
            dst.put( dstKey, MapUtils.getString(mapping, src.getString( key ), src.getString( key )));
        }
    }

    public static boolean isMobile(String str)
    {
        final String REGEX_MOBILE = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[013678])|(18[0,5-9]))\\d{8}$";

        if (str.length() != 11) {
            return false;
        }
        else {
            return str.matches( REGEX_MOBILE );
        }
    }
}
