package com.efuture.ocp.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import org.springframework.util.StringUtils;

public class SendMailUtils {
	/**
	 * 创建一封只包含文本/图片/附件的简单邮件
	 *
	 * @param session
	 *            和服务器交互的会话
	 * @param sendMail
	 *            发件人邮箱
	 * @param receiveMail
	 *            收件人邮箱
	 * @return
	 * @throws Exception
	 */
	public static MimeMessage createMimeMessage(Session session, Map<Object, String> sendMail, List<Map<Object, String>> receiveMails, List<Map<Object, String>> ccMails,
			List<Map<Object, String>> bccMails, String Subject, String Content, String imagefilepath, List<Object> attachmentfiles) throws Exception {
		// 1. 创建一封邮件
		MimeMessage message = new MimeMessage(session);

		// 2. From: 发件人（昵称有广告嫌疑，避免被邮件服务器误认为是滥发广告以至返回失败，请修改昵称）
		message.setFrom(
				new InternetAddress(sendMail.get("sendEmailAccount"), StringUtils.isEmpty(sendMail.get("sendEmailNick")) ? sendMail.get("sendEmailAccount") : sendMail.get("sendEmailNick"), "UTF-8"));

		// 3.1 To: 收件人（可以增加多个收件人、抄送、密送）
		int receivesize = receiveMails.size();	
		Address[] receivelist = new Address[receivesize];
		int index = 0;
		for (Map<Object, String> receiveMail : receiveMails) {
			receivelist[index] =  new InternetAddress(receiveMail.get("receiveEmailAccount"),StringUtils.isEmpty(receiveMail.get("receiveEmailNick")) ? receiveMail.get("receiveEmailAccount") : receiveMail.get("receiveEmailNick"), "UTF-8");
			index++ ;
		
		}
		message.setRecipients(MimeMessage.RecipientType.TO, receivelist);
		// 3.2 Cc: 抄送（可选）
		if (!StringUtils.isEmpty(ccMails)) {
			index = 0;
			int ccMailsize = ccMails.size();	
			Address[] ccMaillist = new Address[ccMailsize];
			for (Map<Object, String> ccMail : ccMails) {
				ccMaillist[index] =  new InternetAddress(ccMail.get("ccEmailAccount"), StringUtils.isEmpty(ccMail.get("ccEmailNick")) ? ccMail.get("ccEmailAccount") : ccMail.get("ccEmailNick"), "UTF-8");
				index++ ;
			}
			if (ccMailsize != 0) {
				message.addRecipients(MimeMessage.RecipientType.CC,ccMaillist);
			}
			
		}

		// 3.3 Bcc: 密送（可选）
		if (!StringUtils.isEmpty(bccMails)) {
			index = 0;
			int bccMailsize = bccMails.size();	
			Address[] bccMaillist = new Address[bccMailsize];
			for (Map<Object, String> bccMail : bccMails) {
				bccMaillist[index] =  new InternetAddress(bccMail.get("bccEmailAccount"), StringUtils.isEmpty(bccMail.get("bccEmailNick")) ? bccMail.get("bccEmailAccount") : bccMail.get("bccEmailNick"), "UTF-8");
				index++ ;
			}
			if (bccMailsize != 0) {
				message.addRecipients(MimeMessage.RecipientType.BCC,bccMaillist);
			}
		}

		// 4. Subject: 邮件主题（标题有广告嫌疑，避免被邮件服务器误认为是滥发广告以至返回失败，请修改标题）
		message.setSubject(Subject, "UTF-8");

		/*
		 * 下面是邮件内容的创建:
		 */

		// 创建文本“节点”
		MimeBodyPart text = new MimeBodyPart();
		// 这里添加图片的方式是将整个图片包含到邮件内容中, 实际上也可以以 http 链接的形式添加网络图片

		// （文本+图片）设置 文本 和 图片 “节点”的关系（将 文本 和 图片 “节点”合成一个混合“节点”）
		MimeMultipart mm_text_image = new MimeMultipart();
		if (!StringUtils.isEmpty(imagefilepath)) {
			// 创建图片“节点”
			MimeBodyPart image = new MimeBodyPart();
			DataHandler dh = new DataHandler(new FileDataSource(imagefilepath)); // 读取本地文件
			image.setDataHandler(dh); // 将图片数据添加到“节点”
			image.setContentID("image_fairy_tail"); // 为“节点”设置一个唯一编号（在文本“节点”将引用该ID）

			text.setContent(Content + "<br/><img src='cid:image_fairy_tail'/>", "text/html;charset=UTF-8");
			mm_text_image.addBodyPart(text);
			mm_text_image.addBodyPart(image);
		} else {
			text.setContent(Content, "text/html;charset=UTF-8");
			mm_text_image.addBodyPart(text);
		}

		mm_text_image.setSubType("related"); // 关联关系,内嵌资源

		// 将 文本+图片 的混合“节点”封装成一个普通“节点”
		// 最终添加到邮件的 Content 是由多个 BodyPart 组成的 Multipart, 所以我们需要的是 BodyPart,
		// 上面的 mm_text_image 并非 BodyPart, 所有要把 mm_text_image 封装成一个 BodyPart
		MimeBodyPart text_image = new MimeBodyPart();
		text_image.setContent(mm_text_image);

		// 设置（文本+图片）和 附件 的关系（合成一个大的混合“节点” / Multipart ）
		MimeMultipart mm = new MimeMultipart();
		mm.addBodyPart(text_image);

		if (!StringUtils.isEmpty(attachmentfiles)) {
			for (Object attachmentpath : attachmentfiles) {
				// 创建附件“节点”
				MimeBodyPart attachment = new MimeBodyPart();
				DataHandler dh2 = new DataHandler(new FileDataSource(attachmentpath.toString())); // 读取本地文件
				attachment.setDataHandler(dh2); // 将附件数据添加到“节点”
				attachment.setFileName(MimeUtility.encodeText(dh2.getName())); // 设置附件的文件名（需要编码）
				mm.addBodyPart(attachment);
			}

		}

		mm.setSubType("mixed"); // 混合关系

		// 设置整个邮件的关系（将最终的混合“节点”作为邮件的内容添加到邮件对象）
		message.setContent(mm);

		// 设置发件时间
		message.setSentDate(new Date());

		// 保存设置
		message.saveChanges();

		return message;
	}
	
	public static void sendMail(Map<Object, String> sendMail, List<Map<Object, String>> receiveMails, List<Map<Object, String>> ccMails, List<Map<Object, String>> bccMails, String sendEmailSubject,
			String sendEmailContent, String imagefilepath, List<Object> attachmentfiles) throws Exception {
		// 1. 创建参数配置, 用于连接邮件服务器的参数配置
		Properties props = new Properties(); // 参数配置
		props.setProperty("mail.transport.protocol", "smtp"); // 使用的协议（JavaMail规范要求）
		props.setProperty("mail.smtp.host", sendMail.get("sendEmailSMTPHost")); // 发件人的邮箱的
																				// SMTP
		// 服务器地址
		props.setProperty("mail.smtp.auth", "true"); // 需要请求认证

		// PS: 某些邮箱服务器要求 SMTP 连接需要使用 SSL 安全认证 (为了提高安全性, 邮箱支持SSL连接, 也可以自己开启),
		// 如果无法连接邮件服务器, 仔细查看控制台打印的 log, 如果有有类似 “连接失败, 要求 SSL 安全连接” 等错误,
		// 打开下面 /* ... */ 之间的注释代码, 开启 SSL 安全连接。
		/*
		 * // SMTP 服务器的端口 (非 SSL 连接的端口一般默认为 25, 可以不添加, 如果开启了 SSL 连接, //
		 * 需要改为对应邮箱的 SMTP 服务器的端口, 具体可查看对应邮箱服务的帮助, // QQ邮箱的SMTP(SLL)端口为465或587,
		 * 其他邮箱自行去查看) final String smtpPort = "465";
		 * props.setProperty("mail.smtp.port", smtpPort);
		 * props.setProperty("mail.smtp.socketFactory.class",
		 * "javax.net.ssl.SSLSocketFactory");
		 * props.setProperty("mail.smtp.socketFactory.fallback", "false");
		 * props.setProperty("mail.smtp.socketFactory.port", smtpPort);
		 */

		// 2. 根据配置创建会话对象, 用于和邮件服务器交互
		Session session = Session.getInstance(props);
		session.setDebug(true); // 设置为debug模式, 可以查看详细的发送 log

		// 3. 创建一封邮件

		MimeMessage message = createMimeMessage(session, sendMail, receiveMails, ccMails, bccMails, sendEmailSubject, sendEmailContent, imagefilepath, attachmentfiles);

		// 4. 根据 Session 获取邮件传输对象
		Transport transport = session.getTransport();

		// 5. 使用 邮箱账号 和 密码 连接邮件服务器, 这里认证的邮箱必须与 message 中的发件人邮箱一致, 否则报错
		//
		// PS_01: 成败的判断关键在此一句, 如果连接服务器失败, 都会在控制台输出相应失败原因的 log,
		// 仔细查看失败原因, 有些邮箱服务器会返回错误码或查看错误类型的链接, 根据给出的错误
		// 类型到对应邮件服务器的帮助网站上查看具体失败原因。
		//
		// PS_02: 连接失败的原因通常为以下几点, 仔细检查代码:
		// (1) 邮箱没有开启 SMTP 服务;
		// (2) 邮箱密码错误, 例如某些邮箱开启了独立密码;
		// (3) 邮箱服务器要求必须要使用 SSL 安全连接;
		// (4) 请求过于频繁或其他原因, 被邮件服务器拒绝服务;
		// (5) 如果以上几点都确定无误, 到邮件服务器网站查找帮助。
		//
		// PS_03: 仔细看log, 认真看log, 看懂log, 错误原因都在log已说明。
		transport.connect(sendMail.get("sendEmailAccount").toString(), sendMail.get("sendEmailPassword").toString());

		// 6. 发送邮件, 发到所有的收件地址, message.getAllRecipients()
		// 获取到的是在创建邮件对象时添加的所有收件人,抄送人, 密送人
		transport.sendMessage(message, message.getAllRecipients());

		// 7. 关闭连接
		transport.close();
	}


}
