package com.efuture.ocp.common.autorollback;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;

public class AutoRollBackService {

	// 操作列表
	private static final ThreadLocal<List<RollBackOperationData>> operationList = new ThreadLocal<List<RollBackOperationData>>();
	private static final ThreadLocal<Long> LocalTrans = new ThreadLocal<Long>();

	private static String rollbackhandleobject = "rollbackhandle";

	private static String autoRollbackList = "";

	public static String isEnable = "Y";

	public static Logger logger = Logger.getLogger(AutoRollBackService.class);

	public static Long opentrans() {
		List<Long> curtransary = UniqueID.getUniqueIDArray(10);
		Long curtransid = curtransary.get(4);
		LocalTrans.set(curtransid);
		return curtransid;
	}

	public static Long gettransid() {
		return LocalTrans.get();
	}

	public static boolean needAutoRollback(RollBackOperationData data) {
		String urlkey = data.getUrlkey();
		if (StringUtils.isEmpty("urlkey"))
			return false;

		if (autoRollbackList.toLowerCase().indexOf(urlkey.toLowerCase()) > -1) {
			return true;
		}
		return false;

	}

	public static void addOperation(RollBackOperationData data) {
		if (data == null) {
			return;
		}
		if (!needAutoRollback(data)) {
			return;
		}
		List<RollBackOperationData> oplist = operationList.get();
		if (oplist == null) {
			oplist = new ArrayList<RollBackOperationData>();
		}
		oplist.add(data);
		operationList.set(oplist);
	}

	public static void addRestOperation(ServiceSession ss, String url, String urlkey, Object param) {
		RollBackOperationData data = new RollBackOperationData();
		data.setUrl(url);
		data.setUrlkey(urlkey);
		data.setParam(param.toString());
		data.setSession(ss);
		addOperation(data);
	}

	public static void rollback() {

		try {
			if (SpringBeanFactory.containsBean(rollbackhandleobject)) {
				RollbackHandle rb = SpringBeanFactory.getBean(rollbackhandleobject, RollbackHandle.class);
				if (rb != null && operationList.get() != null) {
					rb.dorollback(operationList.get());
				}
			}
		} catch (Exception e) {
			logger.error("自动冲正发生错误->", e);
			operationList.remove();
			LocalTrans.remove();
		} finally {
			operationList.remove();
			LocalTrans.remove();
		}

	}

	public static void clean() {
		operationList.remove();
		LocalTrans.remove();
	}

	public static boolean IsEnable() {
		if (isEnable.equalsIgnoreCase("Y")) {
			if (LocalTrans.get() != null && LocalTrans.get() != 0) {
				if (SpringBeanFactory.containsBean(rollbackhandleobject)) {
					return true;
				} else {
					logger.info("启用了自动冲正,但是没有配置冲正处理对象!");
					return false;
				}
			}
		}
		return false;
	}

	public static void setIsEnable(String isEnable) {
		AutoRollBackService.isEnable = isEnable;
	}

	public static String getAutoRollbackList() {
		return autoRollbackList;
	}

	public static void setAutoRollbackList(String autoRollbackList) {
		AutoRollBackService.autoRollbackList = autoRollbackList;
	}

}
