package com.efuture.ocp.common.rest.userinterface;

import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 云平台portal用户信息和数据范围适配器
 *
 * @author zhouwd
 *
 */
//@Component("initSession_cloud")
public class CloudPortalSessionInit implements InitSession
{

	@Override
	public void init(ServiceSession session) {
		// token为空 OR dataRangeid 为空 OR dataRangeId = 0，不启用数据范围
		if (StringUtils.isEmpty(session.getToken()) || StringUtils.isEmpty( session.getDataRangeId() ) || "0".equalsIgnoreCase( session.getDataRangeId() ))
		{
			UserDataRangeSrv.setlocaltoken("");
		}
		else
		{
			if (session.getDataRangeId() == null)
			{
				session.setDataRangeId( "0" );
			}
			String token = session.getEnt_id() + "-" + session.getDataRangeId();
			UserDataRangeSrv.setlocaltoken( token );
		}
	}

}
