package com.efuture.ocp.common.slice.filter;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.filter.FtSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class CollectionSelectWrapper extends CollectionSliceWrapper
{
    protected void onSelectStatement(Logger logger, String sqlStatement, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt, ExecutorCallback callback)
            throws Throwable
    {
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;

        logJson.put("selectSql", sqlStatement);
        if ((selectStmt.getSelect().getQuery() instanceof SQLUnionQuery))
        {
            logJson.put("result", getUnionSqlInfo((SQLUnionQuery)selectStmt.getSelect().getQuery(), 1, callback));
        }
        else
        {
            logJson.put("result", getSqlInfo((SQLSelectQueryBlock)selectStmt.getSelect().getQuery(), callback));
        }

        StringBuffer newSql = new StringBuffer();
        SQLASTOutputVisitor visitor = null;
        if (getDbType().equals("mysql"))
        {
            visitor = new MySqlOutputVisitor(newSql);
        }
        else if (getDbType().equals("oracle"))
        {
            visitor = new OracleOutputVisitor(newSql);
        }
        else
        {
            throw new Exception("未识别的dbType");
        }
        visitor.visit(selectStmt);
        visitor.println();
        visitor.endVisit(selectStmt);

        SqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = copyFromMappedStatement(mappedStatement, sqlSource);

        invocation.getArgs()[0] = newMs;

        logJson.put("newSql", newSql.toString());

        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[SliceBase.PARAMETER_INDEX];
        }

        BoundSql newBoundSql = newMs.getBoundSql(parameter);
        if (invocation.getArgs().length == 6) {
            invocation.getArgs()[SliceBase.MAPPED_STATEMENT_INDEX] = newMs;
            invocation.getArgs()[SliceBase.BOUNDSQL_INDEX] = newBoundSql;
        }
        if (sqlStatement.equalsIgnoreCase( parameter.toString()))
        {
            invocation.getArgs()[SliceBase.PARAMETER_INDEX] = newBoundSql.getSql();
        }


        logJson.put("newSql", newSql.toString());

        String newStatement = newBoundSql.getSql();

        String message = String.format("nowSQL --->%1$s--->Params:%2$s--->Thread:%3$s", new Object[] { newStatement.replaceAll("[\\s]+", " "), parameter == null ? "<none>" : JSON.toJSONString(parameter), ""});
        sliceFilterLog(message);
    }
}