/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	RestClientFactory.java
 * Author:		亮
 * Date:		2014-3-27 下午2:39:12
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

/**
 * @author		亮
 * @description
 *
 */
public class RestClientFactory extends BaseKeyedPooledObjectFactory<Object, Client>
{
    //	/**
    //	 * @return
    //	 * @throws Exception
    //	 * @see org.apache.commons.pool2.BasePooledObjectFactory#create()
    //	 */
    //	@Override
    //	public Client create() throws Exception
    //	{
    //		ClientConfig config = new DefaultClientConfig();
    //
    //		// 默认10秒超时
    //		Client client = Client.create(config);
    //		client.setReadTimeout(10000);
    //
    //		return client;
    //	}

    /**
     * @return
     * @throws Exception
     * @see org.apache.commons.pool2.BaseKeyedPooledObjectFactory#create(Object) ()
     */
    @Override
    public Client create(Object key) throws Exception
    {
        ClientConfig config = new DefaultClientConfig();
        // 默认10秒超时
        Client client = Client.create(config);
        client.setReadTimeout(10000);
        return client;
    }

    //	/**
    //	 * @param paramT
    //	 * @return
    //	 * @see org.apache.commons.pool2.BasePooledObjectFactory#wrap(java.lang.Object)
    //	 */
    //	@Override
    //	public PooledObject<Client> wrap(Client paramT)
    //	{
    //		return new DefaultPooledObject<Client>(paramT);
    //	}
    /**
     * @param paramT
     * @return
     * @see org.apache.commons.pool2.BaseKeyedPooledObjectFactory#wrap(java.lang.Object)
     */
    @Override
    public PooledObject<Client> wrap(Client paramT)
    {
        return new DefaultPooledObject<>(paramT);
    }

    //	@Override
    //    public void destroyObject(PooledObject<Client> p) throws Exception
    //    {
    //        p.getObject().destroy();
    //    }
    @Override
    public void destroyObject(Object key, PooledObject<Client> p) throws Exception
    {
        p.getObject().destroy();
    }

    @Override
    public boolean validateObject(Object key, PooledObject<Client> p)
    {
        return super.validateObject(key, p);
    }

    @Override
    public void activateObject(Object key, PooledObject<Client> p) throws Exception
    {
        super.activateObject(key, p);
    }

    @Override
    public void passivateObject(Object key, PooledObject<Client> p) throws Exception
    {
        super.passivateObject(key, p);
    }

}
