/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.cache.CacheUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.rubyeye.xmemcached.GetsResponse;

public class CacheUtilsInMemory
extends CacheUtils
implements Serializable {
    private static final Map<String, byte[]> CACHE_MAP = new ConcurrentHashMap<String, byte[]>();
    private static final String EXPIREKEY = "_ExpireTime";

    @Override
    public String putData(String key, Object object, int timeout) {
        CACHE_MAP.put(key, SerializeUtil.serialize(object));
        CACHE_MAP.put(key.concat(EXPIREKEY), SerializeUtil.serialize(System.currentTimeMillis() + (long)timeout * 1000L));
        return key;
    }

    @Override
    public Object getData(String key) {
        if (CacheUtilsInMemory.checkCacheName(key)) {
            return SerializeUtil.unserialize(CACHE_MAP.get(key));
        }
        return null;
    }

    @Override
    public Object getCacheData(String key) {
        return null;
    }

    @Override
    public boolean deleteData(String key) {
        CacheUtilsInMemory.remove(key);
        return true;
    }

    @Override
    public long getCasValue(String key) {
        return 0L;
    }

    @Override
    public GetsResponse getCasData(String key) {
        return null;
    }

    @Override
    public boolean putbyCas(String key, Object object, int timeout, long casvalue) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteBatch(String key) {
        int result = 0;
        for (Map.Entry<String, byte[]> entry : CACHE_MAP.entrySet()) {
            if (!entry.getKey().contains(key)) continue;
            CacheUtilsInMemory cacheUtilsInMemory = this;
            synchronized (cacheUtilsInMemory) {
                CacheUtilsInMemory.remove(entry.getKey());
                ++result;
            }
        }
        return result;
    }

    public static void removeAll() {
        CACHE_MAP.clear();
    }

    public static void remove(String cacheName) {
        CACHE_MAP.remove(cacheName);
        CACHE_MAP.remove(cacheName.concat(EXPIREKEY));
    }

    public static boolean checkCacheName(String cacheName) {
        Long cacheHoldTime = (Long)SerializeUtil.unserialize(CACHE_MAP.get(cacheName.concat(EXPIREKEY)));
        if (cacheHoldTime == null || cacheHoldTime == 0L) {
            return false;
        }
        if (cacheHoldTime < System.currentTimeMillis()) {
            CacheUtilsInMemory.remove(cacheName);
            return false;
        }
        return true;
    }
}

