/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BaseService;
import com.efuture.ocp.common.datasync.DataSyncUtils;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.AlreadyExistException;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.listener.BeanChangeEvent;
import com.efuture.ocp.common.util.BeanField;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omd.storage.Virtual;
import com.efuture.omd.storage.parser.QueryExtractor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class BasicComponent
extends BaseService {
    public static final String StorageOperation = "StorageOperation";
    public static final String GlobalStorageOperation = "GlobalStorageOperation";
    public static final String PortalStorageOperation = "StorageOperation_portal";
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    public String StorageOperation_other = "";

    public void setStorageOperation_other(String sokey) {
        this.StorageOperation_other = sokey;
    }

    public String getStorageOperationKey() {
        if (!StringUtils.isEmpty((Object)this.StorageOperation_other) && SpringBeanFactory.containsBean(this.StorageOperation_other)) {
            return this.StorageOperation_other;
        }
        String key = this.getCustomizeStorageKey();
        if (!StringUtils.isEmpty((Object)key)) {
            return key;
        }
        return StorageOperation;
    }

    protected String getCustomizeStorageKey() {
        return null;
    }

    public FStorageOperations getStorageOperations() {
        return SpringBeanFactory.getBean(this.getStorageOperationKey(), FStorageOperations.class);
    }

    public FStorageOperations getGlobalStorageOperations() {
        return SpringBeanFactory.getBean(GlobalStorageOperation, FStorageOperations.class);
    }

    public FStorageOperations getStorageOperationConfig(String def) {
        return SpringBeanFactory.getBean(def, FStorageOperations.class);
    }

    public <T> T getStorageOperations(Class<T> clazz) {
        return SpringBeanFactory.getBean(this.getStorageOperationKey(), clazz);
    }

    public <T> T getGlobalStorageOperations(Class<T> clazz) {
        return SpringBeanFactory.getBean(GlobalStorageOperation, clazz);
    }

    public <T> T getStorageOperations(String key, Class<T> clazz) {
        return SpringBeanFactory.getBean(key, clazz);
    }

    public FStorageOperations getStorageOperations(String key) {
        return SpringBeanFactory.getBean(key, FStorageOperations.class);
    }

    protected void checkPara(ServiceSession session, JSONObject jsonparam) {
        if (session == null) {
            throw new ServiceException("10000", "{0} is NULL ", "session");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("10000", "{0} is NULL ", "param");
        }
        if (!(jsonparam instanceof JSONObject)) {
            throw new ServiceException("10000", "{0} is not JSONObject ", "param in");
        }
    }

    protected void onAddValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        bean.validateBean(new String[0]);
        if (storage != null) {
            for (int i = 0; uniques != null && i < uniques.length; ++i) {
                String[] uks = uniques[i].split(",");
                if (uks.length <= 0) continue;
                String code = null;
                Field fld = null;
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id());
                for (String k : uks) {
                    code = k.trim();
                    fld = bean.fetchDeclaredField(code);
                    Object obj = fld.get(bean);
                    if (StringUtils.isEmpty((Object)obj)) continue;
                    criteria = criteria.and(code).is(obj);
                }
                Query query = new Query((CriteriaDefinition)criteria);
                this.printDebug(String.format("Bean:[%1$s] Operate:[doAdd(%2$s) valid dup] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
                Object existbean = storage.selectOne(query, bean.getClass());
                if (existbean == null) continue;
                throw new AlreadyExistException("10001", "{0} {1} [{2}] already exists", MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang(), new Object[0]), code, fld.get(bean));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        FStorageOperations storage = null;
        try {
            this.beforeInsert(bean);
            Field idfld = bean.fetchDeclaredField(id);
            if (idfld.getLong(bean) <= 0L) {
                idfld.set(bean, UniqueID.getUniqueID());
            }
            storage = this.getStorageOperations();
            this.onAddValid(storage, bean, id, uniques);
            this.printDebug(String.format("Bean:[%1$s] Operate:[doAdd(%2$s)] MongoSyntax:[%3$s->%4$20d]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), bean.getEnt_id(), idfld.getLong(bean)));
            storage.insert((Object)bean);
            this.postBeanChangeEvent("I", bean.getCreator(), bean.getCreator_name(), bean, bean, null);
            this.doSyncData(bean);
            this.afterInsert(bean);
            long l = idfld.getLong(bean);
            return l;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected void onOriginalUpdateValid(AbstractEntityBean original, AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) {
    }

    protected AbstractEntityBean onUpdateValid(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        ArrayList<String> vk = new ArrayList<String>();
        vk.add("ent_id");
        vk.add(id);
        if (keys != null) {
            for (String k : keys) {
                vk.add(k);
            }
        }
        bean.validateBeanForSpecified(vk.toArray(new String[vk.size()]));
        AbstractEntityBean original = null;
        if (storage != null) {
            Field idfld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(idfld.get(bean));
            Query query = new Query((CriteriaDefinition)criteria);
            original = (AbstractEntityBean)storage.selectOne(query, bean.getClass());
            if (original != null) {
                this.onOriginalUpdateValid(original, bean, keys, id, uniques);
            }
            for (int i = 0; uniques != null && i < uniques.length; ++i) {
                String code;
                String[] uks = uniques[i].split(",");
                if (uks.length <= 0 || !keys.contains(code = uks[uks.length - 1].trim())) continue;
                Field fld = null;
                criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id());
                for (String k : uks) {
                    code = k.trim();
                    fld = bean.fetchDeclaredField(code);
                    Object obj = null;
                    obj = !keys.contains(code) && original != null ? fld.get(original) : fld.get(bean);
                    if (StringUtils.isEmpty((Object)obj)) continue;
                    criteria = criteria.and(code).is(obj);
                }
                criteria = criteria.and(id).ne(bean.fetchDeclaredField(id).get(bean));
                query = new Query((CriteriaDefinition)criteria);
                this.printDebug(String.format("Bean:[%1$s] Operate:[doUpdate(%2$s) valid dup] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
                Object existbean = storage.selectOne(query, bean.getClass());
                if (existbean == null) continue;
                throw new AlreadyExistException("10001", "{0} {1} [{2}] already exists", MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang(), new Object[0]), code, fld.get(bean));
            }
        }
        return original;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doUpdate(AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        this.beforeUpdate(bean);
        AbstractEntityBean original = this.execUpdate(bean, keys, id, uniques);
        this.afterUpdate(bean);
        if (original != null) {
            Field fld = bean.fetchDeclaredField(id);
            return fld.get(original);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public AbstractEntityBean execUpdate(AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        FStorageOperations storage = null;
        try {
            if (keys == null) {
                keys = new HashSet<String>();
                StringBuffer sb = new StringBuffer();
                bean.fetchAllDeclaredField(sb);
                String[] ss = sb.toString().split(",");
                for (int i = 0; i < ss.length; ++i) {
                    keys.add(ss[i]);
                }
            } else {
                if (!(keys instanceof HashSet)) {
                    keys = new HashSet<String>(keys);
                }
                keys.add("timestamp");
                keys.add("modifier_id");
                keys.add("modifier");
            }
            storage = this.getStorageOperations();
            AbstractEntityBean original = this.onUpdateValid(storage, bean, keys, id, uniques);
            Field fld = bean.fetchDeclaredField(id);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(fld.get(bean)));
            Update upt = StorageUtils.createUpdateFormBean(bean, keys);
            this.printDebug(String.format("Bean:[%1$s] Operate:[doUpdate(%2$s)/update] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
            if (storage.update(query, upt, bean.getClass()) <= 0) {
                throw new ServiceException("10003", "{0} {1} [{2}] does not exist", MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang(), new Object[0]), id, fld.get(bean));
            }
            this.postBeanChangeEvent("U", bean.getModifier(), bean.getModifier_name(), original, bean, null);
            this.doSyncData(bean);
            AbstractEntityBean abstractEntityBean = original;
            return abstractEntityBean;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected void beforeInsert(AbstractEntityBean bean) throws Exception {
    }

    protected void afterInsert(AbstractEntityBean bean) throws Exception {
    }

    protected void beforeUpdate(AbstractEntityBean bean) throws Exception {
    }

    protected void afterUpdate(AbstractEntityBean bean) throws Exception {
    }

    protected void beforeDelete(AbstractEntityBean bean) throws Exception {
    }

    protected void afterDelete(AbstractEntityBean bean) throws Exception {
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void postBeanChangeEvent(String oper, String usercode, String username, AbstractEntityBean originalbean, AbstractEntityBean newbean, String type) throws Exception {
        JSONObject json = new JSONObject();
        json.put("op", (Object)oper);
        json.put("usercode", (Object)usercode);
        json.put("username", (Object)username);
        json.put("originalbean", (Object)originalbean);
        json.put("newbean", (Object)newbean);
        json.put("beantype", (Object)(StringUtils.isEmpty((Object)type) ? "Master" : type));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new BeanChangeEvent(json));
    }

    private void doSyncData(AbstractEntityBean bean) {
        DataSyncUtils.sync(bean);
    }

    protected void onOriginalDeleteValid(AbstractEntityBean original, AbstractEntityBean bean, String id, String ... keys) {
    }

    protected AbstractEntityBean onDeleteValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... keys) throws Exception {
        ArrayList<String> vk = new ArrayList<String>();
        vk.add("ent_id");
        vk.add(id);
        if (keys != null) {
            for (String string : keys) {
                vk.add(string);
            }
        }
        bean.validateBeanForSpecified(vk.toArray(new String[vk.size()]));
        AbstractEntityBean original = null;
        if (storage != null) {
            Query query;
            Field idfld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(idfld.get(bean));
            if (keys != null) {
                for (String k : keys) {
                    Field fd = bean.fetchDeclaredField(k);
                    criteria = criteria.and(k).is(fd.get(bean));
                }
            }
            if ((original = (AbstractEntityBean)storage.selectOne(query = new Query((CriteriaDefinition)criteria), bean.getClass())) != null) {
                this.onOriginalDeleteValid(original, bean, id, keys);
            }
        }
        return original;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        this.beforeDelete(bean);
        this.onDeleteValid(bean, id, keys);
        AbstractEntityBean original = this.execDelete(bean, id, keys);
        this.afterDelete(bean);
        if (original != null) {
            Field fld = bean.fetchDeclaredField(id);
            return fld.get(original);
        }
        return 0;
    }

    protected void onDeleteValid(AbstractEntityBean bean, String id, String ... keys) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public AbstractEntityBean execDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            AbstractEntityBean original = this.onDeleteValid(storage, bean, id, keys);
            Field fld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(fld.get(bean));
            if (keys != null && keys.length != 0) {
                for (String k : keys) {
                    Field fd = bean.fetchDeclaredField(k);
                    criteria = criteria.and(k).is(fd.get(bean));
                }
            }
            Query query = new Query((CriteriaDefinition)criteria);
            this.printDebug(String.format("Bean:[%1$s] Operate:[doDelete(%2$s)] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
            storage.delete(query, bean.getClass());
            this.postBeanChangeEvent("D", bean.getModifier(), bean.getModifier_name(), original, bean, null);
            AbstractEntityBean abstractEntityBean = original;
            return abstractEntityBean;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public List<Map<String, Object>> doSearchForMap(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        if (!jsonparam.containsKey((Object)"fields")) {
            StringBuffer sb = new StringBuffer();
            AbstractEntityBean.fetchAllDeclaredField(objClass, sb);
            jsonparam.put("fields", (Object)sb.toString());
        }
        return this.doGet(jsonparam, objClass, total);
    }

    public Map<String, Object> doSearchOneForMap(JSONObject jsonparam, Class<?> objClass) throws Exception {
        jsonparam.put("page_size", (Object)1);
        List<Map<String, Object>> list = this.doSearchForMap(jsonparam, objClass, null);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public <T> List<T> doSearch(JSONObject jsonparam, Class<T> objClass, StringBuffer total) throws Exception {
        jsonparam.remove((Object)"fields");
        return this.doGet(jsonparam, objClass, total);
    }

    public <T> T doSearchOne(JSONObject jsonparam, Class<T> objClass) throws Exception {
        jsonparam.put("page_size", (Object)1);
        List<T> list = this.doSearch(jsonparam, objClass, null);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            Query query = null;
            if (jsonparam.containsKey((Object)"ignorefilter")) {
                jsonparam.remove((Object)"ignorefilter");
            }
            query = total == null && !jsonparam.containsKey((Object)"page_size") ? StorageUtils.createQueryFormJson(jsonparam, objClass, false) : (jsonparam.containsKey((Object)"page_size") && 0 == jsonparam.getInteger("page_size") ? StorageUtils.createQueryFormJson(jsonparam, objClass, false) : StorageUtils.createQueryFormJson(jsonparam, objClass));
            List list = null;
            if (jsonparam.containsKey((Object)"fields") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
                this.printDebug(String.format("Bean:[%1$s] Operate:[doGet(%2$s)Map] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), AbstractEntityBean.fetchAnnotationTableName(objClass), query));
                list = storage.select(query, AbstractEntityBean.fetchAnnotationTableName(objClass));
            } else {
                this.printDebug(String.format("Bean:[%1$s] Operate:[doGet(%2$s)Bean] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), AbstractEntityBean.fetchAnnotationTableName(objClass), query));
                list = storage.select(query, objClass);
            }
            if (total != null) {
                total.delete(0, total.length());
                if (list == null || list.size() <= 0) {
                    total.append("0");
                } else if (query.getLimit() > 0) {
                    total.append(storage.count(query, objClass));
                } else {
                    total.append(list.size());
                }
            }
            List list2 = list;
            return list2;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected void analyzeExportFields(String specfld, StringBuffer flds, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts) {
        String[] fields;
        for (String s : fields = specfld.split(",")) {
            String[] ss = s.split("::");
            if (ss == null || ss.length < 2) {
                ss = s.split(":");
            }
            if (!"totalCount".equals(ss[0].trim()) && !"modulecode".equals(ss[0].trim())) {
                flds.append(ss[0].trim() + ",");
                fldlst.add(ss[0].trim());
            }
            if (ss.length > 1) {
                disps.put(ss[0].trim(), ss[1].trim());
                if (ss.length <= 2) continue;
                fmts.put(ss[0].trim(), ss[2].trim().replace(";", ","));
                continue;
            }
            disps.put(ss[0].trim(), ss[0].trim());
        }
    }

    protected String createExportXLS(List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts) {
        StringBuffer sb = new StringBuffer();
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\r\n");
        sb.append("<table cellspacing=\"0\" cellpadding=\"5\" rules=\"all\" border=\"1\">\r\n");
        sb.append("<tr style=\"font-weight: bold; color:red; white-space: nowrap;\">\r\n");
        for (String string : fldlst) {
            sb.append(String.format("<td>%1$s</td>\r\n", disps.get(string)));
        }
        sb.append("</tr>\r\n");
        if (list != null) {
            for (Map map : list) {
                sb.append("<tr>\r\n");
                for (String s : fldlst) {
                    Object obj = map.get(s);
                    if (obj == null) {
                        sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:@\">%1$s</td>\r\n", ""));
                        continue;
                    }
                    String style = fmts.get(s);
                    if (obj instanceof Date) {
                        SimpleDateFormat sdf;
                        String time;
                        if (StringUtils.isEmpty((Object)style)) {
                            style = "yyyy-MM-dd HH:mm:ss";
                        }
                        if ((time = (sdf = new SimpleDateFormat(style)).format((Date)obj)).endsWith(" 00:00:00")) {
                            time = time.replace(" 00:00:00", "");
                        }
                        sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:@\">%1$s</td>\r\n", time));
                        continue;
                    }
                    if (StringUtils.isEmpty((Object)style)) {
                        style = obj instanceof Integer || obj instanceof Long || obj instanceof Short ? "0" : (obj instanceof Double || obj instanceof Float ? "#,##0.00" : "@");
                    }
                    sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", obj));
                }
                sb.append("</tr>\r\n");
            }
        }
        sb.append("</table>\r\n");
        return sb.toString();
    }

    protected String getParam(JSONObject param, String key, String defaultVal) {
        if (param == null || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            return defaultVal;
        }
        return param.getString(key);
    }

    protected String getParamWithCheck(JSONObject param, String key, boolean checknull, String defaultVal) {
        if (param == null || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getString(key);
    }

    protected int getParamWithCheck(JSONObject param, String key, boolean checknull, int defaultVal) {
        if (param == null || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getInteger(key);
    }

    protected long getParamWithCheck(JSONObject param, String key, boolean checknull, long defaultVal) {
        if (param == null || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getLongValue(key);
    }

    protected double getParamWithCheck(JSONObject param, String key, boolean checknull, double defaultVal) {
        if (param == null || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getDoubleValue(key);
    }

    protected Date getParamWithCheck(JSONObject param, String key, boolean checknull, Date defaultVal) {
        if (param == null || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getDate(key);
    }

    public Object getColData(FMybatisTemplate storage, Object o, String type2) {
        SimpleDateFormat timefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (type2.contains("long")) {
            o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
        } else if (type2.contains("int")) {
            o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
        } else if (type2.contains("float")) {
            o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
        } else if (type2.contains("double")) {
            o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
        } else if (type2.contains("short")) {
            o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
        } else if (type2.contains("boolean")) {
            if (!(o instanceof Boolean)) {
                o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
            }
        } else if (type2.contains("date")) {
            if (StringUtils.isEmpty((Object)o)) {
                o = null;
            } else {
                String s = timefmt.format(o);
                o = storage.getDBType() == QueryExtractor.DBTYPE.ORACLE ? "to_date('" + s + "', 'yyyy-MM-dd hh24:mi:ss')" : "'" + s + "'";
            }
        } else if (type2.contains("string")) {
            o = o == null ? String.valueOf(o) : "'" + String.valueOf(o).replace("'", "\u2019") + "'";
        }
        return o;
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists) throws Exception {
        this.batchInsert(storage, objClass, lists, 1000);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists, int batch_rows) throws Exception {
        if (lists.size() <= 0) {
            return;
        }
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new Exception("unsupport DBMS Type!");
        }
        String tbl = AbstractEntityBean.fetchAnnotationTableName(objClass);
        StringBuffer sb = new StringBuffer();
        AbstractEntityBean.fetchAllDeclaredField(objClass, sb);
        String[] flds = sb.toString().split(",");
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        for (String string : flds) {
            Field fld = AbstractEntityBean.fetchDeclaredField(objClass, string);
            if (fld == null || fld.getAnnotation(Transient.class) != null || fld.getAnnotation(Virtual.class) != null) continue;
            BeanField bf = new BeanField();
            bf.setColName(string);
            bf.setField(fld);
            bf.setColType(fld.getType().getName().toLowerCase());
            beanFields.add(bf);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tbl).append("(");
        for (BeanField beanField : beanFields) {
            tabsql.append(beanField.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
                    if (!firstrow) {
                        stringBuffer.append(" union all ");
                    }
                    stringBuffer.append(" select ");
                    for (BeanField col : beanFields) {
                        stringBuffer.append(this.getColData(storage, col.getField().get(bean), col.getColType()));
                        stringBuffer.append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    if (firstrow) {
                        stringBuffer.append(" values ");
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("(");
                    for (BeanField col : beanFields) {
                        stringBuffer.append(this.getColData(storage, col.getField().get(bean), col.getColType()));
                        stringBuffer.append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(")");
                } else if (dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        stringBuffer.append(" union all ");
                    }
                    stringBuffer.append(" select ");
                    for (BeanField col : beanFields) {
                        stringBuffer.append(this.getColData(storage, col.getField().get(bean), col.getColType()));
                        stringBuffer.append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(" ");
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", (Object)stringBuffer.toString());
        }
    }

    public static double RoundNew(double num, int scale) {
        double result;
        BigDecimal bd = new BigDecimal(num);
        switch (scale) {
            case 0: {
                result = Math.floor(num * 100.0) / 100.0;
                break;
            }
            case 1: {
                result = bd.setScale(1, 4).doubleValue();
                break;
            }
            case 2: {
                result = (int)num;
                break;
            }
            case 3: {
                result = Math.floor(num * 10.0) / 10.0;
                break;
            }
            case 4: {
                result = bd.setScale(0, 4).doubleValue();
                break;
            }
            case 5: {
                result = bd.setScale(2, 4).doubleValue();
                break;
            }
            default: {
                result = bd.setScale(2, 4).doubleValue();
            }
        }
        return result;
    }

    public static interface BEANTYPE {
        public static final String MASTER = "Master";
        public static final String SLAVE = "Slave";
    }

    public static interface OP {
        public static final String INSERT = "I";
        public static final String DELETE = "D";
        public static final String UPDATE = "U";
    }
}

