/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.ReportServiceImpl;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.component.GlobRuleSrv;
import com.efuture.ocp.common.component.excel.ExcelImportErrServiceImpl;
import com.efuture.ocp.common.component.excel.ImpErrMsgBean;
import com.efuture.ocp.common.component.excel.ModuleImpConfigDetBean;
import com.efuture.ocp.common.component.excel.ModuleImpConfigHeadBean;
import com.efuture.ocp.common.component.excel.ModuleImpConfigServiceImpl;
import com.efuture.ocp.common.component.excel.uiconfig.UiClass;
import com.efuture.ocp.common.component.excel.uiconfig.UiClassSrv;
import com.efuture.ocp.common.component.excel.uiconfig.UiProperty;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExcelComponent
extends BasicComponent {
    private int impReadRow = 1;
    private int maxRow = -1;
    private int maxErrRow = 20;
    private int maxWriteRows = 100000;
    private int maxWriteRowsSheet = 20000;
    private static ServiceMethodReflect rcm = new ServiceMethodReflect();
    @Autowired
    private ModuleImpConfigServiceImpl moduleImpConfigSrv;
    @Autowired
    private ExcelImportErrServiceImpl excelImpErrSrv;
    @Autowired
    BatchInsService batchInsSrv;
    @Autowired
    private GlobRuleSrv globrulesrv;
    @Autowired
    private UiClassSrv uiClassSrv;
    private static final ThreadLocal<Map<String, Object>> fields = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> exportTemplate(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.checkPara(session, jsonparam);
        String billmoduleid = this.getParamWithCheck(jsonparam, "billmoduleid", true, "");
        String filename = billmoduleid + "-ImportTemplate";
        List<ModuleImpConfigHeadBean> list = this.moduleImpConfigSrv.getModuleImpConfigList(session.getEnt_id(), billmoduleid);
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
        sxssfWorkbook = this.createExcelTemplate(list, sxssfWorkbook);
        ByteArrayOutputStream output = null;
        InputStream inputStream = null;
        try {
            output = new ByteArrayOutputStream();
            sxssfWorkbook.write((OutputStream)output);
            inputStream = new ByteArrayInputStream(output.toByteArray());
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (sxssfWorkbook != null) {
                        sxssfWorkbook.dispose();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputStream", inputStream);
        map.put("filename", filename + ".xlsx");
        return map;
    }

    public SXSSFWorkbook createExcelTemplate(List<ModuleImpConfigHeadBean> list, SXSSFWorkbook sxssfWorkbook) throws Exception {
        for (ModuleImpConfigHeadBean config : list) {
            config = this.moduleImpConfigSrv.getModuleImpConfig(config.getEnt_id(), config.getEid());
            sxssfWorkbook = this.createExcel(null, config, sxssfWorkbook);
        }
        return sxssfWorkbook;
    }

    public String createExcelSheetName(ModuleImpConfigHeadBean config) {
        String name = "\u6a21\u5757" + config.getModuleid() + config.getEname() + "-Template";
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SXSSFWorkbook createExcel(List<Map<String, Object>> list, ModuleImpConfigHeadBean config, SXSSFWorkbook sxssfWorkbook) {
        try {
            String sheetname = this.createExcelSheetName(config);
            Sheet sheet = sxssfWorkbook.createSheet(sheetname);
            sheet.createFreezePane(0, 1);
            Row header = sheet.createRow(0);
            sheet = this.createExcelHead(config, header, sheet, sxssfWorkbook);
            SXSSFWorkbook sXSSFWorkbook = sxssfWorkbook;
            return sXSSFWorkbook;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Sheet createExcelHead(ModuleImpConfigHeadBean config, Row header, Sheet sheet, SXSSFWorkbook sxssfWorkbook) {
        List fields = config.getModuleimpconfigdet().stream().filter(s -> !"Y".equalsIgnoreCase(s.getDefaultparam())).collect(Collectors.toList());
        fields.stream().sorted(Comparator.comparing(ModuleImpConfigDetBean::getIsorder));
        CellStyle cellHeadStyleRed = this.createHeadCellStyleRed(sxssfWorkbook);
        CellStyle cellHeadStyleNormal = this.createHeadCellStyleNormal(sxssfWorkbook);
        for (int cellnum = 0; cellnum < fields.size(); ++cellnum) {
            Cell cell = header.createCell(cellnum);
            cell.setCellValue(((ModuleImpConfigDetBean)fields.get(cellnum)).getField_name());
            if (!StringUtils.isEmpty((Object)((ModuleImpConfigDetBean)fields.get(cellnum)).getIsnonullfield()) && "Y".equals(((ModuleImpConfigDetBean)fields.get(cellnum)).getIsnonullfield())) {
                cell.setCellStyle(cellHeadStyleRed);
            } else {
                cell.setCellStyle(cellHeadStyleNormal);
            }
            sheet.setColumnWidth(cellnum, 5120);
        }
        return sheet;
    }

    public CellStyle createHeadCellStyleRed(SXSSFWorkbook sxssfWorkbook) {
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        Font f = sxssfWorkbook.createFont();
        f.setFontHeightInPoints((short)9);
        f.setBoldweight((short)700);
        f.setColor((short)10);
        cellStyle.setFont(f);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    public CellStyle createHeadCellStyleNormal(SXSSFWorkbook sxssfWorkbook) {
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        Font f = sxssfWorkbook.createFont();
        f.setFontHeightInPoints((short)9);
        f.setBoldweight((short)700);
        f.setColor((short)Short.MAX_VALUE);
        cellStyle.setFont(f);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    public CellStyle createCellStyle(SXSSFWorkbook sxssfWorkbook) {
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setAlignment((short)1);
        cellStyle.setDataFormat(sxssfWorkbook.createDataFormat().getFormat("@"));
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    public ServiceResponse importExcel(ServiceSession session, String param, String srvname, List<FileImportObject> list) throws Exception {
        JSONObject jsonparam = JSON.parseObject((String)param);
        this.checkPara(session, jsonparam);
        String billmoduleid = this.getParamWithCheck(jsonparam, "billmoduleid", true, "");
        String eid = this.getParamWithCheck(jsonparam, "eid", false, "");
        JSONObject jsonpara = JSONObject.parseObject((String)param);
        jsonpara.put("eid", (Object)eid);
        ModuleImpConfigHeadBean config = this.moduleImpConfigSrv.getModuleImpConfig(session.getEnt_id(), eid, billmoduleid);
        Object initvar = rcm.executeClassMethod(srvname + ".beforeExcelImport", session, jsonpara.toString());
        JSONObject json = null;
        jsonpara.put("initvar", initvar);
        for (FileImportObject fio : list) {
            if (!fio.getFilename().toLowerCase().endsWith(".xlsx")) continue;
            json = this.Verify(session, jsonpara, srvname, fio.getStream(), config, this.maxRow);
        }
        if (!StringUtils.isEmpty(json) && StringUtils.isEmpty((Object)json.get((Object)"errcode"))) {
            rcm.executeClassMethod(srvname + ".afterExcelImport", session, jsonpara.toString());
        }
        return ServiceResponse.buildSuccess(json);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject Verify(ServiceSession session, JSONObject param, String srvname, InputStream is, ModuleImpConfigHeadBean config, long maxrow) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList<ImpErrMsgBean> errlist = new ArrayList<ImpErrMsgBean>();
        XSSFWorkbook hssfWorkbook = new XSSFWorkbook(is);
        List<ModuleImpConfigDetBean> fields = config.getModuleimpconfigdet();
        List defaultfields = fields.stream().filter(s -> "Y".equalsIgnoreCase(s.getDefaultparam())).collect(Collectors.toList());
        List normalfields = fields.stream().filter(s -> !"Y".equalsIgnoreCase(s.getDefaultparam())).collect(Collectors.toList());
        String uniquecols = config.getUniquecolumn();
        String norepeatcols = config.getIsnorepeatfield();
        HashMap<Object, Set<String>> basemap = new HashMap<Object, Set<String>>();
        int total = 0;
        int numSheet = 0;
        while (numSheet < hssfWorkbook.getNumberOfSheets()) {
            XSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet != null) {
                int celcount = hssfSheet.getRow(0).getPhysicalNumberOfCells();
                for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; ++rowNum) {
                    XSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    JSONObject json = new JSONObject();
                    ++total;
                    boolean success = true;
                    for (int celNum = 0; celNum < celcount; ++celNum) {
                        Object cellValue;
                        String colname;
                        String colkey;
                        ModuleImpConfigDetBean det;
                        block26: {
                            int col = celNum + 1;
                            List det1 = normalfields.stream().filter(s -> s.getIsorder() == col).collect(Collectors.toList());
                            if (StringUtils.isEmpty(det1) || det1.size() <= 0) continue;
                            det = (ModuleImpConfigDetBean)det1.get(0);
                            colkey = det.getField();
                            colname = det.getField_name();
                            XSSFCell cell = hssfRow.getCell(celNum);
                            cellValue = "";
                            if (!StringUtils.isEmpty((Object)cell)) {
                                try {
                                    if (cell.getCellType() == 3) break block26;
                                    if (cell.getCellType() == 5) {
                                        throw new Exception("\u683c\u5f0f\u9519\u8bef");
                                    }
                                    if (cell.getCellType() == 2) {
                                        throw new Exception("\u4e3a\u8868\u8fbe\u5f0f");
                                    }
                                    if (cell.getCellType() == 1) {
                                        if ("S".equalsIgnoreCase(det.getField_datatype())) {
                                            cellValue = cell.getStringCellValue();
                                        } else if ("N".equalsIgnoreCase(det.getField_datatype())) {
                                            cellValue = new DecimalFormat("#.######").format(Double.parseDouble(cell.getStringCellValue()));
                                        } else {
                                            if (!"D".equalsIgnoreCase(det.getField_datatype())) throw new Exception("\u683c\u5f0f\u9519\u8bef");
                                            cellValue = DateUtils.parseDateStrictly((String)cell.getStringCellValue(), (String[])new String[]{StringUtils.isEmpty((Object)det.getFormat()) ? "yyyy-MM-dd" : det.getFormat()});
                                        }
                                    } else if (cell.getCellType() == 0) {
                                        if ("S".equalsIgnoreCase(det.getField_datatype())) {
                                            cellValue = new DecimalFormat("#").format(cell.getNumericCellValue());
                                        } else if ("N".equalsIgnoreCase(det.getField_datatype())) {
                                            cellValue = new DecimalFormat("#.######").format(cell.getNumericCellValue());
                                        } else {
                                            if (!"D".equalsIgnoreCase(det.getField_datatype())) throw new Exception("\u683c\u5f0f\u9519\u8bef");
                                            cellValue = DateUtils.formatDateByFormat(cell.getDateCellValue(), StringUtils.isEmpty((Object)det.getFormat()) ? "yyyy-MM-dd" : det.getFormat());
                                        }
                                    } else {
                                        cellValue = cell.getStringCellValue();
                                    }
                                }
                                catch (Exception e) {
                                    success = false;
                                    this.handleErrMsg(session, config, "3", "\u7b2c" + json.get((Object)config.getTiprowcol()) + "\u884c\u5b57\u6bb5" + colname + e.getMessage(), errlist);
                                    break;
                                }
                            }
                        }
                        if ("Y".equals(det.getIsnonullfield()) && StringUtils.isEmpty((Object)cellValue)) {
                            success = false;
                            this.handleErrMsg(session, config, "1", "\u7b2c" + json.get((Object)config.getTiprowcol()) + "\u884c\u5b57\u6bb5" + colname + "\u975e\u7a7a", errlist);
                            break;
                        }
                        json.put(colkey, cellValue);
                    }
                    if (!success) continue;
                    for (ModuleImpConfigDetBean field : defaultfields) {
                        json.put(field.getField(), (Object)field.getDefaultvalue());
                    }
                    if (!ExcelComponent.repeatVerify(json, uniquecols, "unique", basemap)) {
                        String uniquecolsname = ExcelComponent.getColNames(uniquecols, fields);
                        this.handleErrMsg(session, config, "2", "\u7b2c" + json.get((Object)config.getTiprowcol()) + "\u884c\u6570\u636e" + uniquecolsname + "\u91cd\u590d", errlist);
                        continue;
                    }
                    if (!ExcelComponent.repeatVerify(json, norepeatcols, "norepeat", basemap)) {
                        String norepeatcolsname = ExcelComponent.getColNames(norepeatcols, fields);
                        this.handleErrMsg(session, config, "2", "\u7b2c" + json.get((Object)config.getTiprowcol()) + "\u884c\u6570\u636e" + norepeatcolsname + "\u91cd\u590d", errlist);
                        continue;
                    }
                    Object retdata = rcm.executeClassMethodForObjectJSON(srvname + ".importExcelSingle", session, param, json);
                    JSONObject retjson = (JSONObject)retdata;
                    if (!(StringUtils.isEmpty((Object)retjson) || StringUtils.isEmpty((Object)retjson.get((Object)"errcode")) || "0".equals(retjson.get((Object)"errcode")))) {
                        this.handleErrMsg(session, config, retjson.get((Object)"errcode").toString(), "\u7b2c" + json.get((Object)config.getTiprowcol()) + "\u884c\u6570\u636e" + retjson.get((Object)"errmsg"), errlist);
                        continue;
                    }
                    list.add((Map<String, Object>)json);
                }
            }
            ++numSheet;
        }
        return this.genrateRtnJSON(session.getEnt_id(), config, list, errlist, total);
    }

    public static String getColNames(String cols, List<ModuleImpConfigDetBean> list) {
        List<String> collist = Arrays.asList(cols.split(","));
        String colsname = "";
        for (String col : collist) {
            List det = list.stream().filter(s -> s.getField().equals(col)).collect(Collectors.toList());
            if (StringUtils.isEmpty(det) || det.size() <= 0) continue;
            colsname = colsname + ((ModuleImpConfigDetBean)det.get(0)).getField_name() + ",";
        }
        if (!StringUtils.isEmpty((Object)colsname)) {
            colsname = colsname.substring(0, colsname.length() - 1);
        }
        return colsname;
    }

    public static String getColValue(JSONObject json, String[] cols) {
        StringBuffer buf = new StringBuffer();
        for (String col : cols) {
            Object object = json.get((Object)col);
            if (StringUtils.isEmpty((Object)object)) continue;
            buf.append(object).append("-");
        }
        return buf.toString();
    }

    public static boolean repeatVerify(JSONObject json, String cols, String key, Map<Object, Set<String>> basemap) {
        if (!StringUtils.isEmpty((Object)cols)) {
            String s = ExcelComponent.getColValue(json, cols.split(","));
            Set<String> list = basemap.get(key);
            if (StringUtils.isEmpty(list)) {
                list = new HashSet<String>();
            }
            if (!list.add(s)) {
                return false;
            }
            basemap.put(key, list);
        }
        return true;
    }

    public JSONObject genrateRtnJSON(long ent_id, ModuleImpConfigHeadBean config, List<Map<String, Object>> list, List<ImpErrMsgBean> errlist, int total) throws Exception {
        JSONObject json = new JSONObject();
        if ("Y".equals(config.getEsubmit())) {
            this.batchInsSrv.batchInsert(this.getStorageOperations(FMybatisTemplate.class), list, config.getTemptable(), 1000);
            String tips = "excel\u5bfc\u5165\u603b\u6761\u6570" + total + ",\u6210\u529f\u6761\u6570" + list.size();
            if (!StringUtils.isEmpty(errlist) && errlist.size() > 0) {
                long errseqno = this.globrulesrv.getnext(ent_id, "imperrseqno", "", "");
                errlist.forEach(err -> err.setSeqno(errseqno));
                this.excelImpErrSrv.batchInsertImpErr(errlist);
                json.put("seqno", (Object)errseqno);
                tips = tips + ",\u5931\u8d25\u6761\u6570" + errlist.size();
            }
            json.put("msg", (Object)tips);
        } else {
            String tips = "";
            if (!StringUtils.isEmpty(errlist) && errlist.size() > 0) {
                tips = "\u5b58\u5728\u9519\u8bef\u884c\u6821\u9a8c\uff0c\u5bfc\u5165\u7ec8\u6b62\u3002";
                if (errlist.size() > this.maxErrRow) {
                    tips = tips + "\u9519\u8bef\u884c\u6570\u8fbe\u5230\u6821\u9a8c\u51fa\u9519\u6700\u5927\u884c\u6570" + this.maxErrRow;
                }
                String msg = errlist.stream().map(p -> p.getErrmsg()).collect(Collectors.joining(","));
                json.put("errmsg", (Object)msg);
            } else {
                this.batchInsSrv.batchInsert(this.getStorageOperations(FMybatisTemplate.class), list, config.getTemptable(), 1000);
                tips = "excel\u5bfc\u5165\u6210\u529f\u603b\u6761\u6570" + total;
            }
            json.put("msg", (Object)tips);
        }
        return json;
    }

    public void handleErrMsg(ServiceSession session, ModuleImpConfigHeadBean config, String errcode, String errmsg, List<ImpErrMsgBean> errlist) {
        ImpErrMsgBean err = new ImpErrMsgBean();
        err.setPh_key(UniqueID.getUniqueID());
        err.setPh_timestamp(new Date());
        err.setEnt_id(session.getEnt_id());
        err.setOperuser(session.getUser_code());
        err.setEid(config.getEid());
        err.setModuleid(config.getModuleid());
        err.setErrcode(errcode);
        err.setErrmsg(errmsg);
        if ("Y".equals(config.getEsubmit())) {
            errlist.add(err);
        } else {
            if (!StringUtils.isEmpty(errlist) && errlist.size() > this.maxErrRow) {
                return;
            }
            errlist.add(err);
        }
    }

    public String export(SXSSFWorkbook sxssfWorkbook, ServiceSession session, JSONObject jsonparam) throws Exception {
        int i;
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.checkPara(session, jsonparam);
        this.getParamWithCheck(jsonparam, "moduleCode", true, "");
        this.getParamWithCheck(jsonparam, "queryid", true, "");
        List<UiClass> exportcolconfig = this.getExportConfig(session, jsonparam);
        CellStyle headStyle = this.headStyle(sxssfWorkbook);
        List<CellStyle> detStyles = this.detailStyles(sxssfWorkbook, exportcolconfig);
        HashMap<String, Object> mapparam = new HashMap<String, Object>();
        mapparam.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            mapparam.put(key, jsonparam.get((Object)key));
        }
        String queryid = jsonparam.getString("queryid");
        ReportServiceImpl reportSrv = (ReportServiceImpl)SpringBeanFactory.getContext().getBean(ReportServiceImpl.class);
        long count = reportSrv.count(queryid, mapparam);
        int sheets = (int)Math.ceil((double)count / (double)this.maxWriteRowsSheet);
        ExecutorService sheetsThreadPool = Executors.newFixedThreadPool(1);
        for (int pageNo = 1; pageNo <= sheets && pageNo * this.maxWriteRowsSheet <= this.maxWriteRows; ++pageNo) {
            int startRows = (pageNo - 1) * this.maxWriteRowsSheet + 1;
            int endRows = pageNo * this.maxWriteRowsSheet;
            if ((long)endRows > count) {
                endRows = (int)count;
            }
            Sheet sheet = sxssfWorkbook.createSheet("Sheet" + pageNo + "(" + startRows + "-" + endRows + "\u6761)");
            sheetsThreadPool.execute(new CreateSheetThread(sheet, exportcolconfig, headStyle, detStyles, queryid, mapparam, pageNo));
        }
        sheetsThreadPool.shutdown();
        try {
            boolean isStop = sheetsThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            System.out.println("is pool finished: " + isStop);
            System.out.println("\u5171\u8017\u65f6:" + (double)(System.currentTimeMillis() - startTime) / 1000.0 + "s");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object[] sheetnames = new String[sxssfWorkbook.getNumberOfSheets()];
        for (i = 0; i < sxssfWorkbook.getNumberOfSheets(); ++i) {
            sheetnames[i] = sxssfWorkbook.getSheetName(i);
        }
        Arrays.sort(sheetnames);
        for (i = 0; i < sheetnames.length; ++i) {
            sxssfWorkbook.setSheetOrder((String)sheetnames[i], i);
        }
        String filename = jsonparam.get((Object)"moduleCode") + "_" + sdf.format(new Date()) + "(\u5408\u8ba1" + count + "\u6761).xlsx";
        return filename;
    }

    public CellStyle headStyle(SXSSFWorkbook sxssfWorkbook) {
        CellStyle headStyle = sxssfWorkbook.createCellStyle();
        headStyle.setBorderTop((short)1);
        headStyle.setBorderBottom((short)1);
        headStyle.setBorderLeft((short)1);
        headStyle.setBorderRight((short)1);
        headStyle.setAlignment((short)2);
        headStyle.setVerticalAlignment((short)1);
        headStyle.setDataFormat(sxssfWorkbook.createDataFormat().getFormat("@"));
        headStyle.setWrapText(true);
        Font f = sxssfWorkbook.createFont();
        f.setFontHeightInPoints((short)9);
        f.setBoldweight((short)700);
        headStyle.setFont(f);
        return headStyle;
    }

    public List<CellStyle> detailStyles(SXSSFWorkbook sxssfWorkbook, List<UiClass> exportconfigs) {
        ArrayList<CellStyle> detailStyles = new ArrayList<CellStyle>();
        for (int cellnum = 0; cellnum < exportconfigs.size(); ++cellnum) {
            CellStyle cellstyle = sxssfWorkbook.createCellStyle();
            this.cellStyle(sxssfWorkbook, cellstyle, exportconfigs.get(cellnum).getPropertys());
            detailStyles.add(cellstyle);
        }
        return detailStyles;
    }

    public void cellStyle(SXSSFWorkbook sxssfWorkbook, CellStyle cellStyle, List<UiProperty> properties) {
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setDataFormat(sxssfWorkbook.createDataFormat().getFormat("@"));
        if (properties.stream().anyMatch(o -> "contentAlign".equals(o.getPropertyName()))) {
            UiProperty uiProperty = (UiProperty)properties.stream().filter(o -> "contentAlign".equals(o.getPropertyName())).collect(Collectors.toList()).get(0);
            if ("center".equals(uiProperty.getPropertyValue())) {
                cellStyle.setAlignment((short)2);
            } else if ("left".equals(uiProperty.getPropertyValue())) {
                cellStyle.setAlignment((short)1);
            } else if ("right".equals(uiProperty.getPropertyValue())) {
                cellStyle.setAlignment((short)3);
            } else {
                cellStyle.setAlignment((short)1);
            }
        } else {
            cellStyle.setAlignment((short)1);
        }
        cellStyle.setWrapText(true);
    }

    public List<UiClass> getExportConfig(ServiceSession session, JSONObject jsonparam) {
        JSONObject rtnjson = null;
        try {
            ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest(session, "efuture.uiconfig.getUiConfig", jsonparam.toJSONString());
            if (!"0".equalsIgnoreCase(resp.getReturncode())) {
                throw new ServiceException(resp.getReturncode(), resp.getData().toString(), new Object[0]);
            }
            rtnjson = (JSONObject)resp.getData();
        }
        catch (Exception e) {
            throw new ServiceException("50000", "\u83b7\u53d6\u6a21\u5757\u5bfc\u51fa\u914d\u7f6e\u9519\u8bef:[{0}]-[{1}]", jsonparam.get((Object)"moduleCode"), e.getMessage());
        }
        List uiclass = JSON.parseArray((String)rtnjson.getString("uiclass"), UiClass.class);
        List uiproperty = JSON.parseArray((String)rtnjson.getString("uiproperty"), UiProperty.class);
        List uidetailconfig = uiclass.stream().filter(o -> o.getItemCode().equals("gridConfig") && o.getItemClass() == 2).peek(o -> o.setChildrens(this.uiClassSrv.getChildCategoryList((UiClass)o, uiclass))).sorted(Comparator.comparingInt(UiClass::getSort)).collect(Collectors.toList());
        List<UiClass> details = ((UiClass)uidetailconfig.get(0)).getChildrens().get(0).getChildrens();
        ArrayList<UiClass> exportcolconfig = new ArrayList<UiClass>();
        for (UiClass ui : details) {
            ui.setPropertys(uiproperty.stream().filter(o -> o.getItemId().equals(ui.getItemId())).collect(Collectors.toList()));
            if (ui.getPropertys().stream().anyMatch(o -> "isExport".equals(o.getPropertyName()) && "N".equals(o.getPropertyValue()))) continue;
            if (ui.getPropertys().stream().anyMatch(o -> "textName".equals(o.getPropertyName()))) {
                UiProperty uiProperty = (UiProperty)ui.getPropertys().stream().filter(o -> "textName".equals(o.getPropertyName())).collect(Collectors.toList()).get(0);
                ui.setItemCode(uiProperty.getPropertyValue());
            }
            exportcolconfig.add(ui);
        }
        return exportcolconfig;
    }

    public void createSheet(Sheet sheet, List<UiClass> configs, CellStyle headStyle, List<CellStyle> detStyles, String queryid, Map<String, Object> mapparam, int pageNo) throws Exception {
        ReportServiceImpl reportSrv = (ReportServiceImpl)SpringBeanFactory.getContext().getBean(ReportServiceImpl.class);
        Page page = PageHelper.startPage((int)pageNo, (int)this.maxWriteRowsSheet, (boolean)false);
        List<Map<String, Object>> list = reportSrv.doQuery(queryid, mapparam, null, null);
        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            int cellnum;
            sheet.createFreezePane(0, 1);
            Row header = sheet.createRow(0);
            for (cellnum = 0; cellnum < configs.size(); ++cellnum) {
                Cell cell = header.createCell(cellnum);
                cell.setCellValue(configs.get(cellnum).getItemName());
                cell.setCellStyle(headStyle);
            }
            for (int rownum = 0; rownum < list.size(); ++rownum) {
                Row row = sheet.createRow(rownum + 1);
                Map<String, Object> map = list.get(rownum);
                for (int cellnum2 = 0; cellnum2 < configs.size(); ++cellnum2) {
                    Cell cell = row.createCell(cellnum2);
                    cell.setCellStyle(detStyles.get(cellnum2));
                    this.setCellsValue(cell, configs.get(cellnum2).getPropertys(), map.get(configs.get(cellnum2).getItemCode()));
                }
            }
            for (cellnum = 0; cellnum < configs.size(); ++cellnum) {
                sheet.autoSizeColumn((int)((short)cellnum));
            }
        }
    }

    public Sheet createSheetNew(Sheet sheet, List<UiClass> configs, CellStyle headStyle, List<CellStyle> detStyles, String queryid, Map<String, Object> mapparam, int pageNo) throws Exception {
        ReportServiceImpl reportSrv = (ReportServiceImpl)SpringBeanFactory.getContext().getBean(ReportServiceImpl.class);
        Page page = PageHelper.startPage((int)pageNo, (int)this.maxWriteRowsSheet, (boolean)false);
        List<Map<String, Object>> list = reportSrv.doQuery(queryid, mapparam, null, null);
        if (!StringUtils.isEmpty(list) && list.size() > 0) {
            int cellnum;
            sheet.createFreezePane(0, 1);
            Row header = sheet.createRow(0);
            for (cellnum = 0; cellnum < configs.size(); ++cellnum) {
                Cell cell = header.createCell(cellnum);
                cell.setCellValue(configs.get(cellnum).getItemName());
                cell.setCellStyle(headStyle);
            }
            for (int rownum = 0; rownum < list.size(); ++rownum) {
                Row row = sheet.createRow(rownum + 1);
                Map<String, Object> map = list.get(rownum);
                for (int cellnum2 = 0; cellnum2 < configs.size(); ++cellnum2) {
                    Cell cell = row.createCell(cellnum2);
                    cell.setCellStyle(detStyles.get(cellnum2));
                    this.setCellsValue(cell, configs.get(cellnum2).getPropertys(), map.get(configs.get(cellnum2).getItemCode()));
                }
            }
            for (cellnum = 0; cellnum < configs.size(); ++cellnum) {
                sheet.autoSizeColumn((int)((short)cellnum));
            }
        }
        return sheet;
    }

    public void setCellsValue(Cell cell, List<UiProperty> properties, Object object) {
        if (!StringUtils.isEmpty((Object)object)) {
            if (properties.stream().anyMatch(o -> "fieldType".equals(o.getPropertyName()))) {
                UiProperty uiProperty = (UiProperty)properties.stream().filter(o -> "fieldType".equals(o.getPropertyName())).collect(Collectors.toList()).get(0);
                if (uiProperty.getPropertyValue().contains("D")) {
                    SimpleDateFormat sdf = null;
                    List formats = properties.stream().filter(o -> "format".equals(o.getPropertyValue())).collect(Collectors.toList());
                    sdf = !StringUtils.isEmpty(formats) && formats.size() > 0 ? new SimpleDateFormat(((UiProperty)formats.get(0)).getPropertyValue()) : ("date".equals(((UiProperty)properties.stream().filter(o -> "vtype".equals(o.getPropertyName())).collect(Collectors.toList()).get(0)).getPropertyValue()) ? new SimpleDateFormat("yyyy-MM-dd") : ("datetime".equals(((UiProperty)properties.stream().filter(o -> "vtype".equals(o.getPropertyName())).collect(Collectors.toList()).get(0)).getPropertyValue()) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd")));
                    try {
                        Date date = sdf.parse(object.toString());
                        cell.setCellValue(sdf.format(date));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else if (uiProperty.getPropertyValue().contains("N")) {
                    List formats = properties.stream().filter(o -> "format".equals(o.getPropertyName())).collect(Collectors.toList());
                    if (!StringUtils.isEmpty(formats) && formats.size() > 0) {
                        cell.setCellValue(this.numberFormat(((UiProperty)formats.get(0)).getPropertyValue(), Double.parseDouble(object.toString())));
                    } else {
                        cell.setCellValue(object.toString());
                    }
                } else {
                    cell.setCellValue(object.toString());
                }
            } else {
                cell.setCellValue(object.toString());
            }
        }
    }

    public String numberFormat(String format, double object) {
        int length;
        String pattern = null;
        if (format.startsWith("n")) {
            length = Integer.parseInt(format.substring(1));
            pattern = "#";
            if (length > 0) {
                pattern = pattern + ".";
                for (int i = 0; i < length; ++i) {
                    pattern = pattern + "#";
                }
            }
        } else if (format.startsWith("c")) {
            length = Integer.parseInt(format.substring(1));
            pattern = "#,###";
            if (length > 0) {
                pattern = pattern + ".";
                for (int i = 0; i < length; ++i) {
                    pattern = pattern + "#";
                }
            }
        } else if (format.startsWith("p")) {
            length = Integer.parseInt(format.substring(1));
            pattern = "##";
            if (length > 0) {
                pattern = pattern + ".";
                for (int i = 0; i < length; ++i) {
                    pattern = pattern + "0";
                }
            }
            pattern = pattern + "%";
        }
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(object);
    }

    class CreateSheetThread
    extends Thread {
        private Sheet sheet;
        private List<UiClass> configs;
        private CellStyle headStyle;
        private List<CellStyle> detStyles;
        private String queryid;
        private Map<String, Object> mapparam;
        private int pageNo;

        public CreateSheetThread(Sheet sheet, List<UiClass> configs, CellStyle headStyle, List<CellStyle> detStyles, String queryid, Map<String, Object> mapparam, int pageNo) {
            this.sheet = sheet;
            this.configs = configs;
            this.headStyle = headStyle;
            this.detStyles = detStyles;
            this.queryid = queryid;
            this.mapparam = mapparam;
            this.pageNo = pageNo;
        }

        @Override
        public void run() {
            try {
                ExcelComponent.this.createSheet(this.sheet, this.configs, this.headStyle, this.detStyles, this.queryid, this.mapparam, this.pageNo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static interface ERRCODE {
        public static final String NotNull = "1";
        public static final String NotRepeat = "2";
        public static final String FormatError = "3";
    }
}

