/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.UniqueID;
import java.util.HashMap;

public abstract class AbstractDistributedLockHandle
implements DistributedLockHandle {
    private final ThreadLocal<HashMap<String, Long>> LocalTransId = new ThreadLocal();

    protected Long newTransId(String key) {
        if (this.LocalTransId == null || this.LocalTransId.get() == null || !this.LocalTransId.get().containsKey(key)) {
            return UniqueID.getUniqueID();
        }
        return this.LocalTransId.get().get(key);
    }

    protected long getThisTransId(String key) {
        HashMap<String, Long> trans = this.LocalTransId.get();
        if (trans == null) {
            return 0L;
        }
        return trans.get(key);
    }

    protected void setThisTransId(String key, long id) {
        HashMap<String, Long> trans = this.LocalTransId.get();
        if (trans == null) {
            trans = new HashMap();
            this.LocalTransId.set(trans);
        }
        trans.put(key, id);
    }

    @Override
    public boolean tryLock(String key, int lockExpire, int waitMillSeconds) {
        long id = this.newTransId(key);
        boolean ok = this.doNaiveCachePut(key, id, lockExpire, waitMillSeconds);
        if (!ok) {
            return false;
        }
        this.setThisTransId(key, id);
        return ok;
    }

    public abstract boolean doNaiveCachePut(String var1, long var2, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(String key, int lockExpire) {
        long id = this.getThisTransId(key);
        try {
            long value = this.doNaiveCacheGet(key);
            if (id == value && value != 0L) {
                this.doNaiveCacheDelete(key);
                boolean bl = true;
                return bl;
            }
            ServiceLogs.debuglog("DistributedLock", "\u89e3\u9501\u65f6key[" + key + "]\u7684\u7f13\u5b58ID\u4e0d\u5339\u914d,\u4e0d\u505a\u5904\u7406,[" + id + "]-[" + value + "]", 0L);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            ServiceLogs.errLog("DistributedLock", e, "\u89e3\u9501\u662f\u5931\u8d25,key[{0}]", key);
        }
        finally {
            this.clearThisTransId(key);
        }
        return false;
    }

    @Override
    public boolean unlock(String key) {
        return this.unlock(key, 60);
    }

    @Override
    public boolean forceUnlock(String key) {
        try {
            return this.doNaiveCacheDelete(key);
        }
        catch (Exception x) {
            ServiceLogs.errLog("DistributedLock", x, "\u5f3a\u5236\u89e3\u9501\u65f6\u5931\u8d25,key[{0}]", key);
            return false;
        }
    }

    protected void clearThisTransId(String key) {
        HashMap<String, Long> trans = this.LocalTransId.get();
        if (null != trans) {
            trans.remove(key);
            if (trans.isEmpty()) {
                this.LocalTransId.remove();
            }
        }
    }

    public abstract boolean doNaiveCacheDelete(String var1);

    public abstract long doNaiveCacheGet(String var1);
}

