/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServiceLogs {
    public static String logFormat = "JSON";
    static Logger logger = LoggerFactory.getLogger(ServiceLogs.class);

    public static void setCurLogKey(String logKey) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        sessionobj.setLogkey(logKey);
    }

    public static ServiceSession getSessionobj() {
        ServiceSession sessionobj = ServiceRestReflect.getLocale().get();
        if (sessionobj == null || StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
            String tname = Thread.currentThread().getName();
            String rootkey = String.valueOf(new Date().getTime());
            if (tname.startsWith("rootkey")) {
                rootkey = tname.substring(7);
            }
            sessionobj = new ServiceSession();
            sessionobj.setUser_name("ASYNC");
            sessionobj.setRootkey(rootkey);
            sessionobj.setLogkey(String.valueOf(new Date().getTime()));
            sessionobj.setParentkey(rootkey);
            ServiceRestReflect.getLocale().set(sessionobj);
        }
        return sessionobj;
    }

    public static void logResponse(String logmsg, String rtncode) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            sessionobj.setReturncode(rtncode);
            ServiceLogs.debuglog(sessionobj, "response", logmsg, sessionobj.getStarttime(), false);
        }
    }

    public static void logRequest(String logmsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            sessionobj.setStarttime(System.currentTimeMillis());
            ServiceLogs.debuglog(sessionobj, "request", logmsg, 0L, false);
        }
    }

    public static void logCallStart(String url, String method, String request) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            JSONObject logmsg = new JSONObject();
            logmsg.put("call_method", (Object)method);
            logmsg.put("call_url", (Object)url);
            logmsg.put("call_request", (Object)request);
            ServiceLogs.debuglog(sessionobj, "call_request", logmsg.toString(), 0L, false);
        }
    }

    public static void logCallError(String url, String method, String errcode, String errmsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            JSONObject logmsg = new JSONObject();
            logmsg.put("call_method", (Object)method);
            logmsg.put("call_url", (Object)url);
            logmsg.put("call_returncode", (Object)errcode);
            logmsg.put("call_response", (Object)errmsg);
            sessionobj.setReturncode(errcode);
            ServiceLogs.debuglog(sessionobj, "call_response", logmsg.toString(), starttime, true);
        }
    }

    public static void logCallSuccess(String url, String method, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            JSONObject logmsg = new JSONObject();
            logmsg.put("call_method", (Object)method);
            logmsg.put("call_url", (Object)url);
            logmsg.put("call_returncode", (Object)"0");
            ServiceLogs.debuglog(sessionobj, "call_response", logmsg.toString(), starttime, false);
        }
    }

    public static void logConsumeMqStart(String topic, String key, String othermsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        ServiceLogs.debuglog(sessionobj, "mqconsumer_start", logmsg.toString(), 0L, false);
    }

    public static void logConsumeMqError(String topic, String key, String errcode, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("mq_returncode", (Object)errcode);
        sessionobj.setReturncode(errcode);
        ServiceLogs.debuglog(sessionobj, "mqconsumer_error", logmsg.toString(), starttime, true);
    }

    public static void logConsumeMqSuccess(String topic, String key, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("mq_returncode", (Object)"0");
        ServiceLogs.debuglog(sessionobj, "mqconsumer_succ", logmsg.toString(), starttime, false);
    }

    public static void logSendMqStart(String topic, String key, String othermsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        ServiceLogs.debuglog(sessionobj, "mqsend_start", logmsg.toString(), 0L, false);
    }

    public static void logSendMqError(String topic, String key, String errcode, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("mq_returncode", (Object)errcode);
        sessionobj.setReturncode(errcode);
        ServiceLogs.debuglog(sessionobj, "mqsend_error", logmsg.toString(), starttime, true);
    }

    public static void logSendMqSuccess(String topic, String key, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("mq_returncode", (Object)"0");
        ServiceLogs.debuglog(sessionobj, "mqsend_succ", logmsg.toString(), starttime, false);
    }

    public static void logSendSMSStart(String topic, String key, String othermsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        ServiceLogs.debuglog(sessionobj, "sms_send", logmsg.toString(), 0L, false);
    }

    public static void logSendSMSError(String topic, String key, String errcode, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("sms_returncode", (Object)errcode);
        ServiceLogs.debuglog(sessionobj, "sms_send", logmsg.toString(), starttime, true);
    }

    public static void logSendSMSSuccess(String topic, String key, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("mq_returncode", (Object)"0");
        ServiceLogs.debuglog(sessionobj, "sms_send", logmsg.toString(), starttime, false);
    }

    public static void logFitlerSucc(String logmsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        ServiceLogs.debuglog(sessionobj, "filter_succ", logmsg.toString(), 0L, false);
    }

    public static void logFitlerFail(String logmsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        ServiceLogs.debuglog(sessionobj, "filter_fail", logmsg.toString(), 0L, false);
    }

    private static String getDefaultFormatstr(ServiceSession sessionobj, String logtype, Exception e, String logmsg, long starttime) {
        StringBuffer sb = new StringBuffer();
        sb.append("rootkey : ");
        sb.append(sessionobj.getRootkey().concat(" , "));
        sb.append("orderkey : ");
        sb.append(sessionobj.getCurOrderKey().concat(" , "));
        if (logtype.equalsIgnoreCase("request")) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append("REQUEST : ");
            sb.append(logmsg + " , ");
            sb.append("url : ");
            sb.append(sessionobj.getUrl());
        } else if (logtype.equalsIgnoreCase("response") || logtype.equalsIgnoreCase("response_out")) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append(logtype.toUpperCase() + " : ");
            sb.append("ELAPSED : " + (System.currentTimeMillis() - starttime) + " ms , ");
            sb.append(logmsg);
        } else {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append(logtype + " : ");
            if (starttime > 0L) {
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - starttime) + " ms , ");
            }
            sb.append(logmsg);
        }
        if (e != null) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                if (i == 0) {
                    sb.append("exception : [" + stackTrace[i]);
                    continue;
                }
                sb.append(stackTrace[i]);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private static String getJsonFormatstr(ServiceSession sessionobj, String logtype, Exception e, String logmsg, long starttime) {
        JSONObject rtn = (JSONObject)JSONObject.toJSON((Object)sessionobj);
        rtn.put("logtype", (Object)logtype);
        rtn.put("logmsg", (Object)logmsg);
        if (e != null) {
            rtn.put("exception", (Object)ServiceLogs.getStackTrace(e));
            if (null == logmsg) {
                rtn.put("logmsg", (Object)e.getMessage());
            } else {
                rtn.put("logmsg", (Object)(logmsg + " errMsg:" + e.getMessage()));
            }
        }
        if (starttime != 0L) {
            rtn.put("elapsed", (Object)(System.currentTimeMillis() - starttime));
        }
        return rtn.toString();
    }

    public static void debuglog(ServiceSession sessionobj, String logtype, String logmsg, long starttime, boolean iserr) {
        String msg = logmsg;
        msg = ServiceVersion.getInstance().getLogFormat().equalsIgnoreCase("json") ? ServiceLogs.getJsonFormatstr(sessionobj, logtype, null, logmsg, starttime) : ServiceLogs.getDefaultFormatstr(sessionobj, logtype, null, logmsg, starttime);
        if (iserr) {
            logger.error(msg);
        } else {
            logger.info(msg);
        }
    }

    public static void debuglog(String logtype, String logmsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        String msg = logmsg;
        msg = ServiceVersion.getInstance().getLogFormat().equalsIgnoreCase("json") ? ServiceLogs.getJsonFormatstr(sessionobj, logtype, null, logmsg, starttime) : ServiceLogs.getDefaultFormatstr(sessionobj, logtype, null, logmsg, starttime);
        logger.info(msg);
    }

    public static void debuglog(String logtype, String logmsg, long starttime, Object ... arguments) {
        String msg = ServiceLogs.formatMsg(logtype, null, logmsg, starttime, arguments);
        logger.info(msg);
    }

    private static String formatMsg(String logtype, Exception e, String logmsg, long starttime, Object ... arguments) {
        String fmsg;
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        String logFromat = "json";
        String msg = fmsg = ServiceLogs.format(logmsg, arguments);
        msg = logFromat.equalsIgnoreCase("json") ? ServiceLogs.getJsonFormatstr(sessionobj, logtype, e, fmsg, starttime) : ServiceLogs.getDefaultFormatstr(sessionobj, logtype, e, fmsg, starttime);
        return msg;
    }

    public static void errLog(String logtype, Exception e, String logmsg, Object ... arguments) {
        String msg = ServiceLogs.formatMsg(logtype, e, logmsg, 0L, arguments);
        logger.error(msg);
    }

    public static void truedebuglog(String logtype, String logmsg, long starttime, Object ... arguments) {
        String msg = ServiceLogs.formatMsg(logtype, null, logmsg, starttime, arguments);
        logger.debug(msg);
    }

    public static String format(String msg, Object ... args) {
        if (args == null || args.length <= 0) {
            return msg;
        }
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = StringUtils.isEmpty((Object)args[i]) ? "" : args[i].toString();
        }
        return MessageFormat.format(msg, args);
    }

    public static interface LOGTYPE {
        public static final String INFO = "info";
        public static final String RESPONSE = "response";
        public static final String RESPONSE_TIMEOUT = "response_out";
        public static final String REQUEST = "request";
        public static final String DBSTART = "db_start";
        public static final String DBSUCC = "db_succ";
        public static final String DBERROR = "db_error";
        public static final String CALL_REQUEST = "call_request";
        public static final String CALL_RESPONSE = "call_response";
        public static final String MQSEND_start = "mqsend_start";
        public static final String MQSEND_error = "mqsend_error";
        public static final String MQSEND_succ = "mqsend_succ";
        public static final String MQCONSUMER_start = "mqconsumer_start";
        public static final String MQCONSUMER_error = "mqconsumer_error";
        public static final String MQCONSUMER_succ = "mqconsumer_succ";
        public static final String SMSSEND = "sms_send";
        public static final String FILTER_SUCC = "filter_succ";
        public static final String FILTER_FAIL = "filter_fail";
    }
}

