/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class IniReader {
    protected HashMap<String, Map<String, String>> sections = new HashMap();
    private transient String currentSecion;
    private transient Map<String, String> current;
    private boolean ibinit = false;

    public IniReader() {
    }

    public IniReader(String filename) throws IOException {
        this.init(filename);
    }

    public void init(String filename) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
        BufferedReader reader = new BufferedReader(isr);
        this.read(reader);
        reader.close();
        this.ibinit = true;
    }

    protected void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
    }

    protected void parseLine(String line) {
        if ((line = line.trim()).matches("\\[\\w+\\]")) {
            this.currentSecion = line.replaceFirst("\\[(.*)\\]", "$1");
            this.current = new HashMap<String, String>();
            this.sections.put(this.currentSecion, this.current);
        } else if (line.matches(".*=.*") && this.current != null) {
            int i = line.indexOf(61);
            String name = line.substring(0, i);
            String value = line.substring(i + 1);
            this.current.put(name, value);
        }
    }

    public Map<String, String> getsection(String section) {
        Map<String, String> p = this.sections.get(section);
        if (p == null) {
            return null;
        }
        return p;
    }

    public String getValue(String section, String name) {
        Map<String, String> p = this.sections.get(section);
        if (p == null) {
            return null;
        }
        String value = p.get(name);
        return value;
    }

    public boolean isinit() {
        return this.ibinit;
    }
}

