/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.annotation;

import com.efuture.ocp.common.annotation.AutoAccesslimit;
import com.efuture.ocp.common.component.GlobalConfig;
import com.efuture.ocp.common.entity.AccessLimitBean;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.CacheUtils;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.RateLimiter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AutoAccesslimitAspect {
    private static Logger logger = LogManager.getLogger(AutoAccesslimitAspect.class);
    private Map<String, RateLimiter> limitMap = Maps.newConcurrentMap();

    private ServiceSession getSessionKey(ProceedingJoinPoint point, AutoAccesslimit around) {
        Object[] args;
        for (Object arg : args = point.getArgs()) {
            if (!(arg instanceof ServiceSession)) continue;
            return (ServiceSession)arg;
        }
        return new ServiceSession(0L);
    }

    private static String getHostIP() {
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface nif = netInterfaces.nextElement();
                Enumeration<InetAddress> iparray = nif.getInetAddresses();
                while (iparray.hasMoreElements()) {
                    String localip;
                    InetAddress ip = iparray.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || "127.0.0.1".equals(localip = ip.getHostAddress())) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoAccesslimit around) throws Throwable {
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        String service = around.Service();
        int mode = around.mode();
        int time = around.time();
        int maxLimit = around.maxLimit();
        ServiceSession session = this.getSessionKey(point, around);
        String cacheKey = String.format("%s-%s-%s", service, className, methodName);
        AccessLimitBean limit = GlobalConfig.getInstance().getAndSetAccessLimit(session.getEnt_id(), cacheKey, mode, time, maxLimit);
        if (limit != null) {
            mode = limit.getLimitMode();
            maxLimit = limit.getPermitsPerSecond();
            time = limit.getWarmUpPeriod();
            cacheKey = cacheKey.concat("-").concat(String.valueOf(session.getEnt_id())).concat("-").concat(String.valueOf(maxLimit));
        } else {
            cacheKey = cacheKey.concat("-").concat(String.valueOf(session.getEnt_id()));
        }
        if (maxLimit <= 0) {
            return point.proceed();
        }
        Object result = null;
        if (mode == 0) {
            Integer nowRequestNum;
            Integer requestNum;
            if (time <= 0) {
                time = 60;
            }
            if ((requestNum = (Integer)CacheUtils.getInMemUtils().getData(cacheKey)) == null) {
                requestNum = 0;
            }
            if ((nowRequestNum = Integer.valueOf(requestNum + 1)) >= maxLimit) {
                throw new ServiceException("10000", "\u670d\u52a1\u7e41\u5fd9\uff0c\u7a0d\u540e\u518d\u8bd5", new Object[0]);
            }
            CacheUtils.getInMemUtils().putData(cacheKey, nowRequestNum, time);
            try {
                result = point.proceed();
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                requestNum = (Integer)CacheUtils.getInMemUtils().getData(cacheKey);
                if (requestNum == null) {
                    CacheUtils.getInMemUtils().putData(cacheKey, 0, time);
                } else {
                    Integer newRequestNum = 0;
                    if (requestNum > 0) {
                        newRequestNum = requestNum - 1;
                    }
                    CacheUtils.getInMemUtils().putData(cacheKey, newRequestNum, time);
                }
            }
        } else if (mode == 1) {
            boolean acquire;
            RateLimiter limiter = null;
            if (!this.limitMap.containsKey(cacheKey)) {
                limiter = time > 0 ? RateLimiter.create((double)maxLimit, (long)time, (TimeUnit)around.timeunit()) : RateLimiter.create((double)maxLimit);
                this.limitMap.put(cacheKey, limiter);
            }
            if (!(acquire = (limiter = this.limitMap.get(cacheKey)).tryAcquire(1, 10L, TimeUnit.MICROSECONDS))) {
                throw new ServiceException("10000", "\u670d\u52a1\u7e41\u5fd9\uff0c\u7a0d\u540e\u518d\u8bd5", new Object[0]);
            }
            result = point.proceed();
        }
        return result;
    }
}

