/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.annotation;

import com.efuture.ocp.common.annotation.AutoCacheEvict;
import com.efuture.ocp.common.annotation.AutoCacheKeyHandle;
import com.efuture.ocp.common.util.CacheUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AutoCacheEvictAspect {
    private static final Logger logger = Logger.getLogger(AutoCacheEvictAspect.class);
    @Autowired
    AutoCacheKeyHandle keyHandle;

    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoCacheEvict around) throws Throwable {
        String cacheKey = this.keyHandle.getCacheKey(point, around);
        int result = CacheUtils.getCacheUtils(around.CacheLevel()).deleteBatch(cacheKey);
        Object object = point.proceed();
        return object;
    }
}

