/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.cache.CacheConfig;
import com.efuture.ocp.common.cache.CacheUtilsInMemory;
import com.efuture.ocp.common.cache.CacheUtilsInMemoryObject;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.rubyeye.xmemcached.GetsResponse;

public abstract class CacheUtils {
    protected CacheConfig config;

    public CacheConfig getConfig() {
        return this.config;
    }

    public void setConfig(CacheConfig config) {
        this.config = config;
    }

    public abstract String putData(String var1, Object var2, int var3);

    public abstract Object getData(String var1);

    public abstract Object getCacheData(String var1);

    public abstract boolean deleteData(String var1);

    public abstract long getCasValue(String var1);

    public abstract GetsResponse getCasData(String var1);

    public abstract boolean putbyCas(String var1, Object var2, int var3, long var4);

    public String putData(Object object) {
        return this.putData(object, 86400);
    }

    public String putData(Object object, int timeout) {
        String key = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        return CacheUtils.getCacheUtils().putData(key, object, timeout);
    }

    public String putDataPrefix(String prefix, Object object, int timeout) {
        String key = prefix.concat(UUID.randomUUID().toString().replace("-", "").toUpperCase());
        return CacheUtils.getCacheUtils().putData(key, object, timeout);
    }

    public Map<String, Object> getBatchData(List<String> keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            result.put(key, this.getData(key));
        }
        return result;
    }

    public static CacheUtils getCacheUtils() {
        return SpringBeanFactory.getBean("CacheUtils", CacheUtils.class);
    }

    public static CacheUtils getInMemUtils() {
        return SpringBeanFactory.getBean("CacheInMemory", CacheUtils.class);
    }

    public static CacheUtils getInMemUtils(String cacheMemoryMode) {
        if ("BIN".equalsIgnoreCase(cacheMemoryMode)) {
            return (CacheUtils)SpringBeanFactory.getContext().getBean(CacheUtilsInMemory.class);
        }
        return (CacheUtils)SpringBeanFactory.getContext().getBean(CacheUtilsInMemoryObject.class);
    }

    public static CacheUtilsRediscached getRedisUtils() {
        return SpringBeanFactory.getBean("CacheRedis", CacheUtilsRediscached.class);
    }

    public static CacheUtils getCacheUtils(String cacheLevel) {
        if ("MEM".equalsIgnoreCase(cacheLevel)) {
            return CacheUtils.getInMemUtils();
        }
        return CacheUtils.getCacheUtils();
    }

    public boolean AddData(String key, Object object, int timeout) {
        return false;
    }

    public int deleteBatch(String key) {
        return 0;
    }

    public String putDataText(String key, Object object, int timeout) {
        return this.putData(key, object, timeout);
    }

    public Object getDataText(String key) {
        return this.getData(key);
    }

    public static interface CacheLevel {
        public static final String Cache = "CACHE";
        public static final String Memory = "MEM";
    }

    public static interface CacheMemoryMode {
        public static final String BIN = "BIN";
        public static final String OBJ = "OBJ";
    }

    public static interface CacheType {
        public static final String INMEMORY = "memory";
        public static final String MEMCACHED = "memcached";
        public static final String REDIS_SINGLE = "redis";
        public static final String REDIS_SENTINEL = "redis_sentinel";
        public static final String REDIS_CLUSTER = "redis_cluster";
    }

    public static interface CacheTimeOut {
        public static final int Min = 60;
        public static final int HalfHour = 1800;
        public static final int Hour = 3600;
        public static final int Day = 86400;
    }
}

