/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.AccessLimitBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="globalconfig")
public class GlobalConfig
extends BasicComponent {
    private final String GlobalSOP = "GlobalStorageOperation";

    public static GlobalConfig getInstance() {
        return (GlobalConfig)SpringBeanFactory.getContext().getBean(GlobalConfig.class);
    }

    @Override
    public FStorageOperations getStorageOperations() {
        if (SpringBeanFactory.containsBean("GlobalStorageOperation")) {
            return SpringBeanFactory.getBean("GlobalStorageOperation", FStorageOperations.class);
        }
        return super.getStorageOperations();
    }

    @AutoCache(Service="OCP", KeyArgIndex=1, CacheLevel="MEM", TimeOut=21600)
    public AccessLimitBean getAndSetAccessLimit(long ent_id, String limitkey, int mode, int time, int maxLimit) throws Exception {
        try {
            FStorageOperations storage = this.getStorageOperations();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"ent_id").is((Object)ent_id).and("limitkey").is((Object)limitkey));
            AccessLimitBean limitBean = (AccessLimitBean)storage.selectOne(query, AccessLimitBean.class);
            if (limitBean == null) {
                limitBean = new AccessLimitBean();
                limitBean.setEnt_id(ent_id);
                limitBean.setLimitKey(limitkey);
                limitBean.setLimitMode(mode);
                limitBean.setPermitsPerSecond(maxLimit);
                limitBean.setWarmUpPeriod(time);
                limitBean.setTcrd(System.currentTimeMillis() / 1000L);
                limitBean.setTmdd(System.currentTimeMillis() / 1000L);
                storage.insert((Object)limitBean);
            }
            return limitBean;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ServiceResponse flush(ServiceSession session, JSONObject jsonparam) throws Exception {
        String key = DataUtils.getJsonData(jsonparam, "key", false, "OCP:GlobalConfig");
        return ServiceResponse.buildSuccess(CacheUtils.getInMemUtils().deleteBatch(key));
    }
}

