/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.datasync;

import com.efuture.ocp.common.datasync.DataSyncService;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.util.SpringBeanFactory;
import org.apache.log4j.Logger;

public class DataSyncUtils {
    protected static Logger logger = null;

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger((String)DataSyncUtils.class.getName());
        }
        return logger;
    }

    private static DataSyncService getSyncObj() {
        if (SpringBeanFactory.containsBean("efuture.com.datasync")) {
            return SpringBeanFactory.getBean("efuture.com.datasync", DataSyncService.class);
        }
        return null;
    }

    public static void sync(AbstractEntityBean bean) {
        DataSyncService datasync = DataSyncUtils.getSyncObj();
        if (datasync == null) {
            return;
        }
        try {
            datasync.sync(bean);
        }
        catch (IllegalArgumentException e) {
            DataSyncUtils.getLogger().error((Object)("datasync:" + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            DataSyncUtils.getLogger().error((Object)("datasync:" + e.getMessage()));
        }
    }

    public static void sync(AbstractEntityBean bean, String cmdid) {
        DataSyncService datasync = DataSyncUtils.getSyncObj();
        if (datasync == null) {
            return;
        }
        try {
            datasync.sync(bean, cmdid);
        }
        catch (IllegalArgumentException e) {
            DataSyncUtils.getLogger().error((Object)("datasync:" + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            DataSyncUtils.getLogger().error((Object)("datasync:" + e.getMessage()));
        }
    }

    public static void sync(String keyvalue, String cmdid) {
        DataSyncService datasync = DataSyncUtils.getSyncObj();
        if (datasync == null) {
            return;
        }
        datasync.sync(keyvalue, cmdid);
    }
}

