/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.FileServiceImpl;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.component.excel.ExcelComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageUtils;
import com.efuture.ocp.common.proxy.EnterpriseProxy;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.rest.taobao.CheckResult;
import com.efuture.ocp.common.rest.taobao.SpiUtils;
import com.efuture.ocp.common.rest.taobao.TaobaoResponse;
import com.efuture.ocp.common.rest.taobao.TaobaoSession;
import com.efuture.ocp.common.rest.userinterface.InitSession;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.SignUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.UrlEncoderUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.user.UserTokenInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.util.StringUtils;

@Path(value="/")
public class ServiceRestReflect {
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    private static ServiceMethodReflect rcm = new ServiceMethodReflect();
    private static final ThreadLocal<ServiceSession> locale = new ThreadLocal();

    public static ThreadLocal<ServiceSession> getLocale() {
        if (locale == null || locale.get() == null) {
            locale.set(new ServiceSession());
        }
        return locale;
    }

    public static void pushlocale(ServiceSession session) {
        locale.set(session);
    }

    public static void removeLocale(ServiceSession session) {
        if (session != null && !StringUtils.isEmpty((Object)session.getMethod()) && session.getStarttime() > 0L) {
            ServiceVersion.getInstance().writeElapsed(session.getMethod(), System.currentTimeMillis() - session.getStarttime());
        }
        locale.remove();
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/")
    public String test(@QueryParam(value="status") String status) {
        String uri = this.request.getRequestURI();
        if (uri.startsWith("/") || uri.startsWith("\\")) {
            uri = uri.substring(1);
        }
        if (uri.endsWith("/") || uri.endsWith("\\")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ("check".equalsIgnoreCase(status)) {
            return uri + " success";
        }
        if ("info".equalsIgnoreCase(status)) {
            JSONObject json = new JSONObject();
            RuntimeMXBean run = ManagementFactory.getRuntimeMXBean();
            json.put("pid", (Object)run.getName().split("@")[0]);
            json.put("server", (Object)run.getName().split("@")[1]);
            json.put("startTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(run.getStartTime()));
            return json.toJSONString();
        }
        if ("statis".equalsIgnoreCase(status)) {
            try {
                return ServiceVersion.getInstance().printElapsed();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("clear".equalsIgnoreCase(status)) {
            try {
                ServiceVersion.getInstance().cleanElapsed();
                return "ok";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        ServiceVersion sv = ServiceVersion.getInstance();
        if ("openlog".equalsIgnoreCase(status)) {
            sv.setLogstatus(true);
        }
        if ("closelog".equalsIgnoreCase(status)) {
            sv.setLogstatus(false);
        }
        return uri + " version " + sv.getVer() + " (LogStatus: " + (sv.isLogstatus() ? "Y" : "N") + ")\n";
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/env")
    public String env(@QueryParam(value="key") String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return "require key";
        }
        String[] keys = key.split(",");
        JSONObject json = EnviromentUtil.followEnvironment(null, keys);
        if (json != null) {
            return json.toJSONString();
        }
        return "";
    }

    private Map<String, String> getParameter() {
        HashMap<String, String> rtn = new HashMap<String, String>();
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] values = this.request.getParameterValues(key);
            if (values == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            rtn.put(key, value);
        }
        return rtn;
    }

    private void setSessionbycongou(ServiceSession session, String key, String value) {
        this.setSession(session, key, value);
        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
            UserDataRangeSrv.setlocaltoken(value);
            UserTokenInfo info = UserDataRangeSrv.getlocaluser();
            if (info != null) {
                session.setEnt_id(Long.parseLong(info.getEntid()));
                session.setUser_id(Long.parseLong(info.getUserid()));
                session.setUser_code(info.getUseraccount());
                session.setUser_name(info.getUsername());
                session.setDeptcode(info.getDeptid());
                session.setDeptrealcode(info.getDeptcode());
                session.setRoleid(info.getOrgid());
                session.setRolecode(info.getOrgcode());
                session.setPostid(info.getPostid());
            }
        }
    }

    private void setSession(ServiceSession session, String key, String value) {
        if ("ent_id".equalsIgnoreCase(key) && session.getEnt_id() == 0L) {
            session.setEnt_id(Long.parseLong(value));
        }
        if ("user_id".equalsIgnoreCase(key)) {
            session.setUser_id(Long.parseLong(value));
        }
        if ("user_code".equalsIgnoreCase(key)) {
            session.setUser_code(value);
        }
        if ("user_name".equalsIgnoreCase(key)) {
            session.setUser_name(value);
        }
        if ("debug_status".equalsIgnoreCase(key)) {
            session.setDebug_status(value);
        }
        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
        }
        if ("postid".equalsIgnoreCase(key)) {
            session.setPostid(value);
        }
        if ("parentkey".equalsIgnoreCase(key)) {
            session.setParentkey(value);
        }
        if ("rootkey".equalsIgnoreCase(key)) {
            session.setRootkey(value);
        }
        if ("market".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("shop_code".equalsIgnoreCase(key) || "shopCode".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("slice".equalsIgnoreCase(key)) {
            session.setSlice(value);
        }
        if ("dataRangeId".equalsIgnoreCase(key)) {
            session.setDataRangeId(value);
        }
        if ("stationId".equalsIgnoreCase(key)) {
            session.setPostid(value);
        }
        if ("roleId".equalsIgnoreCase(key)) {
            session.setRoleid(value);
        }
        if ("locale".equalsIgnoreCase(key)) {
            session.setLocale(value);
            MessageUtils.setSimpleLocale(value);
        }
        if ("orderkey".equalsIgnoreCase(key)) {
            session.setOrderkey(Integer.valueOf(value));
        }
    }

    private String addQueryParamToJsonParam(ServiceSession session, String param, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey", "shopCode", "shop_code", "dataRangeId", "stationId", "roleId", "accessid"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey = DataUtils.nvl(rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (map != null && map.size() > 0) {
            JSONObject jsonparam = null;
            if (StringUtils.isEmpty((Object)param)) {
                jsonparam = new JSONObject();
            } else {
                try {
                    jsonparam = JSON.parseObject((String)param);
                }
                catch (Exception ex) {
                    return param;
                }
            }
            for (String key : map.keySet()) {
                if (jsonparam.containsKey((Object)key)) continue;
                jsonparam.put(key, map.get(key));
            }
            param = jsonparam.toJSONString();
        }
        if (!StringUtils.isEmpty((Object)session.getToken()) && StringUtils.isEmpty((Object)session.getDataRangeId())) {
            String key = "session:" + session.getToken();
            try {
                JSONObject json = JSONObject.parseObject((String)((String)CacheUtils.getCacheUtils().getCacheData(key)));
                if (!StringUtils.isEmpty((Object)json) && !StringUtils.isEmpty((Object)json.get((Object)"dataRangeId"))) {
                    session.setDataRangeId(json.get((Object)"dataRangeId").toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }
        if (session != null) {
            session.setHttp_uri(this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort());
        }
        return param;
    }

    private String addQueryParamToJsonParamByCall(ServiceSession session, String param, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object ss = null;
        Map<String, String> rp = this.getParameter();
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (map != null && map.size() > 0) {
            JSONObject jsonparam = null;
            if (StringUtils.isEmpty((Object)param)) {
                jsonparam = new JSONObject();
            } else {
                try {
                    jsonparam = JSON.parseObject((String)param);
                }
                catch (Exception ex) {
                    return param;
                }
            }
            for (String key : map.keySet()) {
                if (jsonparam.containsKey((Object)key)) continue;
                jsonparam.put(key, map.get(key));
            }
            param = jsonparam.toJSONString();
        }
        if (session != null) {
            session.setHttp_uri(this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort());
        }
        return param;
    }

    private boolean isEffective(String remoteAddr) {
        return null != remoteAddr && !"".equals(remoteAddr.trim()) && !"unknown".equalsIgnoreCase(remoteAddr.trim());
    }

    private String getRemoteAddr() {
        try {
            String remoteAddr = this.request.getHeader("X-Forwarded-For");
            if (this.isEffective(remoteAddr) && remoteAddr.indexOf(",") > -1) {
                String[] array;
                for (String element : array = remoteAddr.split(",")) {
                    if (!this.isEffective(element)) continue;
                    remoteAddr = element;
                    break;
                }
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getHeader("X-Real-IP");
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getRemoteAddr();
            }
            if (remoteAddr != null && remoteAddr.indexOf(".") > 0) {
                return remoteAddr;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/qimen")
    public String callQimenService(@QueryParam(value="cmd") String method, String body) throws Exception {
        String result = "";
        String rtncode = "0";
        String remoteaddr = "";
        String url = "";
        long logkey = 0L;
        long startTime = System.currentTimeMillis();
        String queryMsg = String.format("Qimen_REQ:%s :%s :%s", method, body, this.request.getQueryString());
        ServiceLogs.debuglog("request", queryMsg, startTime);
        if (ServiceVersion.getInstance().isLogstatus()) {
            remoteaddr = this.getRemoteAddr();
            logkey = UniqueID.getUniqueID();
            url = this.request.getQueryString();
        }
        TaobaoSession session = new TaobaoSession();
        this.addQueryParamToJsonParam(session, body);
        ServiceSession sessionobj = new ServiceSession();
        sessionobj.setEnt_id(session.getEnt_id());
        sessionobj.setStarttime(startTime);
        sessionobj.setRemoteaddr(remoteaddr);
        sessionobj.setLogkey(String.valueOf(logkey));
        sessionobj.setMethod(method);
        if (!StringUtils.isEmpty((Object)session.getRequest_id())) {
            sessionobj.setParentkey(session.getRequest_id());
            sessionobj.setRootkey(session.getRequest_id());
        }
        if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
            sessionobj.setRootkey(String.valueOf(logkey));
        }
        sessionobj.setUrl(url);
        ServiceRestReflect.pushlocale(sessionobj);
        JSONObject sat_res = this.checkSign(session, body);
        if (sat_res.containsKey((Object)"success") && "false".equalsIgnoreCase(sat_res.getString("success"))) {
            ServiceLogs.debuglog("response", "RESP:" + sat_res.toJSONString(), startTime);
            return sat_res.toJSONString();
        }
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logRequest(body);
        }
        try {
            TaobaoResponse response;
            Object retdata = rcm.executeClassMethodByTaobao(method, session, body);
            if (retdata instanceof TaobaoResponse && !(response = (TaobaoResponse)retdata).isSuccess()) {
                rtncode = response.getErr_code();
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            String string = result;
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)TaobaoResponse.buildFailure(ex.getErrorCode(), ex.getMessage()));
            rtncode = ex.getErrorCode();
            String string = result;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)TaobaoResponse.buildFailure("50000", Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            String string = result;
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String string;
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        long logkey = 0L;
        String url = "";
        ServiceSession sessionobj = null;
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            sessionobj.setStarttime(start_time);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            ServiceRestReflect.pushlocale(sessionobj);
            if (ServiceVersion.getInstance().isLogstatus()) {
                ServiceLogs.logRequest(postparam);
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
                rtncode = response.getReturncode();
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            string = result;
        }
        catch (ServiceException ex) {
            String string2;
            block22: {
                ex.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(sessionobj, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
                rtncode = ex.getErrorCode();
                string2 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block22;
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string2;
        }
        catch (Exception ex2) {
            String string3;
            block23: {
                ex2.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(sessionobj, "50000", Utils.getLastExceptionMessage(ex2)));
                rtncode = "555";
                string3 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block23;
                {
                    catch (Throwable throwable) {
                        if (ServiceVersion.getInstance().isLogstatus()) {
                            ServiceLogs.logResponse(result, rtncode);
                        }
                        UserDataRangeSrv.setlocaltoken("");
                        ServiceRestReflect.removeLocale(sessionobj);
                        throw throwable;
                    }
                }
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string3;
        }
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logResponse(result, rtncode);
        }
        UserDataRangeSrv.setlocaltoken("");
        ServiceRestReflect.removeLocale(sessionobj);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/restomni")
    public String callRestService_omni(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            sessionobj.setEnt_id(0L);
            sessionobj.setToken("");
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;
            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            } else {
                if (retdata == null) {
                    retdata = "";
                }
                response = ServiceResponse.buildSuccess(retdata);
            }
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(response));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/call")
    public String callServiceByGet(@QueryParam(value="service") String service, @QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param) {
        return this.callServiceByPOST(service, method, session, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/call")
    public String callServiceByPOST(@QueryParam(value="service") String service, @QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String string;
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        long logkey = 0L;
        String url = "";
        ServiceSession sessionobj = null;
        long start_time = System.currentTimeMillis();
        try {
            JSONObject jsonparam;
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            if (StringUtils.isEmpty((Object)postparam)) {
                jsonparam = new JSONObject();
                jsonparam.put("service", (Object)service);
            } else {
                jsonparam = JSON.parseObject((String)postparam);
            }
            jsonparam.put("service", (Object)service);
            postparam = this.addQueryParamToJsonParamByCall(sessionobj, jsonparam.toJSONString(), "method", "session", "param");
            sessionobj.setStarttime(start_time);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            if (url.indexOf("service") > -1) {
                Map<String, Object> queryParam = SignUtils.urlToMap(url, "UTF-8");
                queryParam.remove("service");
                url = ServiceRestReflect.getURLParamStrFromMap(queryParam);
            }
            sessionobj.setUrl(url);
            ServiceRestReflect.pushlocale(sessionobj);
            if (ServiceVersion.getInstance().isLogstatus()) {
                ServiceLogs.logRequest(postparam);
            }
            Object retdata = rcm.executeClassMethod("efuture.service.proxy.call", sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
                rtncode = response.getReturncode();
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            string = result;
        }
        catch (ServiceException ex) {
            String string2;
            block25: {
                ex.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(sessionobj, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
                rtncode = ex.getErrorCode();
                string2 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block25;
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string2;
        }
        catch (Exception ex2) {
            String string3;
            block26: {
                ex2.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(sessionobj, "50000", Utils.getLastExceptionMessage(ex2)));
                rtncode = "555";
                string3 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block26;
                {
                    catch (Throwable throwable) {
                        if (ServiceVersion.getInstance().isLogstatus()) {
                            ServiceLogs.logResponse(result, rtncode);
                        }
                        UserDataRangeSrv.setlocaltoken("");
                        ServiceRestReflect.removeLocale(sessionobj);
                        throw throwable;
                    }
                }
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string3;
        }
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logResponse(result, rtncode);
        }
        UserDataRangeSrv.setlocaltoken("");
        ServiceRestReflect.removeLocale(sessionobj);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/ptrest")
    public String callRestService_pt(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;
            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            } else {
                if (retdata == null) {
                    retdata = "";
                }
                response = ServiceResponse.buildSuccess(retdata);
            }
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(response));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure_ex(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure_ex(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param) {
        return this.callRestService(method, session, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callImportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form) {
        String string;
        ArrayList<FileImportObject> list = new ArrayList<FileImportObject>();
        try {
            Object parts;
            ServiceVersion.getInstance().debugLog("start import.");
            Map mapFormData = form.getFields();
            Set sets = mapFormData.keySet();
            for (String key : sets) {
                parts = (List)mapFormData.get(key);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key + ":" + filename);
                    if (StringUtils.isEmpty((Object)filename)) continue;
                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream((InputStream)part.getValueAs(InputStream.class));
                    fio.setServletrequest(this.request);
                    list.add(fio);
                }
            }
            param = URLDecoder.decode(param);
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethodForListParam(method, sessionobj, param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param"), list);
            if (retdata == null) {
                parts = "";
                return parts;
            }
            if (retdata instanceof String) {
                parts = (String)retdata;
                return parts;
            }
            parts = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return parts;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return string;
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception in) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/importExcel")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callImportExcelService(@QueryParam(value="srvname") String srvname, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form) {
        String string;
        ArrayList<FileImportObject> list = new ArrayList<FileImportObject>();
        try {
            ServiceVersion.getInstance().debugLog("start import.");
            Map mapFormData = form.getFields();
            Set sets = mapFormData.keySet();
            for (String key : sets) {
                List parts = (List)mapFormData.get(key);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key + ":" + filename);
                    if (StringUtils.isEmpty((Object)filename)) continue;
                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream((InputStream)part.getValueAs(InputStream.class));
                    fio.setServletrequest(this.request);
                    list.add(fio);
                }
            }
            param = URLDecoder.decode(param);
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");
            ExcelComponent excel = (ExcelComponent)SpringBeanFactory.getContext().getBean(ExcelComponent.class);
            ServiceResponse retdata = excel.importExcel(sessionobj, param, srvname, list);
            if (retdata == null) {
                String string2 = "";
                return string2;
            }
            if (retdata instanceof String) {
                String string3 = (String)((Object)retdata);
                return string3;
            }
            String string4 = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return string4;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return string;
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception in) {}
            }
        }
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            Response.ResponseBuilder builder;
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "export.xls";
            }
            String headType = "application/octet-stream";
            if (retdata instanceof String) {
                String s = String.valueOf(retdata).toLowerCase();
                if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                    headType = "application/ms-excel";
                }
                File fp = new File(s);
                filename = fp.getName();
                builder = Response.ok((Object)fp);
            } else {
                StringReader stream = new StringReader(retdata.toString());
                builder = Response.ok((Object)stream);
            }
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            this.response.setCharacterEncoding("UTF-8");
            builder.type(headType);
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportocm")
    public Response callExportServiceOcm(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            InputStreamReader inputReader = null;
            FileInputStream inputStream = new FileInputStream(fp);
            inputReader = new InputStreamReader(inputStream);
            BufferedReader bufferReader = new BufferedReader(inputReader);
            String line = null;
            StringBuffer strBuffer = new StringBuffer();
            while ((line = bufferReader.readLine()) != null) {
                strBuffer.append(line).append("\r\n");
            }
            ((InputStream)inputStream).close();
            String retdata = strBuffer.toString();
            if (StringUtils.isEmpty((Object)filename)) {
                filename = postparam;
            }
            Response.ResponseBuilder builder = Response.ok((Object)retdata);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportTxt")
    public Response callExportServiceTxt(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "export.xls";
            }
            Response.ResponseBuilder builder = Response.ok((Object)retdata);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            if (retdata instanceof String) {
                this.response.setCharacterEncoding("UTF-8");
                this.response.setContentType("text/plain");
            } else {
                builder.type("application/octet-stream");
            }
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportService(method, session, param, null, filename, headers);
    }

    @GET
    @Produces(value={"text/plain;charset=GBK"})
    @Path(value="/exportrar")
    public Response callExportServiceOcmrar(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("GBK");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportReportInfo")
    public Response callExportReportInfoService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        block10: {
            try {
                if (StringUtils.isEmpty((Object)postparam)) {
                    postparam = param;
                }
                if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                    postparam = URLDecoder.decode(postparam);
                }
                ServiceSession sessionobj = null;
                sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
                JSONObject json = JSONObject.parseObject((String)postparam);
                Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
                if (!(retdata instanceof ServiceResponse)) break block10;
                ServiceResponse res = (ServiceResponse)retdata;
                JSONObject obj = (JSONObject)res.getData();
                String in = obj.getString("rptinfo");
                String filename = obj.getString("modulecode");
                this.response.setHeader("Content-disposition", "attachment;filename=Module_" + filename + ".txt");
                try (FilterOutputStream bos = null;){
                    bos = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
                    byte[] buff = in.getBytes("utf-8");
                    bos.write(buff);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportReport")
    public Response callExportReportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            JSONObject json = JSONObject.parseObject((String)postparam);
            SXSSFWorkbook sxssfWorkbook = null;
            ServletOutputStream os = null;
            try {
                os = this.response.getOutputStream();
                if ("Excel".equalsIgnoreCase(json.getString("exporttype"))) {
                    sxssfWorkbook = new SXSSFWorkbook(1024);
                    ExcelComponent excel = (ExcelComponent)SpringBeanFactory.getContext().getBean(ExcelComponent.class);
                    String filename = excel.export(sxssfWorkbook, sessionobj, json);
                    this.response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
                    sxssfWorkbook.write((OutputStream)os);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (sxssfWorkbook != null) {
                        sxssfWorkbook.dispose();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/getphoto")
    public Response callGetphotoService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            String postparam = null;
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata)).build();
            }
            Response.ResponseBuilder builder = (Response.ResponseBuilder)retdata;
            return builder.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.ok((Object)Utils.getLastExceptionMessage(ex), (String)"text/plain;charset=UTF-8").build();
        }
    }

    private Map<String, Object> getParameters(Form form) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : form.entrySet()) {
            List value = (List)entry.getValue();
            if (value.isEmpty()) continue;
            if (value.size() == 1) {
                result.put((String)entry.getKey(), value.get(0));
                continue;
            }
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    private String addParamToJsonParam(ServiceSession session, HttpContext context, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey", "accessid"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey = DataUtils.nvl(rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        Form form = context.getRequest().getFormParameters();
        Map<String, Object> rps = this.getParameters(form);
        map.putAll(rps);
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }
        return JSONObject.toJSONString(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/restful")
    public String callRestServiceful(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpContext context) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            String postparam = this.addParamToJsonParam(sessionobj, context, "method", "session", "param");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            String string = result;
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    private FileServiceImpl createFileServiceImpl() {
        return SpringBeanFactory.getBean("fileExportService", FileServiceImpl.class);
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportExcel")
    public Response callExportExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            FileServiceImpl temp = this.createFileServiceImpl();
            String head = "/opt/logs/";
            temp.setHead(head);
            String fileaname = temp.export(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportTemplate")
    public Response callExportTemplateService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = this.createFileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            String fileaname = temp.exportTemplate(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportExcelTemplate")
    public Response callExportExcelTemplateService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            ExcelComponent excel = (ExcelComponent)SpringBeanFactory.getContext().getBean(ExcelComponent.class);
            Map<String, Object> map = excel.exportTemplate(sessionobj, json);
            InputStream fis = (InputStream)map.get("inputStream");
            String filename = (String)map.get("filename");
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            this.response.reset();
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportLC")
    public Response callExportLCService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = this.createFileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            String fileaname = temp.exportLC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportNC")
    public Response callExportNCService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = this.createFileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            String fileaname = temp.exportNC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportPrint")
    public Response callExportPrintService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            String fileaname = json.getString("data");
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/createExcel")
    public String callcreateExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = this.createFileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            temp.setFilePath(head);
            String retdata = temp.exportExcelPrint(sessionobj, json);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("data", retdata);
            m.put("returncode", rtncode);
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(m));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            String string = result;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            String string = result;
            return string;
        }
        finally {
            locale.remove();
        }
    }

    @GET
    @Path(value="/previewPdf")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response downloadMongoPdf(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        String temp = this.callRestService(method, session, param, null);
        JSONObject result = JSON.parseObject((String)temp);
        byte[] by = result.getBytes("file");
        this.response.reset();
        this.response.setDateHeader("Expires", 0L);
        this.response.setCharacterEncoding("UTF-8");
        this.response.setHeader("Content-Type", "application/pdf");
        ServletOutputStream outputStream = this.response.getOutputStream();
        IOUtils.write((byte[])by, (OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
        return null;
    }

    @GET
    @Path(value="/download")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response downloadMongo(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        Response.ResponseBuilder builder = null;
        String temp = this.callRestService(method, session, param, null);
        JSONObject result = JSON.parseObject((String)temp);
        JSONObject jsonparam = JSON.parseObject((String)param);
        String contentDisposition = "attachment; ";
        String filename = result.getString("filename");
        String browser = headers.getRequestHeader("User-Agent").toString();
        contentDisposition = browser != null && browser.toLowerCase().indexOf("firefox") > 0 ? contentDisposition + "filename*=UTF-8''" + filename : contentDisposition + "filename=" + filename;
        builder = !StringUtils.isEmpty((Object)jsonparam.get((Object)"encoded")) ? Response.ok((Object)new String(result.getBytes("file"), jsonparam.getString("encoded"))) : (filename.endsWith("txt") || filename.endsWith("TXT") ? Response.ok((Object)new String(result.getBytes("file"), "GBK")) : Response.ok((Object)result.getBytes("file")));
        builder.header("Content-Disposition", (Object)contentDisposition);
        builder.type("application/octet-stream");
        return builder.build();
    }

    @POST
    @Path(value="/upLoadMongo")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public Response upLoadMongo(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form) throws Exception {
        String filename = null;
        Map mapFormData = form.getFields();
        Set keys = mapFormData.keySet();
        JSONObject jsonparam = new JSONObject();
        FormDataBodyPart filepart = null;
        for (String key : keys) {
            List parts = (List)mapFormData.get(key);
            for (int i = 0; i < parts.size(); ++i) {
                FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                filename = part.getContentDisposition().getFileName();
                if (part != null && filename != null) {
                    filepart = (FormDataBodyPart)parts.get(i);
                    continue;
                }
                System.out.println(key + ":" + ((FormDataBodyPart)parts.get(i)).getValue());
                if (key.equalsIgnoreCase("filename")) {
                    jsonparam.put("filename", (Object)((FormDataBodyPart)parts.get(0)).getValue());
                    continue;
                }
                jsonparam.put(key, (Object)((FormDataBodyPart)parts.get(0)).getValue());
            }
        }
        if (jsonparam.get((Object)"filename") != null) {
            String tempfilename;
            filename = jsonparam.get((Object)"filename").toString();
            if ("Y".equals(jsonparam.get((Object)"decodeflag")) && (tempfilename = URLDecoder.decode(filename, "UTF-8")) != null) {
                filename = tempfilename;
            }
        }
        InputStream in = (InputStream)filepart.getValueAs(InputStream.class);
        jsonparam.put("file", (Object)this.inputStreamToByte(in));
        in.close();
        JSONObject json = JSON.parseObject((String)param);
        json.put("param", (Object)jsonparam);
        Response.ResponseBuilder builder = Response.ok((Object)this.callRestService(method, session, json.toJSONString(), null));
        builder.header("Access-Control-Allow-Origin", (Object)"*");
        return builder.build();
    }

    @GET
    @Path(value="/downloadData")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response downloadMongoData(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        Response.ResponseBuilder builder = Response.ok((Object)this.callRestServiceByGET(method, session, param));
        builder.header("Access-Control-Allow-Origin", (Object)"*");
        return builder.build();
    }

    @GET
    @Path(value="/deleteData")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response deleteMongoData(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        Response.ResponseBuilder builder = Response.ok((Object)this.callRestServiceByGET(method, session, param));
        builder.header("Access-Control-Allow-Origin", (Object)"*");
        return builder.build();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportbyfile")
    public Response callExportByFileService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            String headType = "application/octet-stream";
            String s = String.valueOf(retdata).toLowerCase();
            File fp = new File(s);
            filename = fp.getName();
            Response.ResponseBuilder builder = null;
            if (filename.endsWith(".xls") || filename.endsWith(".xlsx") || filename.endsWith(".rar") || filename.endsWith("txt")) {
                builder = Response.ok((Object)fp);
            } else {
                builder = Response.ok((Object)retdata);
                filename = "export.xls";
            }
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            if (retdata instanceof String) {
                this.response.setCharacterEncoding("UTF-8");
                this.response.setContentType("text/plain");
                builder.type("application/octet-stream");
            } else {
                builder.type("application/octet-stream");
            }
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=GBK"})
    @Path(value="/exportcustomrar")
    public Response callExportServiceOcmCustomrar(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse)retdata;
            JSONObject para = (JSONObject)resultParam.getData();
            String filename = para.getString("filename");
            File file = new File(filename);
            System.out.println(file.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (file.exists() && file.isFile()) {
                boolean result = file.delete();
                int tryCount = 0;
                while (!result && tryCount++ < 10) {
                    System.gc();
                    result = file.delete();
                }
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, file.getName()));
            this.response.setCharacterEncoding("GBK");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportComplexExcel")
    public Response callExportComplexExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse)retdata;
            JSONObject para = (JSONObject)resultParam.getData();
            ArrayList<Map<String, Object>> report = (ArrayList<Map<String, Object>>)para.get((Object)"report");
            if (report == null) {
                report = new ArrayList<Map<String, Object>>();
            }
            FileServiceImpl fileSrv = this.createFileServiceImpl();
            String filePath = this.request.getSession().getServletContext().getRealPath("/");
            fileSrv.setFilePath(filePath);
            String fileaname = fileSrv.exportComplex(sessionobj, json, report);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @POST
    @Path(value="/upload")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String upLoadFile(FormDataMultiPart form, @QueryParam(value="method") String method, @QueryParam(value="session") String session) throws Exception {
        String result = null;
        String rtncode = "0";
        ServiceSession sessionobj = null;
        long start_time = System.currentTimeMillis();
        try {
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Map mapFormData = form.getFields();
            Set keys = mapFormData.keySet();
            JSONObject jsonparam = new JSONObject();
            ArrayList fileparts = new ArrayList();
            for (String key : keys) {
                List parts = (List)mapFormData.get(key);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    if (part != null && filename != null) {
                        fileparts.add(parts.get(i));
                        System.out.println(key + ":" + filename);
                        continue;
                    }
                    jsonparam.put(key, (Object)((FormDataBodyPart)parts.get(0)).getValue());
                }
            }
            Object retdata = rcm.executeClassMethodForJSONListParam(method, sessionobj, jsonparam, fileparts);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
                rtncode = response.getReturncode();
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(sessionobj, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(sessionobj, "50000", Utils.getLastExceptionMessage(ex)));
            rtncode = "555";
            return result;
        }
    }

    @GET
    @Path(value="/exportFile")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response exportFile(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        Response.ResponseBuilder builder = null;
        JSONObject param2 = JSON.parseObject((String)param);
        param2.put("filepathhead", (Object)this.request.getSession().getServletContext().getRealPath("/"));
        String temp = this.callRestService(method, session, param2.toJSONString(), null);
        if (temp == null || StringUtils.isEmpty((Object)temp)) {
            return Response.ok((Object)"\u4e0b\u8f7d\u5931\u8d25", (String)"text/plain;charset=UTF-8").build();
        }
        JSONObject result = JSON.parseObject((String)temp);
        JSONObject jsonparam = JSON.parseObject((String)param);
        String contentDisposition = "attachment; ";
        if (!result.containsKey((Object)"filename") || StringUtils.isEmpty((Object)result.getString("filename"))) {
            return Response.ok((Object)"\u4e0b\u8f7d\u5931\u8d25", (String)"text/plain;charset=UTF-8").build();
        }
        String filename = result.getString("filename");
        String browser = headers.getRequestHeader("User-Agent").toString();
        byte[] buffer = null;
        contentDisposition = browser != null && browser.toLowerCase().indexOf("firefox") > 0 ? contentDisposition + "filename*=UTF-8''" + filename : contentDisposition + "filename=" + filename;
        if (!(result.containsKey((Object)"filepath") && !StringUtils.isEmpty((Object)result.get((Object)"filepath")) || result.containsKey((Object)"file") && !StringUtils.isEmpty((Object)result.get((Object)"file")))) {
            return Response.ok((Object)"\u4e0b\u8f7d\u5931\u8d25", (String)"text/plain;charset=UTF-8").build();
        }
        if (!StringUtils.isEmpty((Object)result.get((Object)"filepath"))) {
            File fp = new File(result.getString("filepath"));
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
        } else {
            buffer = result.getBytes("file");
        }
        builder = !StringUtils.isEmpty((Object)jsonparam.get((Object)"encoded")) ? Response.ok((Object)new String(buffer, jsonparam.getString("encoded"))) : (filename.endsWith("txt") || filename.endsWith("TXT") ? Response.ok((Object)new String(buffer, "GBK")) : Response.ok((Object)buffer));
        builder.header("Content-Disposition", (Object)contentDisposition);
        builder.type("application/octet-stream");
        return builder.build();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportgroup")
    public Response callExportServiceGrpGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportServiceGrpPost(method, session, param, null, filename, headers);
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportgroup")
    public Response callExportServiceGrpPost(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "custgroup.xls";
            }
            String headType = "application/octet-stream";
            String s = String.valueOf(retdata).toLowerCase();
            if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                headType = "application/ms-excel";
            }
            File fp = new File(s);
            filename = fp.getName();
            Response.ResponseBuilder builder = Response.ok((Object)fp);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            this.response.setCharacterEncoding("UTF-8");
            builder.type(headType);
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex)));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/captcha")
    @Produces(value={"application/octet-stream"})
    public Response previewCaptcha(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers, @Context HttpContext context) throws Exception {
        JSONObject data;
        long start_time = System.currentTimeMillis();
        ServiceSession sessionobj = null;
        sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        String postparam = this.addParamToJsonParam(sessionobj, context.getRequest().getFormParameters(), "method", "session", "param");
        this.response.setDateHeader("Expires", 0L);
        this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        this.response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setContentType("image/jpeg");
        Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
        if (retdata instanceof ServiceResponse && ((ServiceResponse)retdata).getReturncode().equals("0") && (data = (JSONObject)((ServiceResponse)retdata).getData()).containsKey((Object)"capBuff") && data.get((Object)"capBuff") instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)data.get((Object)"capBuff");
            ServletOutputStream out = this.response.getOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
            try {
                out.flush();
            }
            finally {
                out.close();
            }
        }
        return null;
    }

    private static String getURLParamStrFromMap(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Object[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object name = keys[i];
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append((String)name);
                sb.append("=");
                sb.append((String)params.get(name));
            }
        }
        return sb.toString();
    }

    private String addParamToJsonParam(ServiceSession session, Form form, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey", "accessid"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey = UserDataRangeSrv.getPortalkey();
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        Map<String, Object> rps = this.getParameters(form);
        map.putAll(rps);
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }
        return JSONObject.toJSONString(map);
    }

    private String addQueryParamToJsonParam(TaobaoSession session, String param) {
        Map<String, String> rp = this.getParameter();
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String key = entry.getKey();
            String[] values = this.request.getParameterValues(key);
            if (values == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (session == null) {
                session = new TaobaoSession();
            }
            if ("ent_id".equalsIgnoreCase(key)) {
                session.setEnt_id(Long.parseLong(value));
            }
            if ("app_key".equalsIgnoreCase(key)) {
                session.setApp_key(value);
            }
            if ("target_appkey".equalsIgnoreCase(key)) {
                session.setTarget_appkey(value);
            }
            if ("source_appkey".equalsIgnoreCase(key)) {
                session.setSource_appkey(value);
            }
            if ("method".equalsIgnoreCase(key)) {
                session.setMethod(value);
            }
            if ("cmd".equalsIgnoreCase(key)) {
                session.setCmd(value);
            }
            if ("request_id".equalsIgnoreCase(key)) {
                session.setRequest_id(value);
            }
            if ("timestamp".equalsIgnoreCase(key)) {
                session.setTimestamp(value);
            }
            if ("format".equalsIgnoreCase(key)) {
                session.setFormat(value);
            }
            if ("sign_method".equalsIgnoreCase(key)) {
                session.setSign_method(value);
            }
            if (!"sign".equalsIgnoreCase(key)) continue;
            session.setSign(value);
        }
        if (!StringUtils.isEmpty((Object)param)) {
            try {
                JSONObject jsonparam = JSON.parseObject((String)param);
                if (jsonparam != null && jsonparam.containsKey((Object)"merchant_code")) {
                    session.setEnt_id(jsonparam.getLong("merchant_code"));
                }
            }
            catch (Exception ex) {
                ServiceLogs.debuglog("qimen_req", "qimen\u63a5\u53e3\u5165\u53c2\u683c\u5f0f\u4e0d\u6b63\u786e", 0L);
            }
        }
        return "";
    }

    public JSONObject checkSign(TaobaoSession session, String body) {
        JSONObject result = new JSONObject();
        try {
            String appSecretKey = EnterpriseProxy.getInstance().getEnterpriseConfig(session.getEnt_id(), "qimenAppSecretKey", true, "");
            if (appSecretKey == null) {
                result.put("success", (Object)false);
                result.put("err_code", (Object)"10000");
                result.put("err_msg", (Object)"\u672a\u627e\u5230\u6388\u6743\u5bc6\u94a5");
                return result;
            }
            CheckResult res = SpiUtils.checkSign(this.request, appSecretKey, body, "JSON");
            if (!res.isSuccess()) {
                result.put("success", (Object)false);
                result.put("err_code", (Object)"sign-check-failure");
                result.put("err_msg", (Object)"Illegal request");
                return result;
            }
            return result;
        }
        catch (ServiceException e) {
            ServiceLogs.errLog("Qimen_CheckSign", e, "\u5947\u95e8\u7f51\u5173\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25", new Object[0]);
            result.put("success", (Object)false);
            result.put("err_code", (Object)"sign-check-failure");
            result.put("err_msg", (Object)"Illegal request");
            return result;
        }
        catch (Exception ex) {
            ServiceLogs.errLog("Qimen_CheckSign", ex, "\u5947\u95e8\u7f51\u5173\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25", new Object[0]);
            result.put("success", (Object)false);
            result.put("err_code", (Object)"sign-check-failure");
            result.put("err_msg", (Object)"Illegal request");
            return result;
        }
    }

    private byte[] inputStreamToByte(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            int count = -1;
            while ((count = in.read(data)) != -1) {
                outStream.write(data, 0, count);
            }
            byte[] byArray = data = outStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

