/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy(value=true)
@Component(value="RestClientUtils_DataHub")
public class RestClientUtils_DataHub
extends RestClientUtils {
    private final String TOKEN_EXPIRED = "TOKEN_EXPIRED";

    public RestClientUtils_DataHub() {
    }

    public RestClientUtils_DataHub(int poolSize, long maxWait, String config) {
        super(poolSize, maxWait, config);
    }

    public RestClientUtils_DataHub(String config) {
        super(config);
    }

    private String getData(JSONObject json, String key, String defval) {
        if (json.containsKey((Object)key)) {
            return json.getString(key);
        }
        return defval;
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param, new RestClientUtils.defaultRequestCallback(this), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = JSON.parseObject((String)((String)result));
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
        }
        if (response == null) {
            throw new ServiceException("50000", (String)result, new Object[0]);
        }
        if (response.getReturncode().equals("0")) {
            Object hubdata = response.getData();
            if (hubdata instanceof JSONArray) {
                JSONArray arr = (JSONArray)hubdata;
                if (arr.size() > 0) {
                    JSONObject row = (JSONObject)arr.get(0);
                    if (!this.getData(row, "retcode", "0").equals("0")) {
                        throw new ServiceException("10000", this.getData(row, "retcode", "0").concat(":").concat(this.getData(row, "retmsg", "\u672a\u77e5\u9519\u8bef")), new Object[0]);
                    }
                    if (!this.getData(row, "o_retcode", "0").equals("0")) {
                        throw new ServiceException("10000", this.getData(row, "o_retcode", "0").concat(":").concat(this.getData(row, "o_retmsg", "\u672a\u77e5\u9519\u8bef")), new Object[0]);
                    }
                }
            } else if (hubdata instanceof JSONObject) {
                JSONObject row = (JSONObject)hubdata;
                if (!this.getData(row, "retcode", "0").equals("0")) {
                    throw new ServiceException("10000", this.getData(row, "retcode", "0").concat(":").concat(this.getData(row, "retmsg", "\u672a\u77e5\u9519\u8bef")), new Object[0]);
                }
                if (!this.getData(row, "o_retcode", "0").equals("0")) {
                    throw new ServiceException("10000", this.getData(row, "o_retcode", "0").concat(":").concat(this.getData(row, "o_retmsg", "\u672a\u77e5\u9519\u8bef")), new Object[0]);
                }
            }
            return response;
        }
        if (!"0".equals(response.getReturncode())) {
            return response;
        }
        return response;
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, EnterpriseConfigBean ent, JSONObject param, String dataNode) throws Exception {
        String authKey = ent.getSrvConfig("appId", false) + "," + ent.getSrvConfig("appKey", false);
        String fullUrl = this.getUrl(session, baseUrl, ent.getSrvConfig("authUrl", false), authKey, param, false);
        ServiceResponse resp = this.sendRequest((Object)session, fullUrl, (Object)param.toJSONString(), dataNode);
        if ("TOKEN_EXPIRED".equalsIgnoreCase(resp.getReturncode())) {
            fullUrl = this.getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), authKey, param, true);
            resp = this.sendRequest((Object)session, fullUrl, (Object)param.toJSONString(), dataNode);
        }
        return resp;
    }

    public String getTokenStr(long ent_id, String authUrl, String authKey, boolean force) throws Exception {
        String memKey = "DataHub-" + ent_id;
        String accessToken = (String)CacheUtils.getCacheUtils().getData(memKey);
        if (StringUtils.isEmpty((CharSequence)accessToken) || force) {
            JSONObject remote_token = this.getRemoteToken(authUrl, authKey);
            if (remote_token.containsKey((Object)"access_token")) {
                accessToken = remote_token.getString("access_token");
                int expires_in = remote_token.getIntValue("expires_in");
                if (expires_in == -1) {
                    CacheUtils.getCacheUtils().putData(memKey, accessToken, 86400);
                } else if (expires_in > 60) {
                    CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
                }
            } else {
                throw new ServiceException("10000", "\u83b7\u53d6\u4ee3\u7406TOKEN\u9519\u8bef,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", new Object[0]);
            }
        }
        return "&access_token=".concat(accessToken);
    }

    protected JSONObject getRemoteToken(String authUrl, String authKey) throws IOException {
        try {
            JSONObject result = JSONObject.parseObject((String)HttpUtils.getRequest(authUrl));
            if ("0".equals(this.getData(result, "code", "-1"))) {
                return result;
            }
            throw new ServiceException("10000", this.getData(result, "msg", "\u672a\u77e5\u9519\u8bef"), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getHex(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    private static String toHexString(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + RestClientUtils_DataHub.getHex(byteArray[i]);
        }
        return strDigest;
    }

    public String checkSignature(String appKey, String timestamp, String data, boolean debugStatus) throws UnsupportedEncodingException {
        Object[] arr = new String[]{appKey, timestamp, data};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            content.append((String)arr[i]);
        }
        MessageDigest md = null;
        String tmpStr = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes("UTF-8"));
            tmpStr = RestClientUtils_DataHub.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (debugStatus) {
            this.logger.info((Object)("SignSrc:" + content));
            this.logger.info((Object)("SignStr:" + tmpStr));
        }
        return tmpStr;
    }

    private String getSignStr(String authKey, JSONObject param, boolean debugStatus) throws UnsupportedEncodingException {
        String[] keys = authKey.split(",");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String appid = keys[0];
        String appKey = keys[1];
        StringBuilder sb = new StringBuilder();
        sb.append("&appid=");
        sb.append(appid);
        sb.append("&timestamp=");
        sb.append(timestamp);
        sb.append("&sign=");
        SerializerFeature[] serializerFeatureArray = new SerializerFeature[1];
        serializerFeatureArray[0] = SerializerFeature.MapSortField;
        sb.append(this.checkSignature(appKey, timestamp, JSONObject.toJSONString((Object)param, (SerializerFeature[])serializerFeatureArray), debugStatus));
        return sb.toString();
    }

    public String getUrl(ServiceSession session, String baseUrl, String authUrl, String authKey, JSONObject param, boolean force) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)authUrl)) {
            String tokenStr = this.getTokenStr(session.getEnt_id(), authUrl, authKey, force);
            String signStr = this.getSignStr(authKey, param, "Y".equalsIgnoreCase(session.getDebug_status()));
            return baseUrl.concat(tokenStr).concat(signStr);
        }
        return baseUrl;
    }
}

