/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class PrecisionUtils {
    private static final int DEF_DIV_SCALE = 10;

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, 10, 4).doubleValue();
    }

    public static double mod(double v1, double v2) {
        if (v2 == 0.0) {
            return v1;
        }
        double a = PrecisionUtils.div(v1, v2);
        int b = (int)a;
        double c = PrecisionUtils.mul(b, v2);
        return PrecisionUtils.sub(Math.abs(v1), Math.abs(c));
    }

    public static int doubleCompare(double f1, double f2, int dec) {
        float f = 1.0f;
        for (int i = 0; i <= dec; ++i) {
            f = (float)((double)f / 10.0);
        }
        if (Math.abs((f1 = PrecisionUtils.doubleConvert(f1, dec, 1)) - (f2 = PrecisionUtils.doubleConvert(f2, dec, 1))) <= (double)f) {
            return 0;
        }
        if (f1 > f2) {
            return 1;
        }
        return -1;
    }

    public static int getDoubleSign(double f) {
        return PrecisionUtils.doubleCompare(f, 0.0, 2) >= 0 ? 1 : -1;
    }

    public static int getDoubleScale(double f) {
        int i = 0;
        double d;
        while ((d = f * Math.pow(10.0, i)) != (double)((long)d)) {
            ++i;
        }
        return i;
    }

    public static String doubleToString(double value) {
        return PrecisionUtils.doubleToString(value, 2, 1, false, 0);
    }

    public static String doubleToString(double value, int dec, int flag) {
        return PrecisionUtils.doubleToString(value, dec, flag, false, 0);
    }

    public static String doubleToString(double value, int dec, int flag, boolean subdec) {
        return PrecisionUtils.doubleToString(value, dec, flag, subdec, 0);
    }

    public static String doubleToString(double value, int dec, int flag, boolean subdec, int rightwidth) {
        StringBuffer sb = new StringBuffer("0");
        if (dec > 0) {
            sb.append(".");
        }
        for (int i = 0; i < dec; ++i) {
            sb.append("0");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        String s = df.format(PrecisionUtils.doubleConvert(value, dec, flag));
        if (subdec) {
            while (s.charAt(s.length() - 1) == '0' || s.charAt(s.length() - 1) == '.') {
                if (s.charAt(s.length() - 1) == '.') {
                    s = s.substring(0, s.length() - 1);
                    break;
                }
                s = s.substring(0, s.length() - 1);
            }
        }
        if (rightwidth > 0) {
            s = PrecisionUtils.increaseCharForward(s, rightwidth);
        }
        return s;
    }

    public static String increaseChar(String str, int num) {
        return PrecisionUtils.increaseChar(str, ' ', num);
    }

    public static String increaseChar(String str, char c, int num) {
        int len;
        int limit = num <= 0 ? 16 : num;
        for (int i = len = str.length(); i < limit; ++i) {
            str = str + c;
        }
        if (str.length() > limit) {
            return str.substring(str.length() - limit);
        }
        return str;
    }

    public static String increaseCharForward(String str, int num) {
        return PrecisionUtils.increaseCharForward(str, ' ', num);
    }

    public static String increaseCharForward(String str, char c, int num) {
        int len;
        int limit = num <= 0 ? 16 : num;
        for (int i = len = str.length(); i < limit; ++i) {
            str = c + str;
        }
        if (str.length() > limit) {
            return str.substring(str.length() - limit);
        }
        return str;
    }

    public static int integerDiv(double f1, double f2) {
        int num;
        double fz = Math.abs(f1);
        double fm = Math.abs(f2);
        if (fm == 0.0) {
            fm = 1.0;
        }
        if (PrecisionUtils.doubleCompare(fm * (double)(num = (int)PrecisionUtils.doubleConvert(fz / fm)), fz, 2) > 0) {
            --num;
        }
        if (num < 0) {
            num = 0;
        }
        if (Math.abs(f2) == 0.0 && Math.abs(f1) > 0.0 && num == 0) {
            num = 1;
        }
        return num;
    }

    public static double doubleConvert(double f) {
        return PrecisionUtils.doubleConvert(f, 2, 1);
    }

    public static double doubleConvert(double f, int dec) {
        return PrecisionUtils.doubleConvert(f, dec, 1);
    }

    public static double doubleConvert(double f, int dec, int flag) {
        return PrecisionUtils.doubleConvert(f, dec, flag, false);
    }

    public static double doubleConvert(double f, int dec, int flag, boolean r) {
        if (flag == 1) {
            double d = f;
            if (!r) {
                d = PrecisionUtils.doubleConvert(d, dec + 2, 1, true);
            }
            d = !r && dec > 0 ? PrecisionUtils.doubleConvert(d * Math.pow(10.0, dec), 0, 1) : (d *= Math.pow(10.0, dec));
            return (double)Math.round(d) / Math.pow(10.0, dec);
        }
        double d = Math.abs(f);
        if (!r) {
            d = PrecisionUtils.doubleConvert(d, dec + 2, 1, true);
        }
        return Math.floor(d *= Math.pow(10.0, dec)) / (Math.pow(10.0, dec) * (double)(f < 0.0 ? -1 : 1));
    }

    public static String getFilterNumberNoStr(String str) {
        String str1 = "";
        for (int i = 0; i < str.length(); ++i) {
            if (!PrecisionUtils.isNumber(String.valueOf(str.charAt(i)))) continue;
            str1 = str1 + str.charAt(i);
        }
        return str1;
    }

    public static boolean isNumber(String str) {
        try {
            return str.matches("^(-?\\d+)(\\d+)?$");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isDoubleOrNumber(String str) {
        try {
            return str.matches("^(-?\\d+)(\\.\\d+)?$");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

