/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class UniqueID
implements InitializingBean {
    private static Integer number = new Integer(0);
    private String hostId = "";
    private long Starttime = 0L;
    @Value(value="${system.systemstartdate:2018-01-01}")
    public String systemStartDate = "2018-01-01";
    @Value(value="${server.port:0000}")
    public String port = "0000";
    private static String PID = null;
    private static String OS = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getId() {
        Class<UniqueID> clazz = UniqueID.class;
        synchronized (UniqueID.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.createId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getIdArray(int number) {
        ArrayList<Long> retArray = new ArrayList<Long>();
        Class<UniqueID> clazz = UniqueID.class;
        synchronized (UniqueID.class) {
            for (int i = 0; i < number; ++i) {
                retArray.add(this.createId());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return retArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNoArray(int number, int len) {
        ArrayList<String> retArray = new ArrayList<String>();
        Class<UniqueID> clazz = UniqueID.class;
        synchronized (UniqueID.class) {
            StringBuffer sb = new StringBuffer();
            String fmt = "%0" + (len -= 13) + "d";
            for (int i = 0; i < len; ++i) {
                sb.append("9");
            }
            int sed = Integer.parseInt(sb.toString());
            int sedmod = sed + 1;
            SecureRandom rand = new SecureRandom();
            for (int i = 0; i < number; ++i) {
                long uid = 0L;
                Date dt = new Date();
                uid = dt.getTime();
                Formatter format = new Formatter();
                String suff = format.format(fmt, rand.nextInt(sed) % sedmod).toString();
                retArray.add(String.valueOf(uid) + suff);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return retArray;
        }
    }

    private long createId() {
        long uid = 0L;
        Date dt = new Date();
        uid = dt.getTime() / 1000L;
        uid -= this.Starttime / 1000L;
        uid = Long.parseLong(String.valueOf(uid) + this.hostId);
        int len = 18 - String.valueOf(uid).length();
        Formatter format = new Formatter();
        String num = format.format("%0" + len + "d", number).toString();
        uid = Long.parseLong(String.valueOf(uid) + num);
        number = (number + 1) % 1000000;
        return uid;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void init() {
        if (StringUtils.isEmpty((Object)this.hostId) || this.hostId.length() > 3) {
            this.hostId = this.genHostId();
        }
    }

    public void setHostId(String hostId) {
        if (!StringUtils.isEmpty((Object)hostId) && (hostId.startsWith("/") || hostId.startsWith("\\"))) {
            try {
                hostId.replace("\\", "/");
                int pos = hostId.lastIndexOf("/");
                String file = hostId.substring(0, pos);
                String key = hostId.substring(pos + 1);
                File input = new File(WebPathUtils.getWebRootPath() + file);
                FileInputStream is = new FileInputStream(input);
                Properties prop = new Properties();
                prop.load(is);
                ((InputStream)is).close();
                hostId = prop.get(key).toString().trim();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((Object)hostId) && hostId.length() <= 3) {
            this.hostId = hostId;
        }
    }

    private String genHostId() {
        String ip = UniqueID.getHostIP();
        String port = this.getPort();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = null;
        try {
            startDate = sd.parse(this.systemStartDate);
            this.Starttime = startDate.getTime();
        }
        catch (ParseException e) {
            this.Starttime = 1514736000000L;
        }
        Date dt = new Date();
        long time = dt.getTime() / 1000L - this.Starttime / 1000L;
        String md5key = ip + port + time;
        String md5 = DigestUtils.md5Hex((String)md5key);
        int add = 0;
        byte[] bytes = md5.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            add += bytes[i];
        }
        return String.valueOf(add);
    }

    public static String getHostIP() {
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface nif = netInterfaces.nextElement();
                Enumeration<InetAddress> iparray = nif.getInetAddresses();
                while (iparray.hasMoreElements()) {
                    String localip;
                    InetAddress ip = iparray.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || "127.0.0.1".equals(localip = ip.getHostAddress())) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static UniqueID getInstance() {
        UniqueID uniqueID = SpringBeanFactory.getBean(EnvironmentParaUtils.getEnvPra("efuture.main.uid", "UniqueID"), UniqueID.class);
        return uniqueID;
    }

    public static long getUniqueID() {
        return UniqueID.getInstance().getId();
    }

    public static List<Long> getUniqueIDArray(int size) {
        return UniqueID.getInstance().getIdArray(size);
    }

    public static List<String> getUniqueNoArray(int size, int len) {
        return UniqueID.getInstance().getNoArray(size, len);
    }

    public static long getTime() {
        return 0L;
    }

    public String getPort() {
        if (this.port.equalsIgnoreCase("0000")) {
            String pid = UniqueID.getPid();
            return UniqueID.getPort(pid);
        }
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPort(String pid) {
        BufferedReader buffereReader = null;
        Process process = null;
        String port = "0";
        try {
            if (UniqueID.getOs().indexOf("window") != -1) {
                String line2;
                String cmd = "cmd /c netstat -anop TCP|findstr \"" + pid + "\"";
                process = Runtime.getRuntime().exec(cmd);
                if (process.waitFor() != 0) {
                    System.out.println("\u8b66\u544a:\u6267\u884cnetstat\u547d\u4ee4\u5931\u8d25pid-IP");
                    String string = "0";
                    return string;
                }
                buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line2 = buffereReader.readLine()) != null) {
                    int idx;
                    String[] st = (line2 = line2.trim()).split("[\\s]{1,}");
                    if (st.length != 5 || (idx = st[1].lastIndexOf(":")) == -1) continue;
                    String _port = st[1].substring(idx + 1);
                    if (!pid.equals(st[4])) continue;
                    port = _port;
                }
            } else {
                String line;
                String[] cmds = new String[]{"/bin/sh", "-c", "netstat -tlnp|grep \"" + pid + "\""};
                process = Runtime.getRuntime().exec(cmds);
                if (process.waitFor() != 0) {
                    System.out.println("\u8b66\u544a:\u6267\u884cnetstat\u547d\u4ee4\u5931\u8d25pid-IP");
                    String line2 = "0";
                    return line2;
                }
                buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = buffereReader.readLine()) != null) {
                    int idx;
                    String[] st = (line = line.trim()).split("[\\s]{1,}");
                    if (st.length != 7 || (idx = st[3].lastIndexOf(":")) == -1) continue;
                    String _port = st[3].substring(idx + 1);
                    idx = st[6].indexOf("/");
                    String _pid = st[6];
                    if (idx != -1) {
                        _pid = _pid.substring(0, idx);
                    }
                    if (!pid.equals(_pid)) continue;
                    port = _port;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (buffereReader != null) {
                    buffereReader.close();
                }
            }
            catch (Exception exception) {}
            buffereReader = null;
            process = null;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getIp(String pid) {
        BufferedReader buffereReader = null;
        Process process = null;
        HashMap<String, String> ips = new HashMap<String, String>();
        try {
            if (UniqueID.getOs().indexOf("window") != -1) {
                String line2;
                String cmd = "cmd /c netstat -anop TCP|findstr \"" + pid + "\"";
                process = Runtime.getRuntime().exec(cmd);
                if (process.waitFor() != 0) {
                    System.out.println("\u8b66\u544a:\u6267\u884cnetstat\u547d\u4ee4\u5931\u8d25pid-IP");
                    HashMap<String, String> hashMap = ips;
                    return hashMap;
                }
                buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line2 = buffereReader.readLine()) != null) {
                    int idx;
                    String[] st = (line2 = line2.trim()).split("[\\s]{1,}");
                    if (st.length != 5 || (idx = st[1].lastIndexOf(":")) == -1) continue;
                    String _port = st[1].substring(idx + 1);
                    if (!pid.equals(st[4])) continue;
                    ips.put(st[1], _port);
                }
            } else {
                String line;
                String[] cmds = new String[]{"/bin/sh", "-c", "netstat -tlnp|grep \"" + pid + "\""};
                process = Runtime.getRuntime().exec(cmds);
                if (process.waitFor() != 0) {
                    System.out.println("\u8b66\u544a:\u6267\u884cnetstat\u547d\u4ee4\u5931\u8d25pid-IP");
                    HashMap<String, String> line2 = ips;
                    return line2;
                }
                buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = buffereReader.readLine()) != null) {
                    int idx;
                    String[] st = (line = line.trim()).split("[\\s]{1,}");
                    if (st.length != 7 || (idx = st[3].lastIndexOf(":")) == -1) continue;
                    String _port = st[3].substring(idx + 1);
                    idx = st[6].indexOf("/");
                    String _pid = st[6];
                    if (idx != -1) {
                        _pid = _pid.substring(0, idx);
                    }
                    if (!pid.equals(_pid)) continue;
                    ips.put(st[3], _port);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (buffereReader != null) {
                    buffereReader.close();
                }
            }
            catch (Exception exception) {}
            buffereReader = null;
            process = null;
        }
        System.out.println("\u5f53\u524dport:" + ips);
        return ips;
    }

    public static String getPid() {
        if (PID == null) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                System.out.println(runtime.getInputArguments());
                String name = runtime.getName();
                PID = name.substring(0, name.indexOf(64));
            }
            catch (Throwable e) {
                System.out.println("\u8b66\u544a:\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u8fdb\u7a0b\u53f7");
                e.printStackTrace();
                PID = "-1";
            }
        }
        System.out.println("\u5f53\u524dcpid:" + PID);
        return PID;
    }

    public static String getOs() {
        if (OS == null) {
            OS = System.getProperty("os.name").toLowerCase();
        }
        return OS;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }
}

