/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.efuture.ocp.common.billservice.BillAbstractHeadBean;
import com.efuture.ocp.common.billservice.BillOperLogService;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.BillOperLogBean;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.Date;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class BillOperLogSrvImpl
extends BasicComponent
implements BillOperLogService {
    private String storage = null;

    public BillOperLogSrvImpl() {
        this.setStorage(null);
    }

    public static BillOperLogService getLog() {
        if (SpringBeanFactory.containsBean("BillOperLogSrv")) {
            return SpringBeanFactory.getBean("BillOperLogSrv", BillOperLogService.class);
        }
        return null;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        storage = storage == null || storage.trim().length() == 0 ? "StorageOperation_portal" : storage.trim();
        this.storage = storage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void log(BillOperLogBean log) {
        this.getStorageOperationConfig(this.storage).insert((Object)log);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void log(long ent_id, String oper, String opername, String billmoduleid, String billno, String opertype, String memo) {
        BillOperLogBean nlog = new BillOperLogBean();
        nlog.setEnt_id(ent_id);
        nlog.setOper(oper);
        nlog.setOpername(opername);
        nlog.setBillmoduleid(billmoduleid);
        nlog.setBillno(billno);
        nlog.setOpertype(opertype);
        nlog.setMemo(memo);
        nlog.setOpertime(new Date());
        this.log(nlog);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void log(String oper, String opername, String opertype, String memo, BillAbstractHeadBean bh) {
        this.log(bh.getEnt_id(), oper, opername, bh.getBillmoduleid(), bh.getBillno(), opertype, memo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void log(String opertype, String memo, BillAbstractHeadBean bh) {
        String oper = bh.getLastmodby();
        String opername = bh.getLastmodby_name();
        this.log(bh.getEnt_id(), oper, opername, bh.getBillmoduleid(), bh.getBillno(), opertype, memo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void log(ServiceSession session, String oper, String opername, String opertype, String memo, BillAbstractHeadBean bh) {
        if (oper == null || oper.length() == 0) {
            oper = session.getUser_code();
        }
        if (opername == null || opername.length() == 0) {
            opername = "[" + oper + "]" + session.getUser_name();
        }
        this.log(bh.getEnt_id(), oper, opername, bh.getBillmoduleid(), bh.getBillno(), opertype, memo);
    }
}

