/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class CacheUtilsRedisSentinel
extends CacheUtilsRediscached
implements Serializable {
    private JedisSentinelPool jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    private boolean debug = false;
    public Logger logger = Logger.getLogger(CacheUtilsRedisSentinel.class);

    public CacheUtilsRedisSentinel() {
        this(null);
    }

    public CacheUtilsRedisSentinel(String config) {
        this(config, -1);
    }

    public CacheUtilsRedisSentinel(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    private Jedis getJedis() {
        try {
            if (this.jedispool == null) {
                try {
                    this.jedispool = this.CreateJedisPool();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.jedispool.getResource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private synchronized JedisSentinelPool CreateJedisPool() throws FileNotFoundException, IOException {
        if (this.jedispool != null) {
            return this.jedispool;
        }
        if (this.config != null) {
            String[] str_nodes;
            this.logger.info((Object)"Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis((long)this.config.getRedisMaxWait());
            HashSet<String> sentinels = new HashSet<String>();
            for (String str : str_nodes = this.config.getRedisNodes().split(",")) {
                sentinels.add(str);
            }
            this.jedispool = new JedisSentinelPool(this.config.getRedisMaster(), sentinels, (GenericObjectPoolConfig)poolConfig, this.config.getRedisTimeout(), this.config.getRedisPassword(), this.config.getRedisDatabase());
        } else {
            String p;
            String ini = null;
            String ini0 = null;
            if (StringUtils.isEmpty((Object)this.cfgFile)) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini";
                ini0 = p + "/conf/redisCluster.ini";
            } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + this.cfgFile;
                ini0 = p + "/conf" + this.cfgFile;
            } else {
                ini = this.cfgFile;
            }
            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = 0;
            int maxWait = 5000;
            File input = new File(ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
            this.logger.info((Object)("redisCluster.ini path:" + ini));
            if (input.exists()) {
                String[] str_nodes;
                String password_prop;
                String password;
                String smaxWait;
                String stestOnBorrow;
                String sminIdle;
                String smaxIdle;
                String stimeout;
                String smaxActive;
                FileInputStream is = new FileInputStream(input);
                Properties p2 = new Properties();
                p2.load(is);
                ((InputStream)is).close();
                String sNodes = Utils.getEnvValue(p2.getProperty("redis.nodes"));
                if (sNodes != null) {
                    nodes = sNodes.trim();
                }
                if ((smaxActive = p2.getProperty("redis.maxActive")) != null) {
                    maxActive = Integer.parseInt(smaxActive);
                }
                if ((stimeout = p2.getProperty("redis.timeout")) != null) {
                    timeout = Integer.parseInt(stimeout);
                }
                if ((smaxIdle = p2.getProperty("redis.maxIdle")) != null) {
                    maxIdle = Integer.parseInt(smaxIdle);
                }
                if ((sminIdle = p2.getProperty("redis.minIdle")) != null) {
                    minIdle = Integer.parseInt(sminIdle);
                }
                if ((stestOnBorrow = p2.getProperty("redis.testOnBorrow")) != null) {
                    boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
                }
                if ((smaxWait = p2.getProperty("redis.maxWait")) != null) {
                    maxWait = Integer.parseInt(smaxWait);
                }
                if ((password = Utils.getEnvValue(password_prop = p2.getProperty("redis.password"))) != null) {
                    password = password.trim();
                }
                String master = Utils.getEnvValue(p2.getProperty("redis.master"));
                String sdatabase = Utils.getEnvValue(p2.getProperty("redis.database"));
                if (sdatabase != null) {
                    database = Integer.parseInt(sdatabase);
                }
                this.logger.info((Object)("redisSentinel server:" + sNodes));
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                HashSet<String> sentinels = new HashSet<String>();
                for (String str : str_nodes = nodes.split(",")) {
                    sentinels.add(str);
                }
                this.jedispool = new JedisSentinelPool(master, sentinels, (GenericObjectPoolConfig)config, timeout, password, database);
            } else {
                this.logger.warn((Object)"redis.ini not exits!");
                throw new FileNotFoundException();
            }
        }
        return this.jedispool;
    }
}

