/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.util.PrecisionUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public static String formatDateByFormat(Date date, String format) {
        SimpleDateFormat sdfhms = new SimpleDateFormat(format);
        return sdfhms.format(date);
    }

    public static Date gettoday() {
        return DateUtils.trunctoday(new Date());
    }

    public static Date trunctoday(Date d) {
        return DateUtils.truncate((Date)d, (int)5);
    }

    public static long getDaysBetween(Date startDate, Date endDate) {
        return (DateUtils.trunctoday(startDate).getTime() - DateUtils.trunctoday(endDate).getTime()) / 86400000L + 1L;
    }

    public static long getDayOfWeek(Date date) {
        return DateUtils.toCalendar((Date)date).get(7);
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), 0, 1);
        return calendar.getTime();
    }

    public static Date getLastDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(6, 0);
        return calendar.getTime();
    }

    public static String getWeek(Date date) {
        return String.valueOf(DateUtils.getDayOfWeek(date) - 1L);
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static int getQuarterFromMonth(int month) {
        int quarter = 0;
        quarter = month <= 2 ? 1 : (month >= 3 && month <= 5 ? 2 : (month >= 6 && month <= 8 ? 3 : (month >= 9 && month <= 11 ? 4 : 0)));
        return quarter;
    }

    public static int getStartMonthFromQuarter(int quarter) {
        int startMonth = 0;
        switch (quarter) {
            case 1: {
                startMonth = 0;
                break;
            }
            case 2: {
                startMonth = 3;
                break;
            }
            case 3: {
                startMonth = 6;
                break;
            }
            case 4: {
                startMonth = 9;
                break;
            }
        }
        return startMonth;
    }

    public static Date addQuarterStartDay(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int quarter = DateUtils.getQuarterFromMonth(month);
        int nextQuarter = quarter + amount;
        int y = nextQuarter / 4;
        int i = nextQuarter % 4;
        if (nextQuarter == 0) {
            nextQuarter = 4;
            y = -1;
            year += y;
        }
        if (y >= 1 && nextQuarter > 4) {
            nextQuarter = i;
            year += y;
        }
        month = DateUtils.getStartMonthFromQuarter(nextQuarter);
        calendar.set(year, month, 1);
        return calendar.getTime();
    }

    public static String getTodayStr() {
        return sdf.format(DateUtils.gettoday());
    }

    public static String getDateTimeStr(Date date) {
        SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdfhms.format(date);
    }

    public static String getNowStr() {
        return DateUtils.getDateTimeStr(new Date());
    }

    public static Date getFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 1, 0, 0, 0);
        return calendar.getTime();
    }

    public static int getDayCurrentMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int days = calendar.get(5);
        return days;
    }

    public static boolean isLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) + 1);
        return calendar.get(5) == 1;
    }

    public static int[] getDiff(Date start, Date end) {
        SimpleDateFormat sdfmd = new SimpleDateFormat("MMdd");
        SimpleDateFormat sdfy = new SimpleDateFormat("yyyy");
        if ("0228".equals(sdfmd.format(end)) && PrecisionUtils.mod(Integer.parseInt(sdfy.format(end)), 4.0) != 0.0) {
            if ("0229".equals(sdfmd.format(start))) {
                int[] diff = new int[]{(Integer.parseInt(sdfy.format(end)) - Integer.parseInt(sdfy.format(start))) * 12, 0};
                return diff;
            }
            if ("0129".equals(sdfmd.format(start))) {
                int[] diff = new int[]{(Integer.parseInt(sdfy.format(end)) - Integer.parseInt(sdfy.format(start))) * 12 + 1, 0};
                return diff;
            }
            if ("0201".equals(sdfmd.format(start))) {
                int[] diff = new int[]{(Integer.parseInt(sdfy.format(end)) - Integer.parseInt(sdfy.format(start))) * 12 + 1, 0};
                return diff;
            }
            return DateUtils.getDiffBaisc(start, end);
        }
        return DateUtils.getDiffBaisc(start, end);
    }

    public static int[] getDiffBaisc(Date start, Date end) {
        end = DateUtils.addDays((Date)end, (int)1);
        Calendar ca = Calendar.getInstance();
        ca.setTime(start);
        int year_start = ca.get(1);
        int month_start = ca.get(2) + 1;
        int day_start = ca.get(5);
        ca.setTime(end);
        int year_end = ca.get(1);
        int month_end = ca.get(2) + 1;
        int day_end = ca.get(5);
        LocalDate startDate = LocalDate.of(year_start, month_start, day_start);
        LocalDate endDate = LocalDate.of(year_end, month_end, day_end);
        int[] diff = DateUtils.getDiff(startDate, endDate);
        return diff;
    }

    public static int[] getDiff(LocalDate start, LocalDate end) {
        if (!start.isBefore(end)) {
            throw new IllegalArgumentException("Start must not be before end.");
        }
        Period period = Period.between(start, end);
        int years = period.getYears();
        int months = period.getMonths();
        int days = period.getDays();
        return new int[]{years * 12 + months, days};
    }

    public static double betweenMonths(Date endDate, Date startDate) {
        endDate = DateUtils.addDays((Date)endDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int startDayOfMonth = cal.get(5);
        int startMonth = cal.get(2);
        int startYear = cal.get(1);
        cal.setTime(endDate);
        int endDayOfMonth = cal.get(5);
        int endMonth = cal.get(2);
        int endYear = cal.get(1);
        int diffMonths = endMonth - startMonth;
        int diffYears = endYear - startYear;
        int diffDays = endDayOfMonth - startDayOfMonth;
        return (double)(diffYears * 12 + diffMonths) + (double)diffDays / 31.0;
    }

    public static List<String> getDays(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        try {
            Date start = sdf.parse(startTime);
            Date end = sdf.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(sdf.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static int getDaySub(String beginDateStr, String endDateStr) {
        int day = 0;
        try {
            Date beginDate = sdf.parse(beginDateStr);
            Date endDate = sdf.parse(endDateStr);
            day = (int)((endDate.getTime() - beginDate.getTime()) / 86400000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    public static Date getDaysByDate(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static boolean isSameDate(Date date1, Date date2) {
        try {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            boolean isSameYear = cal1.get(1) == cal2.get(1);
            boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
            boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
            return isSameDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static int getMondayPlus() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7);
        if (dayOfWeek == 1) {
            return -6;
        }
        return 2 - dayOfWeek;
    }

    public static String getCurrentMonday() {
        int mondayPlus = DateUtils.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus);
        Date monday = currentDate.getTime();
        String format = sdf.format(monday);
        return format;
    }

    public static String getPreviousSunday() {
        int mondayPlus = DateUtils.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus + 6);
        Date monday = currentDate.getTime();
        String preMonday = sdf.format(monday);
        return preMonday;
    }

    public static Date min(Date d1, Date d2) {
        if (d2 == null) {
            return d1;
        }
        if (d1.compareTo(d2) > 0) {
            return d2;
        }
        return d1;
    }

    public static String getMinMonthDate(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(date));
            calendar.set(5, calendar.getActualMinimum(5));
            return sdf.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMaxMonthDate(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(date));
            calendar.set(5, calendar.getActualMaximum(5));
            return sdf.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date add_month(Date d, int month) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(5, 1);
        c.add(2, month);
        c.add(5, -1);
        return c.getTime();
    }

    public static Date date(Object v) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (v instanceof Date) {
            return sdf.parse(sdf.format((Date)v));
        }
        if (v instanceof Timestamp) {
            return sdf.parse(sdf.format((Timestamp)v));
        }
        return sdf.parse(v.toString());
    }

    public static int getDaysOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        return DateUtils.getDaysOfYear(year);
    }

    public static int getDaysOfYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        return cal.getActualMaximum(6);
    }
}

