/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.autorollback.AutoRollBackService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.RestClientFactory;
import com.efuture.ocp.common.util.RestClientOverWrite;
import com.efuture.ocp.common.util.RestInfoGet;
import com.efuture.ocp.common.util.RestInfoGetFromIniFile;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class RestClientUtils {
    public Logger logger = Logger.getLogger(RestClientUtils.class);
    private static final String BASE_SERVICE = "RestUtils";
    public GenericKeyedObjectPool<Object, Client> pool;
    public RestInfoGet restinfoget;
    public String restinfogetobj = "restinfogetfromenv";
    private String cfgFile;
    private Map<String, Object> clientProperties;
    protected EnterpriseConfigBean ent;
    private boolean isEntLimit;

    public RestClientUtils() {
        this(null);
    }

    public RestClientUtils(String config) {
        this(0, 0L, config);
    }

    public RestClientUtils(Integer poolSize, long maxWait, String config) {
        this(poolSize, false, poolSize, maxWait, config);
    }

    public RestClientUtils(Integer poolSize, boolean entPool, int entMaxPool, long maxWait, String config) {
        GenericKeyedObjectPoolConfig poolcfg = new GenericKeyedObjectPoolConfig();
        if (poolSize > 0 || poolSize == -1) {
            poolcfg.setMaxTotal(poolSize.intValue());
            poolcfg.setMaxTotalPerKey(entMaxPool);
            poolcfg.setMaxIdlePerKey(entMaxPool);
            poolcfg.setMinIdlePerKey(entMaxPool >= 2 ? entMaxPool / 2 : entMaxPool);
            poolcfg.setJmxEnabled(true);
            poolcfg.setJmxNameBase("RestClient");
            poolcfg.setJmxNamePrefix("Pool");
            poolcfg.setTestOnBorrow(true);
            poolcfg.setTestOnReturn(true);
        }
        if (maxWait > 0L) {
            poolcfg.setMaxWaitMillis(maxWait);
        }
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new RestClientFactory(), poolcfg);
        this.isEntLimit = entPool;
        if (config != null && config.startsWith("OBJ:")) {
            this.restinfogetobj = config.substring(4);
        } else {
            this.cfgFile = config;
            if (config != null && !"".equals(config)) {
                this.restinfogetobj = null;
            }
        }
    }

    public static RestClientUtils getRestUtils() {
        return RestClientUtils.getRestUtils(BASE_SERVICE);
    }

    public static RestClientUtils getRestUtils(String obj) {
        return SpringBeanFactory.getBean(obj, RestClientUtils.class);
    }

    public static RestClientUtils getRestUtils(EnterpriseConfigBean ent) {
        return RestClientUtils.getRestUtils(BASE_SERVICE, ent);
    }

    public static RestClientUtils getRestUtils(String obj, EnterpriseConfigBean ent) {
        RestClientUtils restObj = SpringBeanFactory.getBean(obj, RestClientUtils.class);
        restObj.setEnt(ent);
        return restObj;
    }

    public EnterpriseConfigBean getEnt() {
        return this.ent;
    }

    public void setEnt(EnterpriseConfigBean ent) {
        this.ent = ent;
    }

    public String[] getCompressMethods() {
        String str = this.queryServiceURI("compress");
        String[] compressMethods = null;
        if (!StringUtils.isEmpty((Object)str)) {
            compressMethods = str.split("\\|");
        }
        return compressMethods;
    }

    public String getRestinfogetobj() {
        return this.restinfogetobj;
    }

    public void setRestinfogetobj(String restinfogetobj) {
        this.restinfogetobj = restinfogetobj;
    }

    public String getCfgFile() {
        return this.cfgFile;
    }

    public void setCfgFile(String cfgFile) {
        this.cfgFile = cfgFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void initConfig() {
        if (this.restinfoget != null) {
            return;
        }
        if (!StringUtils.isEmpty((Object)this.restinfogetobj)) {
            if (!SpringBeanFactory.containsBean(this.restinfogetobj)) throw new ServiceException("50000", "\u83b7\u53d6\u5bf9\u8c61[{0}]\u9519\u8bef!", this.restinfogetobj);
            this.restinfoget = SpringBeanFactory.getBean(this.restinfogetobj, RestInfoGet.class);
        } else {
            this.restinfoget = !StringUtils.isEmpty((Object)this.cfgFile) && !"globpara".equalsIgnoreCase(this.cfgFile) ? (SpringBeanFactory.containsBean("restinfogetfrominifile") ? SpringBeanFactory.getBean("restinfogetfrominifile", RestInfoGet.class) : new RestInfoGetFromIniFile()) : (!StringUtils.isEmpty((Object)this.cfgFile) && "globpara".equalsIgnoreCase(this.cfgFile) ? (SpringBeanFactory.containsBean("restinfogetfromglobpara") ? SpringBeanFactory.getBean("restinfogetfromglobpara", RestInfoGet.class) : new RestInfoGetFromIniFile()) : (SpringBeanFactory.containsBean("restinfogetfrominifile") ? SpringBeanFactory.getBean("restinfogetfrominifile", RestInfoGet.class) : new RestInfoGetFromIniFile()));
        }
        this.restinfoget.init(this.cfgFile);
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProp) {
        this.clientProperties = clientProp;
    }

    public String queryServiceURI(long ent_id, String method) {
        if (this.restinfoget == null) {
            this.initConfig();
        }
        return this.restinfoget.queryServiceURI(ent_id, method);
    }

    public String queryServiceURI(String method) {
        if (this.restinfoget == null) {
            this.initConfig();
        }
        return this.restinfoget.queryServiceURI(method);
    }

    public String queryServiceURIbymkt(String method, String mktid) throws Exception {
        if (this.restinfoget == null) {
            this.initConfig();
        }
        return this.restinfoget.queryServiceURIbymkt(method, mktid);
    }

    public Object sendRequest(Object session, String method, Object param, requestCallback callback) throws Exception {
        return this.sendRequest(session, method, param, callback, null);
    }

    private void initClientProperties(Client client) {
        if (this.clientProperties == null) {
            return;
        }
        for (String key : this.clientProperties.keySet()) {
            if ("followRedirects".equalsIgnoreCase(key)) {
                client.setFollowRedirects(Boolean.valueOf("true".equalsIgnoreCase(this.clientProperties.get(key).toString())));
                continue;
            }
            if ("readTimeout".equalsIgnoreCase(key)) {
                client.setReadTimeout(Integer.valueOf(Integer.parseInt(this.clientProperties.get(key).toString())));
                continue;
            }
            if ("connectTimeout".equalsIgnoreCase(key)) {
                client.setConnectTimeout(Integer.valueOf(Integer.parseInt(this.clientProperties.get(key).toString())));
                continue;
            }
            if (!"chunkedEncodingSize".equalsIgnoreCase(key)) continue;
            client.setChunkedEncodingSize(Integer.valueOf(Integer.parseInt(this.clientProperties.get(key).toString())));
        }
    }

    public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("method", method);
        map.put("url", url);
        map.put("param", param);
        if (method.toLowerCase().startsWith("http")) {
            return map;
        }
        String OverWriteObj = method + ".overwrite";
        if (SpringBeanFactory.containsBean(OverWriteObj)) {
            RestClientOverWrite row = SpringBeanFactory.getBean(OverWriteObj, RestClientOverWrite.class);
            if (row.isCanUse()) {
                map = row.doOverWrite(session, method, url, param);
            }
            return map;
        }
        return map;
    }

    /*
     * Loose catch block
     */
    public Object sendRequest(Object session, String method, Object param, requestCallback callback, String traceprex) throws Exception {
        Object object;
        String entIdKey;
        long start_time;
        String url;
        Client client;
        block35: {
            client = null;
            url = null;
            start_time = 0L;
            long borro_time = 0L;
            ServiceSession ss = null;
            if (session instanceof ServiceSession) {
                ss = (ServiceSession)session;
            }
            if (session instanceof Long) {
                ss = new ServiceSession();
                ss.setEnt_id((Long)session);
            }
            entIdKey = "General";
            if (ss != null && this.isEntLimit) {
                entIdKey = ss.getEnt_id() + "";
            }
            if (method.toLowerCase().startsWith("http")) {
                url = method;
            } else {
                url = this.queryServiceURI(ss.getEnt_id(), method);
                if (StringUtils.isEmpty((Object)url)) {
                    throw new Exception("can't find method service url:" + method);
                }
            }
            Map<String, Object> map = this.doOverWrite(session, method, url, param);
            method = map.get("method").toString();
            url = map.get("url").toString();
            param = map.get("param");
            if (url.indexOf("{ent_id}") > 0 && ss != null) {
                url = url.replace("{ent_id}", String.valueOf(ss.getEnt_id()));
            }
            if (url.indexOf("{user_id}") > 0 && ss != null) {
                url = url.replace("{user_id}", String.valueOf(ss.getUser_id()));
            }
            if (url.indexOf("{user_code}") > 0 && ss != null) {
                url = url.replace("{user_code}", ss.getUser_code());
            }
            if (url.indexOf("{user_name}") > 0 && ss != null) {
                url = url.replace("{user_name}", ss.getUser_name());
            }
            if (url.indexOf("{locale}") > 0 && ss != null) {
                url = url.replace("{locale}", ss.getLocale());
            }
            if (url.indexOf("{deptcode}") > 0 && ss != null) {
                url = url.replace("{deptcode}", ss.getDeptcode());
            }
            if (url.indexOf("{token}") > 0 && ss != null & ss.getToken() != null) {
                url = url.replace("{token}", ss.getToken());
            }
            if (url.indexOf("{postid}") > 0 && ss != null && ss.getPostid() != null) {
                url = url.replace("{postid}", ss.getPostid());
            }
            if (!traceprex.equals("notrace")) {
                url = this.addlogkey(url, traceprex);
            }
            url = Utils.getEnvValue(url);
            if (ServiceVersion.getInstance().isLogstatus()) {
                start_time = System.currentTimeMillis();
            }
            client = (Client)this.pool.borrowObject((Object)entIdKey);
            this.initClientProperties(client);
            int numActive = this.pool.getNumActive((Object)entIdKey);
            int numIdle = this.pool.getNumIdle((Object)entIdKey);
            int maxTotalPerKey = this.pool.getMaxTotalPerKey();
            ServiceLogs.debuglog("getPool", String.format("entKey:%s, \u5df2\u4f7f\u7528Pool\u5bf9\u8c61\u6570:%d, \u5f53\u524d\u7a7a\u95f2Pool\u5bf9\u8c61\u6570:%d, \u6700\u5927\u53ef\u7528Pool\u5bf9\u8c61\u6570\uff1a%d", entIdKey, numActive, numIdle, maxTotalPerKey), 0L);
            if (ServiceVersion.getInstance().isLogstatus()) {
                borro_time = System.currentTimeMillis();
            }
            if ("show".equalsIgnoreCase(ss.getDebug_status())) {
                String callData = "method:" + method + ", url:" + url + ", postData:" + param.toString();
                throw new ServiceException("10000", callData, new Object[0]);
            }
            this.addNeedRollbackOperation(ss, method, url, param);
            ServiceLogs.logCallStart(url, method, param.toString());
            object = this.onSend(callback, method, url, client, param);
            if (client == null) break block35;
            try {
                this.pool.returnObject((Object)entIdKey, (Object)client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logCallSuccess(url, method, start_time);
        }
        return object;
        catch (Exception ex) {
            block36: {
                Object object2;
                block37: {
                    try {
                        ex.printStackTrace();
                        Throwable e = ex;
                        if (ex instanceof ClientHandlerException) {
                            e = ex.getCause();
                        }
                        ServiceLogs.logCallError(url, method, "99", ex.getMessage(), start_time);
                        if (!(e instanceof SocketException) || !"Connection reset".equalsIgnoreCase(e.getMessage())) break block36;
                        if (client != null) {
                            this.pool.invalidateObject((Object)entIdKey, client);
                        }
                        client = (Client)this.pool.borrowObject((Object)entIdKey);
                        this.initClientProperties(client);
                        object2 = this.onSend(callback, method, url, client, param);
                        if (client == null) break block37;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                this.pool.returnObject((Object)entIdKey, client);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (ServiceVersion.getInstance().isLogstatus()) {
                            ServiceLogs.logCallSuccess(url, method, start_time);
                        }
                        throw throwable;
                    }
                    try {
                        this.pool.returnObject((Object)entIdKey, (Object)client);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ServiceVersion.getInstance().isLogstatus()) {
                    ServiceLogs.logCallSuccess(url, method, start_time);
                }
                return object2;
            }
            throw ex;
        }
    }

    private String addlogkey(String url, String traceprex) {
        if ("notrace".equalsIgnoreCase(traceprex)) {
            return url;
        }
        ServiceSession session = ServiceRestReflect.getLocale().get();
        if (session != null) {
            if (session.getRootkey() != null) {
                url = url + "&rootkey=" + session.getRootkey();
            }
            if (session.getLogkey() != null) {
                url = url + "&parentkey=" + session.getLogkey();
            }
        }
        return url;
    }

    private void addNeedRollbackOperation(ServiceSession ss, String method, String url, Object param) {
        if (AutoRollBackService.IsEnable()) {
            AutoRollBackService.addRestOperation(ss, url, method, param);
        }
    }

    /*
     * Loose catch block
     */
    public Object sendRequestbymkt(Object session, String method, String mktid, Object param, requestCallback callback, String traceprex) throws Exception {
        Object object;
        String entIdKey;
        long borro_time;
        long start_time;
        String url;
        Client client;
        block32: {
            client = null;
            url = null;
            start_time = 0L;
            borro_time = 0L;
            ServiceSession ss = null;
            if (session instanceof ServiceSession) {
                ss = (ServiceSession)session;
            }
            if (session instanceof Long) {
                ss = new ServiceSession();
                ss.setEnt_id((Long)session);
            }
            entIdKey = "General";
            if (ss != null && this.isEntLimit) {
                entIdKey = ss.getEnt_id() + "";
            }
            if (method.toLowerCase().startsWith("http")) {
                url = method;
            } else {
                url = this.queryServiceURIbymkt(method, mktid);
                if (StringUtils.isEmpty((Object)url)) {
                    throw new Exception("can't find method service url");
                }
            }
            if (url.indexOf("{ent_id}") > 0 && ss != null) {
                url = url.replace("{ent_id}", String.valueOf(ss.getEnt_id()));
            }
            if (url.indexOf("{user_id}") > 0 && ss != null) {
                url = url.replace("{user_id}", String.valueOf(ss.getUser_id()));
            }
            if (url.indexOf("{user_code}") > 0 && ss != null) {
                url = url.replace("{user_code}", ss.getUser_code());
            }
            if (url.indexOf("{user_name}") > 0 && ss != null) {
                url = url.replace("{user_name}", ss.getUser_name());
            }
            if (url.indexOf("{locale}") > 0 && ss != null) {
                url = url.replace("{locale}", ss.getLocale());
            }
            if (url.indexOf("{deptcode}") > 0 && ss != null) {
                url = url.replace("{deptcode}", ss.getDeptcode());
            }
            if (!traceprex.equals("notrace")) {
                url = this.addlogkey(url, traceprex);
            }
            url = Utils.getEnvValue(url);
            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                start_time = System.currentTimeMillis();
            }
            client = (Client)this.pool.borrowObject((Object)entIdKey);
            this.initClientProperties(client);
            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                borro_time = System.currentTimeMillis();
            }
            object = this.onSend(callback, method, url, client, param);
            if (client == null) break block32;
            try {
                this.pool.returnObject((Object)entIdKey, (Object)client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
            StringBuffer sb = new StringBuffer();
            sb.append("[" + traceprex + "]: ");
            sb.append(method + " , ");
            sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
            sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
            sb.append("REQUEST: " + param);
            this.logger.info((Object)sb.toString());
        }
        return object;
        catch (Exception ex) {
            block33: {
                Object object2;
                block34: {
                    try {
                        Throwable e = ex;
                        if (ex instanceof ClientHandlerException) {
                            e = ex.getCause();
                        }
                        if (!(e instanceof SocketException) || !"Connection reset".equalsIgnoreCase(e.getMessage())) break block33;
                        StringBuffer sb2 = new StringBuffer();
                        sb2.append("[" + ex.getMessage() + "]: ");
                        sb2.append(method + " , ");
                        sb2.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                        sb2.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                        this.logger.info((Object)sb2.toString());
                        if (client != null) {
                            this.pool.invalidateObject((Object)entIdKey, (Object)client);
                        }
                        client = (Client)this.pool.borrowObject((Object)entIdKey);
                        this.initClientProperties(client);
                        object2 = this.onSend(callback, method, url, client, param);
                        if (client == null) break block34;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                this.pool.returnObject((Object)entIdKey, client);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                            StringBuffer sb3 = new StringBuffer();
                            sb3.append("[" + traceprex + "]: ");
                            sb3.append(method + " , ");
                            sb3.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                            sb3.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                            sb3.append("REQUEST: " + param);
                            this.logger.info((Object)sb3.toString());
                        }
                        throw throwable;
                    }
                    try {
                        this.pool.returnObject((Object)entIdKey, (Object)client);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                    StringBuffer sb4 = new StringBuffer();
                    sb4.append("[" + traceprex + "]: ");
                    sb4.append(method + " , ");
                    sb4.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                    sb4.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                    sb4.append("REQUEST: " + param);
                    this.logger.info((Object)sb4.toString());
                }
                return object2;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object onSend(requestCallback call, String method, String url, Client client, Object param) throws Exception {
        Object resp;
        boolean compress = false;
        String[] compressMethods = this.getCompressMethods();
        if (compressMethods != null && call instanceof defaultRequestCallback) {
            compress = compressMethods.length == 1 && "*".equals(compressMethods[0]) ? true : Utils.stringArrayContainsKey(compressMethods, method, true);
        }
        if (compress) {
            ByteArrayOutputStream originalContent = new ByteArrayOutputStream();
            originalContent.write(param.toString().getBytes("UTF-8"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
            originalContent.writeTo(gzipOut);
            gzipOut.finish();
            param = baos.toByteArray();
        }
        try {
            resp = call.onSend(url, client, param);
        }
        catch (Exception ex) {
            throw ServiceException.newGroupServiceException("network", "40001", ex.getMessage(), new Object[0]);
        }
        if (compress) {
            ByteArrayInputStream stream = new ByteArrayInputStream((byte[])resp);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            GZIPInputStream gzip = null;
            try {
                int n = 0;
                gzip = new GZIPInputStream(stream);
                while ((n = gzip.read(b)) >= 0) {
                    out.write(b, 0, n);
                }
            }
            finally {
                if (gzip != null) {
                    try {
                        gzip.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            resp = out.toString("UTF-8");
        }
        return resp;
    }

    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception {
        return this.sendRequest(session, method, param, "");
    }

    public ServiceResponse sendRequestbymkt(Object session, String method, String mktid, Object param) throws Exception {
        return this.sendRequestbymkt(session, method, mktid, param, "");
    }

    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param, new defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = JSON.parseObject((String)((String)result));
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
        }
        if (response == null) {
            throw ServiceException.newGroupServiceException("service", "50000", (String)result, new Object[0]);
        }
        if (!"0".equals(response.getReturncode())) {
            throw ServiceException.newGroupServiceException("service", response.getReturncode(), response.getData().toString(), new Object[0]);
        }
        return response;
    }

    public ServiceResponse sendRequestbymkt(Object session, String method, String mktid, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequestbymkt(session, method, mktid, param, new defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = JSON.parseObject((String)((String)result));
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
        }
        if (response == null) {
            throw ServiceException.newGroupServiceException("service", "50000", (String)result, new Object[0]);
        }
        if (!"0".equals(response.getReturncode())) {
            throw ServiceException.newGroupServiceException("service", response.getReturncode(), response.getData().toString(), new Object[0]);
        }
        return response;
    }

    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, EnterpriseConfigBean ent, JSONObject param, String dataNode) throws Exception {
        return ServiceResponse.buildSuccess(null);
    }

    public ServiceResponse sendRequest(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes, JSONArray valDatas, boolean isArray) throws Exception {
        return ServiceResponse.buildSuccess(null);
    }

    public ServiceResponse sendRequest(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes, JSONArray valDatas) throws Exception {
        return ServiceResponse.buildSuccess(null);
    }

    public class defaultRequestCallback
    implements requestCallback {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception {
            WebResource webResource = client.resource(url);
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            Object resp = null;
            resp = param instanceof byte[] ? webResource.queryParams((MultivaluedMap)queryParams).header("Content-Encoding", (Object)"gzip").post(param.getClass(), param) : webResource.queryParams((MultivaluedMap)queryParams).header("Content-Type", (Object)"application/json;charset=UTF-8").post(String.class, param);
            return resp;
        }
    }

    public static interface requestCallback {
        public Object onSend(String var1, Client var2, Object var3) throws Exception;
    }
}

