package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.RestClientUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.ws.rs.core.MultivaluedMap;
@Lazy(true)
@Component("RestClientUtils_SMG")
public class RestClientUtils_SMG extends RestClientUtils {

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param,
                new RestClientUtils_SMG.defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            try
            {
                JSONObject json = JSON.parseObject((String) result);
                response = ServiceResponse.buildSuccess(json);
            }
            catch(Exception ex)
            {
                throw new ServiceException( ResponseCode.EXCEPTION, "Result data error:" + result);
            }
        }
        else
        {
            throw new ServiceException( ResponseCode.EXCEPTION, "Result is null!");
        }
        return response;
    }
    
    public class defaultRequestCallback implements requestCallback {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception {
            WebResource webResource = client.resource(url);

            MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();

            // 判断参数为字节则标识为压缩传输
            Object resp = null;
            if (param instanceof byte[])
                resp = webResource.queryParams(queryParams).header("Content-Encoding", "gzip").post(param.getClass(),
                        param);
            else
                resp = webResource.queryParams(queryParams).header("Content-Type", "application/json").post(String.class, param);
            return resp;
        }
    }
}
