package com.efuture.ocp.common.slice.filter;

import com.efuture.ocp.common.util.DataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.util.Set;

public class CollectionSliceWrapper extends CollectionSQLWrapper
{
    public static final Logger logger = LoggerFactory.getLogger(CollectionSliceWrapper.class);

    protected boolean isWrapper(String sqlSelect, String organizationCode, String slice)
    {
        String message = "";
        String[] sqlKeys;
        if (getOrganizationMap().containsKey(organizationCode) || !StringUtils.isEmpty( slice )) {
            message = String.format("组织机构【%1$s】存在分片定义", new Object[] { DataUtils.nvl(organizationCode, slice) });
            sqlKeys = sqlSelect.split("[\\s()]+");
            Set<String> collectionSet = getCollectionMap().keySet();
            for (String collectionName : collectionSet) {
                for (String key : sqlKeys) {
                    if (key.toLowerCase().equals(collectionName)) {
                        //logger.info("--->{},匹配表:{}", message, collectionName);
                        sliceFilterLog("--->{},匹配表:{}", message, collectionName );
                        return true;
                    }
                }
            }
        }

        message = String.format("--->组织机构【%1$s】不存在分片定义或者没有需要分片的表", new Object[] { DataUtils.nvl(organizationCode, slice) });
        //logger.info(message);
        sliceFilterLog(message);
        return false;
    }

    protected String getPartionWhere(String collectionName, String collectionAlias, String organizationCode, String sliceKey) {
        String response = "";

        String tableName = collectionName.toLowerCase();

        if (getCollectionMap().keySet().contains(tableName)) {
            String fieldName = (String)getCollectionMap().get(tableName);
            String partionKey = null;
            if (getOrganizationMap().containsKey(organizationCode))
            {
                partionKey = (String)getOrganizationMap().get(organizationCode);
            }
            else if (!StringUtils.isEmpty( sliceKey ))
            {
                partionKey = sliceKey;
            }

            if (!StringUtils.isEmpty( partionKey ))
            {
                if (!StringUtils.isEmpty(collectionAlias))
                {
                    response = String.format("%1$s.%2$s = '%3$s'", new Object[] { collectionAlias, fieldName, partionKey });
                }
                else {
                    response = String.format("%1$s = '%2$s'", new Object[] { fieldName, partionKey });
                }
            }
        }

        return response;
    }
}