/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	HashMapCase.java
 * Author:		亮
 * Date:		2014-8-13 上午11:03:34
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import org.apache.ibatis.type.Alias;

/**
 * @author		亮
 * @description
 *
 */
@Alias(value = "MapCase")
public class HashMapCase<K, V> extends HashMap<K, V> implements Map<K, V>, Cloneable, Serializable
{
    private static final long serialVersionUID = 362498820763181265L;

    public HashMapCase(int paramInt, float paramFloat)
    {
        super(paramInt, paramFloat);
    }

    public HashMapCase(int paramInt)
    {
        super(paramInt);
    }

    public HashMapCase()
    {
        super();
    }

    public HashMapCase(Map<? extends K, ? extends V> paramMap)
    {
        super(paramMap);
    }

    public V get(Object paramObject)
    {
        return super.get(paramObject.toString().toLowerCase());
    }

    public boolean containsKey(Object paramObject)
    {
        return super.containsKey(paramObject.toString().toLowerCase());
    }

    @SuppressWarnings("unchecked")
    public V put(K paramK, V paramV)
    {
        // BigDecimal以字符串进行保存,避免在JSON转换时丢失精度
        if (paramV instanceof BigDecimal) {
            return super.put((K) paramK.toString().toLowerCase(), (V)((BigDecimal)paramV).toString());
        }
        else {
            return super.put((K) paramK.toString().toLowerCase(), paramV);
        }
    }

    public V remove(Object paramObject)
    {
        return super.remove(paramObject.toString().toLowerCase());
    }
}
