package com.efuture.ocp.common.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.efuture.ocp.common.cache.CacheUtils;


@Target({ ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AutoCache
{
    // 缓存Key前缀

String Service() default "OCP";
    // 缓存级别，内存缓存 OR 外部缓存

String CacheLevel() default CacheUtils.CacheLevel.Cache;

int KeyArgIndex() default -1;

String KeyName() default "";

String ExpKeys() default "";

int TimeOut() default CacheUtils.CacheTimeOut.Day;

boolean Readable() default false;
}
