package com.efuture.ocp.common.billservice;



import java.util.Date;

import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.BillOperLogBean;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.SpringBeanFactory;

public class BillOperLogSrvImpl extends BasicComponent implements BillOperLogService
{
	public BillOperLogSrvImpl() {
		setStorage(null);
	}
    public static BillOperLogService getLog(){
        if(SpringBeanFactory.containsBean("BillOperLogSrv")){
            return SpringBeanFactory.getBean("BillOperLogSrv",BillOperLogService.class) ;
        }
        else{
            return null;
        }
    }
    private String storage = null;
    
    public String getStorage() {
		return storage;
	}
	public void setStorage(String storage) {
		if (storage == null || storage.trim().length() == 0) {
			storage = PortalStorageOperation;
		} else {
			storage = storage.trim();
		}
		this.storage = storage;
	}
	@Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void log(BillOperLogBean log)
    {
    	getStorageOperationConfig(storage).insert(log);
    }
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void log(long ent_id,String oper,String opername,String billmoduleid, String billno, String opertype, String memo)
    {
        BillOperLogBean nlog = new BillOperLogBean();
        nlog.setEnt_id(ent_id);
        nlog.setOper(oper);
        nlog.setOpername(opername);
        nlog.setBillmoduleid(billmoduleid);
        nlog.setBillno(billno);
        nlog.setOpertype(opertype);
        nlog.setMemo(memo);
        nlog.setOpertime(new Date());
        log(nlog);
    }
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void log(String oper,String opername,String opertype, String memo,BillAbstractHeadBean bh)
    {
        log(bh.getEnt_id(),oper,opername,bh.getBillmoduleid(),bh.getBillno(),opertype,memo);
    }
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void log(String opertype, String memo,BillAbstractHeadBean bh){
        String oper ,opername;
        oper = bh.getLastmodby();
        opername = bh.getLastmodby_name();
//        UserTokenInfo uinfo=        UserDataRangeSrv.getlocaluser();
//        if(uinfo != null){
//            oper = uinfo.getUserid();
//            opername = uinfo.getUsername();
//        }
//        else
//        {
//            oper = "未知";
//            opername ="未知";
//        }
        log(bh.getEnt_id(),oper,opername,bh.getBillmoduleid(),bh.getBillno(),opertype,memo);
    }
    
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void log(ServiceSession session,String oper,String opername,String opertype, String memo,BillAbstractHeadBean bh)
    {
        if (oper == null || oper.length() == 0) oper = session.getUser_code();
        if (opername == null || opername.length() == 0) opername = "[" + oper + "]" + session.getUser_name();
        log(bh.getEnt_id(),oper,opername,bh.getBillmoduleid(),bh.getBillno(),opertype,memo);
    }

}
