package com.efuture.ocp.common.bpm;

import java.util.Map;

import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;


public class BpmService
{

    interface bpmservice
    {
        final String APPROVAL = "mss.bpm.approval";// 审批
        final String REJECT = "mss.bpm.reject";// 驳回
        final String SUBMIT = "mss.bpm.submit";// 提交
        final String REPEAL = "mss.bpm.repeal"; // 撤销
        final String GETTASK = "mss.bpm.getusertask"; // 查询任务
        final String GETSUBMITTER = "mss.bpm.getSubmitter"; // 获取提交人
        final String AUDITLOG = "mss.bpm.sheetAuditLog"; // 查询审批日志
        final String GETUSERLIST = "mss.bpm.getuserlist"; // 查询人员列表
        final String GETGROUPLIST = "mss.bpm.getusergrouplist"; // 查询人员分组列表
        final String GETPROCESSLIST = "mss.bpm.getprocesslist"; // 查询人员分组列表
        final String ADDTASK = "mss.bpm.addTask"; // 审批过程加签
    }

    public static BpmService getBpmService()
    {
        return SpringBeanFactory.getBean("BpmService", BpmService.class);
    }
    //提交
    public ServiceResponse submit(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.SUBMIT);
    }
    //驳回
    public ServiceResponse reject(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.REJECT);
    }
    //审批
    public ServiceResponse approval(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.APPROVAL);
    }
    //撤销
    public ServiceResponse repeal(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.REPEAL);
    }
    //查询任务
    public ServiceResponse gettask(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.GETTASK);
    }
    // 查询审批日志
    public ServiceResponse auditlog(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.AUDITLOG);
    }

    // 查询人员列表
    public ServiceResponse getuserlist(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.GETUSERLIST);
    }

    // 查询分组列表
    public ServiceResponse getgrouplist(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.GETGROUPLIST);
    }

    // 审批加签
    public ServiceResponse addtask(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.ADDTASK);
    }

    // 获取审批流提交人
    public ServiceResponse getsubmitter(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.GETSUBMITTER);
    }

    // 移动端审批流程列表
    public ServiceResponse processList(Map<String, Object> bpmdata) throws Exception
    {
        return callBpmService(bpmdata, bpmservice.GETPROCESSLIST);
    }
    public ServiceResponse callBpmService(Map<String, Object> bpmdata, String service) throws Exception
    {
        ServiceSession session = new ServiceSession();
        String bpmpara = JSON.toJSONString(Utils.toNormalJSONObject(bpmdata));
        String processdefkey = StringUtils.isEmpty(bpmdata.get("processdefkey")) ? "" : bpmdata.get("processdefkey").toString();
        String url ;
        url = RestClientUtils.getRestUtils().queryServiceURI(service + "." + processdefkey);

        if (StringUtils.isEmpty(url)) {
            url =  service;
        }

        return RestClientUtils.getRestUtils().sendRequest(session, url, bpmpara);

    }

}
