/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	MasterSlaveComponent.java
 * Author:		亮
 * Date:		2015-7-8 下午6:02:21
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.BeanConstant;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;


/**
 * @author 亮
 * @description
 */
public class MasterSlaveComponent<T extends AbstractEntityBean> extends BasicComponentService<T>
    implements MasterSlaveIntf
{


    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    @SuppressWarnings("unchecked")
    @Transactional(propagation = Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String... uniques) throws Exception
    {
        // 保存主表
        long masterid = super.doAdd(bean, id, uniques);
        // 得到从表关联字段
        Field fld = getMasterSlaveField(bean.getClass());

        if (fld == null) {
            return masterid;
        }

        String masterkey = (String) fld.get(null);

        if (StringUtils.isEmpty(masterkey)) {
            return masterid;
        }

        Object masterval = AbstractEntityBean.fetchDeclaredField(bean.getClass(), masterkey).get(bean);
        // 新增从表
        Map<String, Class<?>> flds = getSlaveFields(bean.getClass());

        for (String key : flds.keySet()) {
            fld = bean.fetchDeclaredField(key);
            fld.setAccessible(true);
            Object obj = fld.get(bean);

            if (obj != null) {
                Class<?> clazz = flds.get(key);
                String slavekey = (String) getMasterSlaveField(clazz).get(null);
                List<AbstractEntityBean> detlist = (List<AbstractEntityBean>) obj;

                for (AbstractEntityBean slaveBean : detlist) {
                    Object detkey = slaveBean.fetchDeclaredField(getIdKey(clazz)).get(slaveBean);

                    if (detkey != null && !"0".equals(detkey.toString())) {
                        this.getLogger().info("数据行状态不正确:" + detkey.toString());
                        continue;
                    }

                    slaveBean.fetchDeclaredField(getIdKey(clazz)).set(slaveBean, 0);
                    slaveBean.fetchDeclaredField(slavekey).set(slaveBean, masterval);
                    slaveBean.initInsertMember(bean);
                    super.doAdd(slaveBean, getIdKey(clazz), getUniqueKeys(clazz));
                }
            }
        }

        return masterid;
    }

    // doUpate转对象后无法确定子表需要更新的字段
    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception
    {
        // 更新主表前
        jsonarray = beforeMasterSavebatch(session, jsonarray);
        // 更新主表
        JSONArray returnarray = super.doSave(session, jsonarray);
        // 更新主表后
        afterMasterSavebatch(session, jsonarray);
        // 得到从表关联字段
        Field fld = getMasterSlaveField(getBeanClass());

        if (fld == null) {
            return returnarray;
        }

        String masterkey = (String) fld.get(null);

        if (StringUtils.isEmpty(masterkey)) {
            return returnarray;
        }

        // 更新主表时对从表进行增删改
        String flag = "flag";
        Map<String, Class<?>> flds = getSlaveFields(getBeanClass());

        for (int i = 0; i < jsonarray.size(); i++) {
            JSONObject json = jsonarray.getJSONObject(i);

            if (!"U".equalsIgnoreCase(json.getString(flag))) {
                continue;
            }

            for (String key : flds.keySet()) {
                if (!json.containsKey(key)) {
                    continue;
                }

                JSONArray slaveArray = json.getJSONArray(key);
                //筛一遍flag，避免下面flag排序报空指针错误
                slaveArray.removeIf(o -> !((JSONObject) o).containsKey(flag));

                //按flag排序，先执行删除再修改，避免唯一键冲突
                slaveArray.sort(Comparator.comparing(obj -> ((JSONObject) obj).getString("flag")));

                for (int j = 0; j < slaveArray.size(); j++) {
                    JSONObject slavejson = slaveArray.getJSONObject(j);

                    //原来flag不存在也是未处理的。。。上面直接删掉了这种数据
                    if (!slavejson.containsKey(flag)) {
                        continue;
                    }

                    Class<?> clazz = flds.get(key);
                    String slavekey = (String) getMasterSlaveField(clazz).get(null);
                    AbstractEntityBean slaveBean = (AbstractEntityBean) StorageUtils.parseBeanObject(slavejson, clazz);
                    slaveBean.fetchDeclaredField(slavekey).set(slaveBean, json.get(masterkey));

                    if ("I".equalsIgnoreCase(slavejson.getString(flag))) {
                        // 设置子表ID为0,重新生成
                        AbstractEntityBean.fetchDeclaredField(clazz, getIdKey(clazz)).set(slaveBean, 0);
                        slaveBean.initInsertMember(session);
                        super.doAdd(slaveBean, getIdKey(clazz), getUniqueKeys(clazz));
                    }
                    else if ("U".equalsIgnoreCase(slavejson.getString(flag))) {
                        slaveBean.initUpdateMember(session);
                        super.doUpdate(slaveBean, slavejson.keySet(), getIdKey(clazz), getUniqueKeys(clazz));
                    }
                    else if ("D".equalsIgnoreCase(slavejson.getString(flag))) {
                        slaveBean.initUpdateMember(session);
                        doDeleteBefore(slaveBean, session);
                        super.doDelete(slaveBean, getIdKey(clazz));
                    }
                }
            }
        }

        return returnarray;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public Object doDelete(AbstractEntityBean bean, String id, String... keys) throws Exception
    {
        // 得到主表关联字段
        Field fld = getMasterSlaveField(bean.getClass());

        if (fld == null) {
            return super.doDelete(bean, id, keys);
        }

        String masterkey = (String) fld.get(null);

        if (StringUtils.isEmpty(masterkey)) {
            return super.doDelete(bean, id, keys);
        }

        Object masterval = AbstractEntityBean.fetchDeclaredField(bean.getClass(), masterkey).get(bean);

        if (StringUtils.isEmpty(masterval))
            throw new ServiceException(ResponseCode.Exception.SPECDATA_IS_EMPTY, "{0} {1} is empty",
                                       bean.fetchAnnotationTableName(), masterkey);

        // 得到从表集合
        FMybatisTemplate storage = null;

        try {
            // 得到数据源
            storage = getStorageOperations(FMybatisTemplate.class);
            Map<String, Class<?>> flds = getSlaveFields(bean.getClass());

            for (String key : flds.keySet()) {
                Class<?> clazz = flds.get(key);
                String slavekey = (String) getMasterSlaveField(clazz).get(null);
                // 删除从表
                Criteria criteria = Criteria.where("ent_id").is(bean.getEnt_id()).and(slavekey).is(masterval);
                Query query = new Query(criteria);
                storage.delete(query, clazz);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }

        // 删除主表
        Object obj = super.doDelete(bean, id, keys);
        return obj;
    }

    private void formatSlaveCondition(Object ent_id, JSONObject jsonparam, Class<?> objClass, String masterkey, String qkey) throws Exception
    {
        String[] ss = qkey.split(":");
        String slvtable = ss[0];
        String slvfield = ss[1];
        //根据子表tablename来反射找到对应的bean，已经bean对应的定义的关联字段
        String slvkey = getSalveKey(slvtable, objClass);
        // 子表条件
        StringBuffer sb = new StringBuffer();
        sb.append("(select " + slvkey + " from " + slvtable + " where ent_id = " + ent_id
                  + " and " + slvkey + " = " + AbstractEntityBean.fetchAnnotationTableName(objClass) + "."
                  + masterkey);
        Object slvobj = jsonparam.get(qkey);

        if (slvobj instanceof JSONObject) {
            JSONObject jo = ((JSONObject) slvobj);

            for (String s : jo.keySet()) {
                String op = convertOperator(s);
                sb.append(" and " + slvfield);
                sb.append(" " + op + " ");

                if (op.equalsIgnoreCase("in") || op.equalsIgnoreCase("not in")) {
                    sb.append("(");
                    Object o = jo.get(s);

                    if (o instanceof JSONArray) {
                        JSONArray array = (JSONArray) o;

                        for (int i = 0; i < array.size(); i++) {
                            if (array.get(i) instanceof String && !((String) array.get(i)).startsWith("'")) {
                                sb.append("'" + array.get(i) + "',");
                            }
                            else {
                                sb.append(array.get(i) + ",");
                            }
                        }
                    }
                    else if (o instanceof String) {
                        String[] os = ((String) o).split(",");

                        for (String sk : os) {
                            if (!sk.startsWith("'")) {
                                sb.append("'" + sk + "',");
                            }
                            else {
                                sb.append(sk + ",");
                            }
                        }
                    }
                    else {
                        sb.append(o + ",");
                    }

                    sb.setCharAt(sb.length() - 1, ')');
                }
                else {
                    Object o = jo.get(s);

                    if (o instanceof String && !((String) o).startsWith("'")) {
                        sb.append("'" + o + "'");
                    }
                    else {
                        sb.append(o);
                    }
                }
            }
        }
        else if (slvobj instanceof JSONArray) {
            JSONArray array = (JSONArray) slvobj;
            sb.append(" and " + slvfield + " in (");

            for (int i = 0; i < array.size(); i++) {
                Object o = array.get(i);

                if (o instanceof String && !((String) o).startsWith("'")) {
                    sb.append("'" + o + "',");
                }
                else {
                    sb.append(o + ",");
                }
            }

            sb.setCharAt(sb.length() - 1, ')');
        }
        else {
            sb.append(" and " + slvfield);

            if (slvobj instanceof String && !((String) slvobj).startsWith("'")) {
                sb.append(" = '" + slvobj + "'");
            }
            else {
                sb.append(" = " + slvobj);
            }
        }

        sb.append(")");
        // 子表查询条件
        jsonparam.remove(qkey);
        String instr = sb.toString();

        if (!jsonparam.containsKey(masterkey)) {
            JSONObject json = new JSONObject();
            json.put("$in", instr);
            jsonparam.put(masterkey, json);
        }
        else {
            Object obj = jsonparam.get(masterkey);

            if (obj instanceof JSONObject) {
                JSONArray array = new JSONArray();
                JSONObject json = new JSONObject();
                json.put("$in", instr);
                JSONObject jsn = new JSONObject();
                jsn.put(masterkey, json);
                array.add(jsn);
                jsn = new JSONObject();
                jsn.put(masterkey, obj);
                array.add(jsn);
                JSONArray ary = jsonparam.getJSONArray("$and");

                if (ary == null) {
                    jsonparam.put("$and", array);
                }
                else {
                    ary.addAll(array);
                }

                jsonparam.remove(masterkey);
            }
            else {
                JSONObject json = new JSONObject();
                json.put("$in", instr);
                json.put("=", obj);
                jsonparam.put(masterkey, json);
            }
        }
    }

    private String getSalveKey(String slvtable, Class<?> objClass) throws Exception
    {
        Map<String, Class<?>> flds = getSlaveFields(objClass);

        for (String key : flds.keySet()) {
            Class<?> clazz = flds.get(key);

            if (slvtable.equals(AbstractEntityBean.fetchAnnotationTableName(clazz))) {
                String slavekey = (String) getMasterSlaveField(clazz).get(null);
                return slavekey;
            }
        }

        return null;
    }

    @SuppressWarnings("unchecked")
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception
    {
        // 根据 slavetables 来指定查询某个子表 2017-5-18 by zhouwd
        String slavetables = null;
        String ignorefilter = getParamWithCheck(jsonparam, "ignorefilter", false, "N");

        if (jsonparam.containsKey("ignorefilter")) {
            jsonparam.remove("ignorefilter");
        }

        if (!StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_SLAVETABLE))) {
            slavetables = (String) jsonparam.get(BeanConstant.QueryField.PARAMKEY_SLAVETABLE);
            //如果传入了分页参数，则补全其中明细项,补全查询字段，对于没有指定的明细项查出所有,
            slavetables = makeSlavetables(objClass, slavetables);
            jsonparam.remove(BeanConstant.QueryField.PARAMKEY_SLAVETABLE);
        }

        // 主从字段名
        String masterkey = null;
        Field fld = getMasterSlaveField(objClass);

        if (fld != null) {
            masterkey = (String) fld.get(null);
        }

        // 检查是否存在子表查询条件,存在则进行转换
        if (jsonparam != null && !StringUtils.isEmpty(masterkey)) {
            // 生成子表条件
            List<String> removekeys = new ArrayList<String>();

            for (String qkey : jsonparam.keySet()) {
                if (qkey.indexOf(":") <= 0) {
                    continue;
                }

                removekeys.add(qkey);
            }

            for (String qkey : removekeys) {
                formatSlaveCondition(jsonparam.get("ent_id"), jsonparam, objClass, masterkey, qkey);
            }

            // $or 多子表查询
            if (jsonparam.containsKey("$or") && jsonparam.get("$or") instanceof JSONArray) {
                JSONArray arr_or = jsonparam.getJSONArray("$or");

                for (int i = 0; i < arr_or.size(); i++) {
                    removekeys.clear();
                    JSONObject json = arr_or.getJSONObject(i);

                    for (String qkey : json.keySet()) {
                        if (qkey.indexOf(":") <= 0) {
                            continue;
                        }

                        removekeys.add(qkey);
                    }

                    for (String qkey : removekeys) {
                        formatSlaveCondition(jsonparam.get("ent_id"), json, objClass, masterkey, qkey);
                    }
                }
            }

            // $and 多子表查询
            if (jsonparam.containsKey("$and") && jsonparam.get("$and") instanceof JSONArray) {
                JSONArray arr_or = jsonparam.getJSONArray("$and");

                for (int i = 0; i < arr_or.size(); i++) {
                    removekeys.clear();
                    JSONObject json = arr_or.getJSONObject(i);

                    for (String qkey : json.keySet()) {
                        if (qkey.indexOf(":") <= 0) {
                            continue;
                        }

                        removekeys.add(qkey);
                    }

                    for (String qkey : removekeys) {
                        formatSlaveCondition(jsonparam.get("ent_id"), json, objClass, masterkey, qkey);
                    }
                }
            }
        }

        // 查询主表
        List<?> masterList = super.doGet(jsonparam, objClass, total);

        if (masterList == null || masterList.size() <= 0) {
            return masterList;
        }

        if ("N".equals(ignorefilter)) {
            masterList = (List<?>) filter(masterList, objClass);
        }

        // 得到主表关联字段
        if (StringUtils.isEmpty(masterkey)) {
            return masterList;
        }

        //Field masterFld = AbstractEntityBean.fetchDeclaredField(objClass, masterkey);
        Field[] masterFlds = AbstractEntityBean.fetchDeclaredFields(objClass, masterkey);

        //带分页参数的 ，查询结果按List<Map<String,Object>>处理
        if (!StringUtils.isEmpty(slavetables)) {
            masterList = makelist(masterList);
        }

        // 得到从表集合查询
        Map<String, Class<?>> flds = getSlaveFields(objClass);

        for (String key : flds.keySet()) {
            // 指定字段中没有该从表则不查询,否则可指定从表字段(SLAVETABLE:FIELD|FIELD|...)
            int page_no = -1, page_size = -1;
            String slaveField = null;

            if (!StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS))
                || !StringUtils.isEmpty(slavetables)) {
                String slavetable = null;

                if (!StringUtils.isEmpty(slavetables)) {
                    if (slavetables.indexOf(key) < 0) {
                        continue;
                    }

                    slavetable = slavetables;
                }
                else {
                    if (jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS).indexOf(key) < 0) {
                        continue;
                    }

                    slavetable = jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS);
                }

                slaveField = StorageUtils.parseChildParamKeyFields(slavetable, key);

                // 检查是否有分页字段
                if (!StringUtils.isEmpty(slaveField)) {
                    StringBuffer sb = new StringBuffer();
                    String[] ss = slaveField.split(",");

                    for (int i = 0; i < ss.length; i++) {
                        if (ss[i].toLowerCase().startsWith("page_no=")) {
                            page_no = Integer.parseInt((ss[i].split("="))[1]);
                        }
                        else if (ss[i].toLowerCase().startsWith("page_size=")) {
                            page_size = Integer.parseInt((ss[i].split("="))[1]);
                        }
                        else {
                            sb.append(ss[i] + ",");
                        }
                    }

                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }

                    slaveField = sb.toString();

                    if (page_size > 0 && page_no <= 0) {
                        page_no = 1;
                    }
                }
            }
            else {
                // total != null表示是search方式,如果没有指定子表则不查询子表
                if (total != null) {
                    continue;
                }
            }

            // 从表类型
            Class<?> clazz = flds.get(key);
            String slavekey = (String) getMasterSlaveField(clazz).get(null);
            Field slavefld = AbstractEntityBean.fetchDeclaredField(objClass, key);
            Field[] slavekeys = AbstractEntityBean.fetchDeclaredFields(clazz, slavekey);
            slavefld.setAccessible(true);

            // 查询从表
            for (Object obj : masterList) {
                StringBuffer sbtotal = null;
                JSONObject json = new JSONObject();

                if (page_no > 0 && page_size > 0) {
                    json.put(BeanConstant.QueryField.PARAMKEY_PAGENO, page_no);
                    json.put(BeanConstant.QueryField.PARAMKEY_PAGESIZE, page_size);
                    sbtotal = new StringBuffer();
                }

                String orderFld = "";
                orderFld = getOrderFld(clazz);

                if (!StringUtils.isEmpty(orderFld)) {
                    json.put(BeanConstant.QueryField.PARAMKEY_ORDERFLD, orderFld);
                    String orderDir = "";
                    orderDir = getOrderDir(clazz);

                    if (!StringUtils.isEmpty(orderDir)) {
                        json.put(BeanConstant.QueryField.PARAMKEY_ORDERDIR, orderDir);
                    }
                }
                else {
                    json.put(BeanConstant.QueryField.PARAMKEY_ORDERFLD, getIdKey(clazz));
                }

                if (!StringUtils.isEmpty(slaveField)) {
                    json.put(BeanConstant.QueryField.PARAMKEY_FIELDS, slaveField);
                }

                if (obj instanceof AbstractEntityBean) {
                    AbstractEntityBean bean = (AbstractEntityBean) obj;
                    json.put("ent_id", bean.getEnt_id());

                    //					for(Field masterFld : masterFlds){
                    //						Object masterval = masterFld.get(bean);
                    //						json.put(slavekey, masterval);
                    //					}
                    for (int i = 0; i < masterFlds.length; i++) {
                        Field masterFld = masterFlds[i];
                        Object masterval = masterFld.get(bean);
                        json.put(slavekeys[i].getName(), masterval);
                    }

                    if (!StringUtils.isEmpty(slaveField)) {
                        List<?> lst = super.doSearchForMap(json, clazz, sbtotal);

                        if ("N".equals(ignorefilter)) {
                            lst = (List<?>) filter(lst, clazz);
                        }

                        if (lst != null) {
                            slavefld.set(bean, StorageUtils.toJavaObject(lst, clazz));
                        }
                    }
                    else {
                        List<?> lst = super.doSearch(json, clazz, sbtotal);

                        if ("N".equals(ignorefilter)) {
                            lst = (List<?>) filter(lst, clazz);
                        }

                        slavefld.set(bean, lst);
                    }
                }
                else if (obj instanceof Map) {
                    Map<String, Object> map = (Map<String, Object>) obj;
                    json.put("ent_id", map.containsKey("ent_id") ? map.get("ent_id") : jsonparam.get("ent_id"));

                    //					json.put(slavekey, map.get(masterkey));
                    for (int i = 0; i < masterFlds.length; i++) {
                        Field masterFld = masterFlds[i];
                        json.put(slavekeys[i].getName(), map.get(masterFld.getName()));
                    }

                    List<?> lst = super.doSearchForMap(json, clazz, sbtotal);

                    if ("N".equals(ignorefilter)) {
                        lst = (List<?>) filter(lst, clazz);
                    }

                    map.put(key, lst);

                    if (sbtotal != null) {
                        map.put(key + "_total_results", Long.parseLong(sbtotal.toString()));
                    }
                }
            }
        }

        //单据定制化的明细查询，以$标记
        if (!StringUtils.isEmpty(slavetables)) {
            String[] slavearr = slavetables.split(",");

            for (String spec : slavearr) {
                String[] specarr = spec.split(":");

                if (specarr.length > 1) {
                    if (specarr[0].charAt(0) == '$') {
                        String speckey = specarr[0].substring(1);

                        if (specarr[1].indexOf("slave") >= 0) {
                            String param[] = specarr[1].split("\\|");
                            JSONObject searchparam = new JSONObject();
                            String tablename = null;

                            for (String para : param) {
                                String[] par = para.split("=");

                                if (par.length > 1) {
                                    if (par[0].equals("slave")) {
                                        tablename = par[1];
                                        continue;
                                    }
                                    else {
                                        searchparam.put(par[0], par[1]);
                                    }
                                }
                            }

                            if (StringUtils.isEmpty(tablename)) {
                                continue;
                            }

                            Class<?> clazz = flds.get(tablename);
                            String slavekey = (String) getMasterSlaveField(clazz).get(null);
                            StringBuffer sbtotal = new StringBuffer();

                            for (Object obj : masterList) {
                                if (obj instanceof Map) {
                                    Map<String, Object> map = (Map<String, Object>) obj;
                                    searchparam.put(slavekey, map.get(masterkey));
                                    searchparam.put("ent_id", map.containsKey("ent_id") ? map.get("ent_id") : jsonparam.get("ent_id"));
                                    List<?> lst = super.doSearchForMap(searchparam, clazz, sbtotal);

                                    if ("N".equals(ignorefilter)) {
                                        lst = (List<?>) filter(lst, clazz);
                                    }

                                    map.put(speckey, lst);
                                    map.put(speckey + "_total_results", Long.parseLong(sbtotal.toString()));
                                }
                            }
                        }
                    }
                }
            }
        }

        return masterList;
    }

    protected String convertOperator(String s)
    {
        if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s)) {
            return "in";
        }

        if ("$nin".equalsIgnoreCase(s) || "notin".equalsIgnoreCase(s)) {
            return "not in";
        }

        if ("$is".equalsIgnoreCase(s) || "==".equalsIgnoreCase(s) || "=".equalsIgnoreCase(s)) {
            return "=";
        }

        if ("$ne".equalsIgnoreCase(s) || "<>".equalsIgnoreCase(s) || "!=".equalsIgnoreCase(s)) {
            return "<>";
        }

        if ("like".equalsIgnoreCase(s)) {
            return "like";
        }

        if ("$gt".equalsIgnoreCase(s) || ">".equalsIgnoreCase(s)) {
            return ">";
        }

        if ("$gte".equalsIgnoreCase(s) || ">=".equalsIgnoreCase(s)) {
            return ">=";
        }

        if ("$lt".equalsIgnoreCase(s) || "<".equalsIgnoreCase(s)) {
            return "<";
        }

        if ("$lte".equalsIgnoreCase(s) || "<=".equalsIgnoreCase(s)) {
            return "<=";
        }

        return s;
    }

    protected Field getMasterSlaveField(Class<?> cl)
    {
        return AbstractEntityBean.fetchDeclaredField(cl, "MASTER_SLAVE_KEY");
    }

    protected Map<String, Class<?>> getSlaveFields(Class<?> masterClazz) throws Exception
    {
        Map<String, Class<?>> map = new HashMap<String, Class<?>>();
        // 找到从表字段
        Field[] fields = masterClazz.getDeclaredFields();

        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            Type type = field.getGenericType();

            if (type instanceof ParameterizedType) {
                // 获取泛型类型的泛型参数
                ParameterizedType parameterizedType = (ParameterizedType) type;
                type = parameterizedType.getActualTypeArguments()[0];
                Field fld = getMasterSlaveField((Class<?>) type);

                if (fld == null) {
                    continue;
                }

                String slavekey = (String) fld.get(null);

                if (StringUtils.isEmpty(slavekey)) {
                    continue;
                }

                map.put(field.getName(), (Class<?>) type);
            }
        }

        return map;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void doDeleteBefore(AbstractEntityBean bean, ServiceSession session) throws Exception
    {
    }


    public String makeSlavetables(Class<?> objClass, String slavetables) throws Exception
    {
        String tempSlavetables = "," + slavetables + ",";
        String result = slavetables;
        Field[] fields = objClass.getDeclaredFields();

        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            Type type = field.getGenericType();

            if (type instanceof ParameterizedType) {
                String fieldname = getfieldname(field.getName());

                if (tempSlavetables.indexOf("," + fieldname + ",") < 0 && tempSlavetables.indexOf("," + fieldname + ":") < 0) {
                    result = result + "," + fieldname;
                }
            }
        }

        return result;
    }

    private String getfieldname(String fieldname)
    {
        if (fieldname.split("[.]").length != 0) {
            String[] sa = fieldname.split("[.]");
            return sa[sa.length - 1];
        }

        return "";
    }

    private List<Map<String, Object>> makelist(List<?> masterList) throws Exception
    {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();

        for (Object obj : masterList) {
            if (obj instanceof AbstractEntityBean) {
                Map<String, Object> row = (Map<String, Object>) Utils.toNormalJSONObject(obj);
                result.add(row);
            }
            else if (obj instanceof Map) {
                Map<String, Object> map = (Map<String, Object>) obj;
                result.add(map);
            }
        }

        return result;
    }

    public JSONArray beforeMasterSavebatch(ServiceSession session, JSONArray jsonarray) throws Exception
    {
        for (int i = 0; i < jsonarray.size(); i++) {
            JSONObject json = jsonarray.getJSONObject(i);
            beforeMasterSave(session, json);
        }

        return jsonarray;
    }

    public JSONObject beforeMasterSave(ServiceSession session, JSONObject json) throws Exception
    {
        return json;
    }

    public void afterMasterSavebatch(ServiceSession session, JSONArray jsonarray) throws Exception
    {
        for (int i = 0; i < jsonarray.size(); i++) {
            JSONObject json = jsonarray.getJSONObject(i);
            afterMasterSave(session, json);
        }
    }

    public void afterMasterSave(ServiceSession session, JSONObject json) throws Exception
    {
    }

    @Override
    public void postBeanChangeEvent(String oper, String usercode, String username, AbstractEntityBean originalbean, AbstractEntityBean newbean,
                                    String type) throws Exception
    {
        //bean类型 主表-按字段单行记录，从表-按行所有记录合并一行记录，主表记录过新增删除，从表不在记录日志
        String beanType = "";

        if (newbean.getClass().equals(this.getBeanClass())) {
            beanType = BEANTYPE.MASTER;
        }
        else {
            beanType = BEANTYPE.SLAVE;
        }

        super.postBeanChangeEvent(oper, usercode, username, originalbean, newbean, beanType);
    }

    @Override
    public ServiceResponse getslave(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        if (StringUtils.isEmpty(jsonparam.get("slave"))) {
            throw new ServiceException(ResponseCode.FAILURE, "{0} is null", "slave");
        }

        String slave = jsonparam.getString("slave");
        jsonparam.remove("slave");
        StringBuffer sbtotal = new StringBuffer();

        if (StringUtils.isEmpty(jsonparam.get("ent_id"))) {
            jsonparam.put("ent_id", session.getEnt_id());
        }

        Map<String, Class<?>> flds = getSlaveFields(getBeanClass());// 从表类型
        Class<?> clazz = flds.get(slave);
        List<?> lst = super.doSearchForMap(jsonparam, clazz, sbtotal);
        JSONObject json = new JSONObject();
        json.put(slave, lst);
        json.put("total_results", sbtotal.toString());
        return ServiceResponse.buildSuccess(json);
    }
}
