package com.efuture.ocp.common.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * xzw 调整 
 * @author xzw
 *
 */
public class GzipRequestWrapper extends HttpServletRequestWrapper {

	public GzipRequestWrapper(HttpServletRequest request) {
		super(request);
	}

	@Override
	public ServletInputStream getInputStream() throws IOException {
		return new GZIPServletInputStream(super.getInputStream());
	}

	@Override
	public BufferedReader getReader() throws IOException {
		return new BufferedReader(new InputStreamReader(new GZIPServletInputStream(super.getInputStream())));
	}

	class GZIPServletInputStream extends ServletInputStream {
		private InputStream input;

		public GZIPServletInputStream(InputStream input) throws IOException {
			this.input = new GZIPInputStream(input);
		}

		@Override
		public int read() throws IOException {
			return input.read();
		}

		@Override
		public boolean isFinished() {
			boolean finished = false;
			try {
				if (input.available() == 0) {
					finished = true;
				}
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
			return finished;
		}

		@Override
		public boolean isReady() {
			boolean ready = false;
			try {
				if (input.available() > 0) {
					ready = true;
				}
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
			return ready;
		}

		@Override
		public void setReadListener(ReadListener listener) {
		}
	}
}

//
//package com.efuture.ocp.common.filter;
//
//import java.io.IOException;
//import java.util.zip.GZIPInputStream;
//
//import javax.servlet.ServletInputStream;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletRequestWrapper;
//
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//public class GzipRequestWrapper extends HttpServletRequestWrapper
//{
//    public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
//    private HttpServletRequest request;
//
//    public GzipRequestWrapper(HttpServletRequest request)
//    {
//        super(request);
//        this.request = request;
//    }
//
//    @Override
//    public ServletInputStream getInputStream() throws IOException
//    {
//        ServletInputStream stream = request.getInputStream();
//        
//        try
//        {
//            final GZIPInputStream gzipInputStream = new GZIPInputStream(stream);
//
//            ServletInputStream newStream = new ServletInputStream()
//            {
//                @Override
//                public int read() throws IOException
//                {
//                    return gzipInputStream.read();
//                }
//            };
//            return newStream;
//        }
//        catch (Exception e)
//        {
//            LOGGER.debug("ungzip request fail.", e);
//        }
//        return stream;
//    }
//}
