package com.efuture.ocp.common.proxy;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.util.DataUtils;
import org.springframework.util.StringUtils;

public class EnterpriseProxyBase extends BasicComponent
{
    protected EnterpriseConfigBean ent;
    protected JSONObject proxyObjects;
    protected JSONObject srvConfig;
    protected String bizKey;
    protected String mktBizKey;

    public String getBizKey()
    {
        return bizKey;
    }

    public void setBizKey(String bizKey)
    {
        this.bizKey = bizKey;
    }

    public String getMktBizKey() {
        return mktBizKey;
    }

    public void setMktBizKey(String mktBizKey) {
        this.mktBizKey = mktBizKey;
    }

    protected void setEnterpise(EnterpriseConfigBean entConfig)
    {
        ent = entConfig;
        ent.setBizKey(this.getBizKey());

        try{
            proxyObjects = JSONObject.parseObject(ent.getProxy_objects());
            srvConfig = JSONObject.parseObject(ent.getSrv_para());
        }
        catch (Exception ex)
        {
            ex.printStackTrace();
            srvConfig = new JSONObject();
        }
    }

    protected EnterpriseConfigBean getEnterpise()
    {
        return ent;
    }

//    protected String getProxyObject(String bizKey) throws Exception
//    {
//        if (StringUtils.isEmpty(proxyObjects) || StringUtils.isEmpty(bizKey) || !proxyObjects.containsKey(bizKey))
//        {
//            throw new Exception("PROXY OBJECT IS NULL " + bizKey);
//        }
//        else
//        {
//            return proxyObjects.getString(bizKey);
//        }
//    }

    private String getMktBizExcepKey(String key)
    {
        //return key.concat("_").concat(EnterpriseProxy.getInstance().getBizKey());
        return key.concat("_").concat(DataUtils.nvl(bizKey, EnterpriseProxy.getInstance().getMktBizKey()));
    }

    private String getBizExcepKey(String key)
    {
        //return key.concat("_").concat(EnterpriseProxy.getInstance().getBizKey());
        return key.concat("_").concat(DataUtils.nvl(bizKey, EnterpriseProxy.getInstance().getBizKey()));
    }

    protected String getSrvConfigVal(String key, boolean checkNull, String defValue) throws Exception
    {
        if (StringUtils.isEmpty(srvConfig) || StringUtils.isEmpty(key) || !srvConfig.containsKey(key))
        {
            if (checkNull)
            {
                throw new Exception("PROXY CONFIG IS NULL " + key);
            }
            else
            {
                return defValue;
            }
        }
        else
        {
            return srvConfig.getString(key);
        }
    }

    //取参数顺序 mktBizKey -> Bizkey -> baseKey
    protected String getSrvConfig(String key, boolean checkNull, String defValue) throws Exception
    {
        //return DataUtils.nvl(this.getSrvConfigVal(getBizExcepKey(key), false, null), this.getSrvConfigVal(key, checkNull, defValue));
        String result = this.getSrvConfig(getMktBizExcepKey(key), false, null);
        if (StringUtils.isEmpty(result)) {
            result = this.getSrvConfigVal(getBizExcepKey(key), false, null);
            if (StringUtils.isEmpty(result))
            {
                result = this.getSrvConfigVal(key, checkNull, defValue);
            }
        }
        return result;
    }

    protected String getSrvConfig(String key, boolean checkNull) throws Exception
    {
        return getSrvConfig(key, checkNull, null);
    }

    protected String getBase_url() throws Exception
    {
        return DataUtils.nvl(this.getSrvConfig(getBizExcepKey("baseUrl"), false), getSrvConfig("baseUrl", true));
    }

}
