package com.efuture.ocp.common.sysevent;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationListener;

// 继承类应使用注解@Component注册到spring
abstract public class SystemEventListener<E extends SystemEvent> implements ApplicationListener<E>
{
    protected Logger logger;

    protected Logger getLogger()
    {
        if (logger == null) {
            this.logger = Logger.getLogger(this.getClass().getName());
        }

        return this.logger;
    }

    protected void doneBeforeLog(E event)
    {
        getLogger().info(String.format("[%s] event starting ...", event.getEventMsgTopic()));
    }

    protected void doneAfterLog(E event)
    {
        getLogger().info(String.format("[%s] event finished ...", event.getEventMsgTopic()));
    }

    @Override
    public void onApplicationEvent(E event)
    {
        // 开始日志
        doneBeforeLog(event);

        // 执行事件处理
        onEventDone(event);

        // 结束日志
        doneAfterLog(event);
    }

    // MQ: TaskProducer.produce(ent_id, event.getMsgTopic(), event.getMsgTag(), event.getMsgId(), event.getData());
    abstract protected void onEventDone(E event);
}
