package com.efuture.ocp.common.util;

import com.efuture.omd.storage.mybatis.HashMapCase;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.*;

import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

//@Intercepts({ @Signature(type = ResultSetHandler.class, method = "handleResultSets", args = {Statement.class})})
@Intercepts({ @Signature(type = ResultSetHandler.class,
method = "handleResultSets", args = {Statement.class})})
public class BatisPluginLowerCase implements Interceptor {
	public Object intercept(Invocation invocation) throws Throwable {
		Object target = invocation.getTarget();
		if (target instanceof DefaultResultSetHandler) {
			DefaultResultSetHandler resultSetHandler = (DefaultResultSetHandler)target;
			List<Object> results = resultSetHandler.handleResultSets((Statement)invocation.getArgs()[0]);
			if (results != null) {
				convert(results);
			}
			/*
			String sqlId = mappedStatement.getId();
	        String namespace = sqlId.substring(0, sqlId.indexOf('.'));
	        Executor exe = (Executor) invocation.getTarget();
	        String methodName = invocation.getMethod().getName();
	        */
			//System.out.println(results);
			return results;
		} else {
			return invocation.proceed();
		}
	}
	private void convert(List<Object> data) {
		for(int i = 0; i < data.size(); i ++) {
			Object m = data.get(i);
			if (m instanceof CaseInsensitiveMap || m instanceof HashMapCase) {
				continue;
			} else if(m instanceof Map) {
				Map _m = (Map)m;
				CaseInsensitiveMap r = new CaseInsensitiveMap();
		        for (Iterator<Map.Entry<?,?>> j = _m.entrySet().iterator(); j.hasNext(); ) {
		            Map.Entry<?,?> e = j.next();
		            r.put(e.getKey().toString(),e.getValue());
		        }
				data.set(i, r);
			} else if (m instanceof List) {
				convert((List<Object>)m);
			} else {
				//
			}
		}
	}
	public Object plugin(Object target) {
		return Plugin.wrap(target, this);
	}

	public void setProperties(Properties properties) {

	}
}
