package com.efuture.ocp.common.distributedLock;

import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.CacheUtils;

@Component("dLockHandleByCacheUtils")
@Primary
public class DistributedLockHandleByCacheUtils extends AbstractDistributedLockHandle {

//	@Override
//	public boolean doNaiveCachePut(String key, long id, int lockExpire, int waitMillSeconds)
//	{
//		return CacheUtils.getCacheUtils().AddData(key, id, lockExpire);
//	}
//
//	@Override
//	public void doNaiveCacheDelete(String key) {
//		CacheUtils.getCacheUtils().deleteData(key);
//
//	}
//
//	@Override
//	public long doNaiveCacheGet(String key) {
//		Object val = CacheUtils.getCacheUtils().getData(key);
//		if (val == null) {
//			return 0;
//		}
//		return Long.valueOf(val.toString());
//	}

	@Override
	public boolean doNaiveCachePut(String key, long id, int lockExpire, int waitMillSeconds)
	{
		return CacheUtils.getRedisUtils().tryLock( key, String.valueOf( id ), lockExpire, waitMillSeconds);
	}

	@Override
	public boolean unlock(String key, int lockExpire)
	{
		long id = getThisTransId(key);
		try {
			// 0 重入中，1 解锁完， -1 异常
			int ret = CacheUtils.getRedisUtils().releaseLock(key, lockExpire, String.valueOf(id));
			if (ret == 1)
			{
				clearThisTransId(key);
				return true;
			}
			else if (ret == -1)
			{
				ServiceLogs.debuglog("DistributedLock", "解锁时失败,key["+key+"]", 0);
			}
		} catch (Exception e) {
			ServiceLogs.errLog("DistributedLock", e, "解锁时失败,key[{0}]", key);
		} finally {
			//clearThisTransId(key);
		}
		return false;
	}
	

	@Override
	public boolean unlock(String key)
	{
		return unlock( key, CacheUtils.CacheTimeOut.Min );
	}

	@Override
	public boolean doNaiveCacheDelete(String key)
	{
		return false;
	}

	@Override
	public long doNaiveCacheGet(String key)
	{
		return 0;
	}

}
